/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVIMClientParcel;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRequestParams;
import com.avos.avoscloud.AVResponse;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVSession;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.IntentUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.PushService;
import com.avos.avoscloud.QueryConditions;
import com.avos.avoscloud.SignatureFactory;
import com.avos.avoscloud.im.v2.AVIMBaseBroadcastReceiver;
import com.avos.avoscloud.im.v2.AVIMChatRoom;
import com.avos.avoscloud.im.v2.AVIMClientEventHandler;
import com.avos.avoscloud.im.v2.AVIMClientOpenOption;
import com.avos.avoscloud.im.v2.AVIMConversation;
import com.avos.avoscloud.im.v2.AVIMConversationQuery;
import com.avos.avoscloud.im.v2.AVIMConversationsQuery;
import com.avos.avoscloud.im.v2.AVIMException;
import com.avos.avoscloud.im.v2.AVIMMessageStorage;
import com.avos.avoscloud.im.v2.AVIMOptions;
import com.avos.avoscloud.im.v2.AVIMServiceConversation;
import com.avos.avoscloud.im.v2.AVIMTemporaryConversation;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avoscloud.im.v2.callback.AVIMClientCallback;
import com.avos.avoscloud.im.v2.callback.AVIMClientStatusCallback;
import com.avos.avoscloud.im.v2.callback.AVIMConversationCreatedCallback;
import com.avos.avoscloud.im.v2.callback.AVIMConversationMemberQueryCallback;
import com.avos.avoscloud.im.v2.callback.AVIMConversationQueryCallback;
import com.avos.avoscloud.im.v2.callback.AVIMOnlineClientsCallback;
import com.avos.avoscloud.im.v2.conversation.AVIMConversationMemberInfo;
import com.avos.avoscloud.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AVIMClient {
    String clientId;
    AVIMMessageStorage storage;
    private String tag;
    private String userSessionToken;
    static ConcurrentHashMap<String, AVIMClient> clients = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AVIMConversation> conversationCache = new ConcurrentHashMap();
    volatile boolean isConversationSync = false;
    private static boolean isAutoOpen = true;
    private static int REALTIME_TOKEN_WINDOW_INSECOND = 300;
    private String realtimeSessionToken = null;
    private long realtimeSessionTokenExpired = 0L;
    static AVIMClientEventHandler clientEventHandler;
    static boolean messageQueryCacheEnabled;

    public SignatureFactory getSignatureFactory() {
        return AVIMOptions.getGlobalOptions().getSignatureFactory();
    }

    public static void setSignatureFactory(SignatureFactory factory) {
        AVIMOptions.getGlobalOptions().setSignatureFactory(factory);
    }

    public static void setTimeoutInSecs(int timeoutInSecs) {
        AVIMOptions.getGlobalOptions().setTimeoutInSecs(timeoutInSecs);
    }

    public static void setAutoOpen(boolean isAuto) {
        isAutoOpen = isAuto;
    }

    public static boolean isAutoOpen() {
        return isAutoOpen;
    }

    private AVIMClient(String clientId) {
        this.clientId = clientId;
        this.storage = AVIMMessageStorage.getInstance(clientId);
    }

    public static AVIMClient getInstance(String clientId) {
        if (AVUtils.isBlankString((String)clientId)) {
            throw new IllegalArgumentException("clientId cannot be null.");
        }
        AVIMClient client = clients.get(clientId);
        if (client != null) {
            return client;
        }
        client = new AVIMClient(clientId);
        AVIMClient elderClient = clients.putIfAbsent(clientId, client);
        return elderClient == null ? client : elderClient;
    }

    public static int getClientsCount() {
        return clients.size();
    }

    public static String getDefaultClient() {
        if (AVIMClient.getClientsCount() == 1) {
            return clients.keys().nextElement();
        }
        return "";
    }

    public static AVIMClient getInstance(String clientId, String tag) {
        AVIMClient client = AVIMClient.getInstance(clientId);
        client.tag = tag;
        return client;
    }

    public static AVIMClient getInstance(AVUser user) {
        if (null == user) {
            throw new IllegalArgumentException("user cannot be null.");
        }
        String clientId = user.getObjectId();
        String sessionToken = user.getSessionToken();
        if (AVUtils.isBlankString((String)clientId) || AVUtils.isBlankString((String)sessionToken)) {
            throw new IllegalArgumentException("user must login first.");
        }
        AVIMClient client = AVIMClient.getInstance(clientId);
        client.userSessionToken = sessionToken;
        return client;
    }

    public static AVIMClient getInstance(AVUser user, String tag) {
        AVIMClient client = AVIMClient.getInstance(user);
        client.tag = tag;
        return client;
    }

    public void updateRealtimeSessionToken(String sessionToken, long expireInSec) {
        this.realtimeSessionToken = sessionToken;
        this.realtimeSessionTokenExpired = expireInSec;
    }

    public String getRealtimeSessionToken() {
        return this.realtimeSessionToken;
    }

    boolean realtimeSessionTokenExpired() {
        long now = System.currentTimeMillis() / 1000L;
        return now + (long)REALTIME_TOKEN_WINDOW_INSECOND >= this.realtimeSessionTokenExpired;
    }

    public void open(AVIMClientCallback callback) {
        this.open(null, callback);
    }

    public void open(AVIMClientOpenOption option, AVIMClientCallback callback) {
        boolean ret;
        AVIMClientParcel parcel = new AVIMClientParcel();
        parcel.setClientTag(this.tag);
        parcel.setSessionToken(this.userSessionToken);
        if (null != option) {
            parcel.setReconnection(option.isReconnect());
        } else {
            parcel.setReconnection(false);
        }
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Intent intent, Throwable error) {
                    this.callback.internalDone((Object)AVIMClient.this, (AVException)AVIMException.wrapperAVException(error));
                }
            };
        }
        if (!(ret = this.sendClientCommand(parcel, receiver, Conversation.AVIMOperation.CLIENT_OPEN)) && null != callback) {
            callback.internalDone(this, new AVException(119, "couldn't start service in background."));
        }
    }

    public void getOnlineClients(List<String> clients, AVIMOnlineClientsCallback callback) {
        boolean ret;
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("client.oneline", clients);
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Intent intent, Throwable error) {
                    if (error != null) {
                        this.callback.internalDone(null, (AVException)AVIMException.wrapperAVException(error));
                    } else {
                        ArrayList onlineClients = intent.getStringArrayListExtra("callbackOnlineClient");
                        this.callback.internalDone((Object)onlineClients, null);
                    }
                }
            };
        }
        if (!(ret = this.sendClientCMDToPushService(JSON.toJSONString(params), receiver, Conversation.AVIMOperation.CLIENT_ONLINE_QUERY)) && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void createConversation(List<String> conversationMembers, Map<String, Object> attributes, AVIMConversationCreatedCallback callback) {
        this.createConversation(conversationMembers, null, attributes, false, callback);
    }

    public void createConversation(List<String> conversationMembers, String name, Map<String, Object> attributes, AVIMConversationCreatedCallback callback) {
        this.createConversation(conversationMembers, name, attributes, false, callback);
    }

    public void createConversation(List<String> members, String name, Map<String, Object> attributes, boolean isTransient, AVIMConversationCreatedCallback callback) {
        this.createConversation(members, name, attributes, isTransient, true, callback);
    }

    public void createChatRoom(List<String> conversationMembers, String name, Map<String, Object> attributes, boolean isUnique, AVIMConversationCreatedCallback callback) {
        this.createConversation(conversationMembers, name, attributes, true, isUnique, callback);
    }

    private void createServiceConversation(String name, Map<String, Object> attributes, AVIMConversationCreatedCallback callback) {
        throw new AVRuntimeException("can't invoke createServiceConversation within SDK.", (Throwable)new UnsupportedOperationException());
    }

    public void createTemporaryConversation(List<String> conversationMembers, AVIMConversationCreatedCallback callback) {
        this.createTemporaryConversation(conversationMembers, 259200, callback);
    }

    public void createTemporaryConversation(List<String> conversationMembers, int ttl, AVIMConversationCreatedCallback callback) {
        this.createConversation(conversationMembers, null, null, false, true, true, ttl, callback);
    }

    public void createConversation(List<String> members, String name, Map<String, Object> attributes, boolean isTransient, boolean isUnique, AVIMConversationCreatedCallback callback) {
        this.createConversation(members, name, attributes, isTransient, isUnique, false, 0, callback);
    }

    private void createConversation(List<String> members, String name, Map<String, Object> attributes, final boolean isTransient, boolean isUnique, final boolean isTemp, int tempTTL, AVIMConversationCreatedCallback callback) {
        boolean ret;
        Map<String, Object> assembledAttributes;
        try {
            AVUtils.ensureElementsNotNull(members, (String)"Null id in session id list.");
        }
        catch (Exception e) {
            if (callback != null) {
                callback.internalDone(null, AVIMException.wrapperAVException(e));
            }
            return;
        }
        final HashMap<String, Object> conversationAttributes = new HashMap<String, Object>();
        if (attributes != null) {
            conversationAttributes.putAll(attributes);
        }
        if (!AVUtils.isBlankString((String)name)) {
            conversationAttributes.put("name", name);
        }
        final ArrayList<String> conversationMembers = new ArrayList<String>();
        conversationMembers.addAll(members);
        if (!conversationMembers.contains(this.clientId)) {
            conversationMembers.add(this.clientId);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("conversation.member", conversationMembers);
        params.put("conversation.unique", isTemp || isTransient ? false : isUnique);
        params.put("conversation.transient", isTransient);
        params.put("conversation.temp", isTemp);
        if (isTemp) {
            params.put("conversation.tempTTL", tempTTL);
        }
        if (conversationAttributes.size() > 0 && (assembledAttributes = AVIMConversation.processAttributes(conversationAttributes, true)) != null) {
            params.put("conversation.attributes", assembledAttributes);
        }
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Intent intent, Throwable error) {
                    String conversationId = intent.getExtras().getString("callbackconversation");
                    String createdAt = intent.getExtras().getString("callbackCreatedAt");
                    int tempTTLFromServer = intent.getExtras().getInt("callbackTemporaryTTL", 0);
                    AVIMConversation conversation = null;
                    if (error == null) {
                        conversation = AVIMClient.this.getConversation(conversationId, isTransient, isTemp);
                        conversation.setMembers(conversationMembers);
                        conversation.setAttributesForInit(conversationAttributes);
                        conversation.setTransientForInit(isTransient);
                        conversation.setConversationId(conversationId);
                        conversation.setCreator(AVIMClient.this.clientId);
                        conversation.setCreatedAt(createdAt);
                        conversation.setUpdatedAt(createdAt);
                        conversation.setTemporary(isTemp);
                        conversation.setTemporaryExpiredat(System.currentTimeMillis() / 1000L + (long)tempTTLFromServer);
                        AVIMClient.this.storage.insertConversations(Arrays.asList(conversation));
                    }
                    this.callback.internalDone(conversation, (AVException)AVIMException.wrapperAVException(error));
                }
            };
        }
        if (!(ret = this.sendClientCMDToPushService(JSON.toJSONString(params), receiver, Conversation.AVIMOperation.CONVERSATION_CREATION)) && null != callback) {
            callback.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    public AVIMConversation getConversation(String conversationId) {
        if (StringUtils.isBlankString((String)conversationId)) {
            return null;
        }
        return this.getConversation(conversationId, false, conversationId.startsWith("_tmp:"));
    }

    public AVIMConversation getConversation(String conversationId, int convType) {
        AVIMConversation result = null;
        switch (convType) {
            case 3: {
                result = this.getServiceConversation(conversationId);
                break;
            }
            case 4: {
                result = this.getTemporaryConversation(conversationId);
                break;
            }
            case 2: {
                result = this.getChatRoom(conversationId);
                break;
            }
            default: {
                result = this.getConversation(conversationId);
            }
        }
        return result;
    }

    public AVIMConversation getChatRoom(String conversationId) {
        return this.getConversation(conversationId, true, false);
    }

    public AVIMConversation getServiceConversation(String conversationId) {
        return this.getConversation(conversationId, false, false, true);
    }

    public AVIMConversation getTemporaryConversation(String conversationId) {
        return this.getConversation(conversationId, false, true);
    }

    public AVIMConversation getConversation(String conversationId, boolean isTransient, boolean isTemporary) {
        return this.getConversation(conversationId, isTransient, isTemporary, false);
    }

    private AVIMConversation getConversation(String conversationId, boolean isTransient, boolean isTemporary, boolean isSystem) {
        AVIMConversation conversation;
        if (!this.isConversationSync) {
            this.syncConversationCache();
        }
        if ((conversation = this.conversationCache.get(conversationId)) != null) {
            return conversation;
        }
        if (AVUtils.isBlankString((String)conversationId)) {
            LogUtil.log.w((String)"conversationId is null");
            return null;
        }
        conversation = null;
        conversation = isSystem ? new AVIMServiceConversation(this, conversationId) : (isTemporary || conversationId.startsWith("_tmp:") ? new AVIMTemporaryConversation(this, conversationId) : (isTransient ? new AVIMChatRoom(this, conversationId) : new AVIMConversation(this, conversationId)));
        AVIMConversation elderConversation = this.conversationCache.putIfAbsent(conversationId, conversation);
        return elderConversation == null ? conversation : elderConversation;
    }

    public AVIMConversationQuery getQuery() {
        return new AVIMConversationQuery(this);
    }

    public AVIMConversationsQuery getConversationsQuery() {
        return new AVIMConversationsQuery(this);
    }

    public AVIMConversationsQuery getServiceConversationQuery() {
        AVIMConversationsQuery query = new AVIMConversationsQuery(this);
        query.whereEqualTo("sys", true);
        return query;
    }

    private AVIMConversationsQuery getTemporaryConversationQuery() {
        throw new UnsupportedOperationException("only conversationId query is allowed, please invoke #getTemporaryConversaton with conversationId.");
    }

    public AVIMConversationsQuery getChatRoomQuery() {
        AVIMConversationsQuery query = new AVIMConversationsQuery(this);
        query.whereEqualTo("tr", true);
        return query;
    }

    private void querySubscribedServiceConversations(int limit, AVIMConversationQueryCallback callback) {
        this.querySubscribedServiceConversations(null, 0L, limit, callback);
    }

    private void querySubscribedServiceConversations(String startConversationId, long startConversationTimestamp, int limit, AVIMConversationQueryCallback callback) {
    }

    public static void setClientEventHandler(AVIMClientEventHandler handler) {
        clientEventHandler = handler;
    }

    protected static AVIMClientEventHandler getClientEventHandler() {
        return clientEventHandler;
    }

    public static void setOfflineMessagePush(boolean isOnlyCount) {
        AVIMClient.setUnreadNotificationEnabled(isOnlyCount);
    }

    public static void setUnreadNotificationEnabled(boolean enabled) {
        AVSession.setUnreadNotificationEnabled(enabled);
    }

    public void close(AVIMClientCallback callback) {
        boolean ret;
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Intent intent, Throwable error) {
                    this.callback.internalDone((Object)AVIMClient.this, (AVException)AVIMException.wrapperAVException(error));
                    AVIMClient.this.close();
                }
            };
        }
        if (!(ret = this.sendClientCMDToPushService(null, receiver, Conversation.AVIMOperation.CLIENT_DISCONNECT)) && null != callback) {
            callback.internalDone(this, new AVException(119, "couldn't start service in background."));
        }
    }

    protected void close() {
        clients.remove(this.clientId);
        this.conversationCache.clear();
        this.storage.deleteClientData();
    }

    void queryConversationMemberInfo(final QueryConditions queryConditions, final AVIMConversationMemberQueryCallback cb) {
        if (null == queryConditions || null == cb) {
            return;
        }
        if (!this.realtimeSessionTokenExpired()) {
            this.queryConvMemberThroughNetwork(queryConditions, cb);
        } else {
            LogUtil.log.d((String)"realtime session token expired, start to refresh...");
            AVIMBaseBroadcastReceiver receiver = null;
            receiver = new AVIMBaseBroadcastReceiver(null){

                @Override
                public void execute(Intent intent, Throwable error) {
                    if (null != error) {
                        LogUtil.log.e((String)("failed to refresh realtime session token. cause: " + error.getMessage()));
                        cb.internalDone(null, AVIMException.wrapperAVException(error));
                    } else {
                        AVIMClient.this.queryConvMemberThroughNetwork(queryConditions, cb);
                    }
                }
            };
            boolean ret = this.sendClientCMDToPushService(null, receiver, Conversation.AVIMOperation.CLIENT_REFRESH_TOKEN);
            if (!ret && null != cb) {
                cb.internalDone(null, new AVException(119, "couldn't start service in background."));
            }
        }
    }

    private void queryConvMemberThroughNetwork(QueryConditions queryConditions, final AVIMConversationMemberQueryCallback callback) {
        String queryPath = AVPowerfulUtils.getEndpoint((String)"_ConversationMemberInfo");
        queryConditions.assembleParameters();
        Map queryParams = queryConditions.getParameters();
        queryParams.put("client_id", this.clientId);
        AVRequestParams params = new AVRequestParams(queryParams);
        HashMap<String, String> additionalHeader = new HashMap<String, String>();
        additionalHeader.put("X-LC-IM-Session-Token", this.getRealtimeSessionToken());
        PaasClient.storageInstance().getObject(queryPath, params, false, additionalHeader, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                block3: {
                    try {
                        List result = AVIMClient.this.processResults(content);
                        if (callback != null) {
                            callback.internalDone(result, null);
                        }
                    }
                    catch (Exception ex) {
                        LogUtil.log.e((String)("failed to parse ConversationMemberInfo result, cause: " + ex.getMessage()));
                        if (callback == null) break block3;
                        callback.internalDone(null, new AVIMException(ex));
                    }
                }
            }

            public void onFailure(Throwable error, String content) {
                LogUtil.log.e((String)("failed to fetch ConversationMemberInfo, cause: " + error.getMessage()));
                if (callback != null) {
                    callback.internalDone(null, new AVIMException(content, error));
                }
            }
        }, AVQuery.CachePolicy.NETWORK_ONLY, 86400000L);
    }

    private List<AVIMConversationMemberInfo> processResults(String content) throws Exception {
        if (AVUtils.isBlankContent((String)content)) {
            return Collections.emptyList();
        }
        AVResponse resp = new AVResponse();
        resp = (AVResponse)JSON.parseObject((String)content, resp.getClass());
        LinkedList<AVIMConversationMemberInfo> result = new LinkedList<AVIMConversationMemberInfo>();
        for (Map item : resp.results) {
            if (item == null || item.isEmpty()) continue;
            AVIMConversationMemberInfo object = AVIMConversationMemberInfo.createInstance(item);
            result.add(object);
        }
        return result;
    }

    public void getClientStatus(AVIMClientStatusCallback callback) {
        boolean ret;
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Intent intent, Throwable error) {
                    AVIMClientStatus status = null;
                    if (intent.getExtras() != null && intent.getExtras().containsKey("callbackClientStatus")) {
                        status = AVIMClientStatus.getClientStatus(intent.getExtras().getInt("callbackClientStatus"));
                    }
                    this.callback.internalDone(status, (AVException)AVIMException.wrapperAVException(error));
                }
            };
        }
        if (!(ret = this.sendClientCMDToPushService(null, receiver, Conversation.AVIMOperation.CLIENT_STATUS)) && null != callback) {
            callback.internalDone((Object)AVIMClientStatus.AVIMClientStatusNone, new AVException(119, "could't start service in background."));
        }
    }

    protected boolean sendClientCommand(AVIMClientParcel parcel, BroadcastReceiver receiver, Conversation.AVIMOperation operation) {
        int requestId = AVUtils.getNextIMRequestId();
        if (receiver != null) {
            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(AVOSCloud.applicationContext, PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        i.putExtra("conversation.client.parcel", (Parcelable)parcel);
        i.putExtra("conversation.client", this.clientId);
        i.putExtra("conversation.requestId", requestId);
        i.putExtra("conversation.operation", operation.getCode());
        try {
            AVOSCloud.applicationContext.startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LogUtil.avlog.e((String)("failed to startService. cause: " + ex.getMessage()));
            return false;
        }
        return true;
    }

    protected boolean sendClientCMDToPushService(String dataAsString, BroadcastReceiver receiver, Conversation.AVIMOperation operation) {
        int requestId = AVUtils.getNextIMRequestId();
        if (receiver != null) {
            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(AVOSCloud.applicationContext, PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (!AVUtils.isBlankString((String)dataAsString)) {
            i.putExtra("conversation.data", dataAsString);
        }
        i.putExtra("conversation.client", this.clientId);
        i.putExtra("conversation.requestId", requestId);
        i.putExtra("conversation.operation", operation.getCode());
        try {
            AVOSCloud.applicationContext.startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LogUtil.avlog.e((String)("failed to startService. cause: " + ex.getMessage()));
            return false;
        }
        return true;
    }

    static AVException validateNonEmptyConversationMembers(List<String> members) {
        if (members == null || members.isEmpty()) {
            return new AVException(999, "Conversation can't be created with empty members");
        }
        try {
            AVUtils.ensureElementsNotNull(members, (String)"Null id in session id list.");
        }
        catch (Exception e) {
            return new AVException((Throwable)e);
        }
        return null;
    }

    private void syncConversationCache() {
        try {
            List<AVIMConversation> cachedConversations = this.storage.getAllCachedConversations();
            for (AVIMConversation conversation : cachedConversations) {
                this.conversationCache.put(conversation.getConversationId(), conversation);
            }
        }
        catch (Exception ex) {
            LogUtil.avlog.d((String)("failed to initialize cached conversations. cause:" + ex.getMessage()));
        }
        this.isConversationSync = true;
    }

    protected void removeConversationCache(AVIMConversation conversation) {
        this.conversationCache.remove(conversation.getConversationId());
    }

    AVIMConversation mergeConversationCache(AVIMConversation allNewConversation, boolean forceReplace, JSONObject deltaObject) {
        if (null == allNewConversation || StringUtils.isBlankString((String)allNewConversation.getConversationId())) {
            return null;
        }
        String convId = allNewConversation.getConversationId();
        if (forceReplace) {
            this.conversationCache.put(convId, allNewConversation);
            return allNewConversation;
        }
        AVIMConversation origin = this.conversationCache.get(convId);
        if (null == origin) {
            this.conversationCache.put(convId, allNewConversation);
            origin = allNewConversation;
        } else {
            origin = AVIMConversation.updateConversation(origin, deltaObject);
        }
        return origin;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        AVIMClient anotherClient = (AVIMClient)object;
        if (this.clientId == null) {
            return anotherClient.clientId == null;
        }
        return this.clientId.equals(anotherClient.clientId);
    }

    public static void setMessageQueryCacheEnable(boolean enable) {
        messageQueryCacheEnabled = enable;
    }

    static {
        messageQueryCacheEnabled = true;
    }

    public static enum AVIMClientStatus {
        AVIMClientStatusNone(110),
        AVIMClientStatusOpened(111),
        AVIMClientStatusPaused(120);

        int code;

        private AVIMClientStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static AVIMClientStatus getClientStatus(int code) {
            switch (code) {
                case 110: {
                    return AVIMClientStatusNone;
                }
                case 111: {
                    return AVIMClientStatusOpened;
                }
                case 120: {
                    return AVIMClientStatusPaused;
                }
            }
            return null;
        }
    }
}

