/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.AsyncTask;
import android.os.Build;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVSessionCacheHelper;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.Signature;
import com.avos.avoscloud.SignatureCallback;

class SignatureTask
extends AsyncTask<String, Integer, Signature> {
    SignatureCallback callback;
    AVException signatureException = null;

    public SignatureTask(SignatureCallback callback) {
        this.callback = callback;
    }

    protected Signature doInBackground(String ... params) {
        Signature signature;
        String clientId = params[0];
        if (this.callback.useSignatureCache()) {
            signature = AVSessionCacheHelper.SignatureCache.getSessionSignature(clientId);
            if (signature != null && !signature.isExpired()) {
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.d((String)"get signature from cache");
                }
                return signature;
            }
            if (AVOSCloud.isDebugLogEnabled()) {
                LogUtil.avlog.d((String)"signature expired");
            }
        }
        try {
            signature = this.callback.computeSignature();
            if (this.callback.cacheSignature()) {
                AVSessionCacheHelper.SignatureCache.addSessionSignature(clientId, signature);
            }
            return signature;
        }
        catch (Exception e) {
            this.signatureException = new AVException((Throwable)e);
            return null;
        }
    }

    protected void onPostExecute(Signature result) {
        this.callback.onSignatureReady(result, this.signatureException);
    }

    public AsyncTask<String, Integer, Signature> commit(String ... params) {
        if (Build.VERSION.SDK_INT >= 11) {
            return this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, params);
        }
        return this.execute(params);
    }
}

