/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.Signature;
import com.avos.avoscloud.SignatureFactory;
import java.util.HashMap;
import java.util.List;

public class AVUserSignatureFactory
implements SignatureFactory {
    private static final String RTM_SIGN_ENDPOINT = "rtm/sign";
    private String sessionToken;

    public AVUserSignatureFactory(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public Signature createSignature(String peerId, List<String> watchIds) throws SignatureFactory.SignatureException {
        final StringBuffer stringBuffer = new StringBuffer();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("session_token", this.sessionToken);
        PaasClient.storageInstance().postObject(RTM_SIGN_ENDPOINT, JSON.toJSONString(data), true, false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (e != null) {
                    AVExceptionHolder.add((AVException)new SignatureFactory.SignatureException(4102, "failed to create signature. cause:" + e.getMessage()));
                } else {
                    stringBuffer.append(content);
                }
            }

            public void onFailure(Throwable error, String content) {
                AVExceptionHolder.add((AVException)new SignatureFactory.SignatureException(4102, content));
            }
        }, null, null);
        if (AVExceptionHolder.exists()) {
            throw (SignatureFactory.SignatureException)AVExceptionHolder.remove();
        }
        return this.parseSiparseSignaturegnature(stringBuffer.toString());
    }

    @Override
    public Signature createGroupSignature(String groupId, String peerId, List<String> targetPeerIds, String action) throws SignatureFactory.SignatureException {
        return null;
    }

    @Override
    public Signature createConversationSignature(String conversationId, String clientId, List<String> targetIds, String action) throws SignatureFactory.SignatureException {
        return null;
    }

    @Override
    public Signature createBlacklistSignature(String clientId, String conversationId, List<String> memberIds, String action) throws SignatureFactory.SignatureException {
        return null;
    }

    private Signature parseSiparseSignaturegnature(String content) throws SignatureFactory.SignatureException {
        if (AVUtils.isBlankString((String)content)) {
            throw new SignatureFactory.SignatureException(4102, "singnature is empty");
        }
        Signature signature = new Signature();
        try {
            JSONObject jsonObject = JSON.parseObject((String)content);
            signature.setNonce(jsonObject.getString("nonce"));
            signature.setSignature(jsonObject.getString("signature"));
            signature.setTimestamp(jsonObject.getLong("timestamp"));
        }
        catch (Exception e) {
            throw new SignatureFactory.SignatureException(4102, "singnature content parse error: " + content);
        }
        return signature;
    }
}

