/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVLiveQuery;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVUser;
import java.util.List;

public abstract class AVLiveQueryEventHandler {
    public void done(AVLiveQuery.EventType eventType, AVObject avObject, List<String> updateKeyList) {
        switch (eventType) {
            case ENTER: {
                this.onObjectEnter(avObject, updateKeyList);
                break;
            }
            case UPDATE: {
                this.onObjectUpdated(avObject, updateKeyList);
                break;
            }
            case DELETE: {
                this.onObjectDeleted(avObject.getObjectId());
                break;
            }
            case LEAVE: {
                this.onObjectLeave(avObject, updateKeyList);
                break;
            }
            case LOGIN: {
                if (!(avObject instanceof AVUser)) break;
                this.onUserLogin((AVUser)avObject);
                break;
            }
            case CREATE: {
                this.onObjectCreated(avObject);
            }
        }
    }

    public void onObjectCreated(AVObject avObject) {
    }

    public void onObjectUpdated(AVObject avObject, List<String> updateKeyList) {
    }

    public void onObjectEnter(AVObject avObject, List<String> updateKeyList) {
    }

    public void onObjectLeave(AVObject avObject, List<String> updateKeyList) {
    }

    public void onObjectDeleted(String objectId) {
    }

    public void onUserLogin(AVUser user) {
    }
}

