/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.SparseArray;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.BroadcastUtil;
import com.avos.avoscloud.im.v2.AVIMOptions;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avospush.session.MessageQueue;
import java.util.concurrent.ConcurrentHashMap;

class AVIMOperationQueue {
    static ConcurrentHashMap<Integer, Runnable> timeoutCache = new ConcurrentHashMap();
    static HandlerThread timeoutHandlerThread = new HandlerThread("com.avos.avoscloud.im.v2.timeoutHandlerThread");
    static Handler timeoutHandler;
    SparseArray<Operation> cache = new SparseArray();
    MessageQueue<Operation> operationQueue;

    public AVIMOperationQueue(String key) {
        this.operationQueue = new MessageQueue<Operation>("operation.queue." + key, Operation.class);
        this.setupCache();
    }

    private void setupCache() {
        for (Operation op : this.operationQueue) {
            if (op.requestId == -65537) continue;
            this.cache.put(op.requestId, (Object)op);
        }
    }

    public void offer(final Operation op) {
        if (op.requestId != -65537) {
            this.cache.put(op.requestId, (Object)op);
            Runnable timeoutTask = new Runnable(){

                @Override
                public void run() {
                    Operation polledOP = AVIMOperationQueue.this.poll(op.requestId);
                    if (polledOP != null) {
                        Conversation.AVIMOperation operation = Conversation.AVIMOperation.getAVIMOperation(polledOP.operation);
                        BroadcastUtil.sendIMLocalBroadcast(polledOP.sessionId, polledOP.conversationId, polledOP.requestId, new AVException(124, "Timeout Exception"), operation);
                    }
                }
            };
            timeoutCache.put(op.requestId, timeoutTask);
            timeoutHandler.postDelayed(timeoutTask, (long)(AVIMOptions.getGlobalOptions().getTimeoutInSecs() * 1000));
        }
        this.operationQueue.offer(op);
    }

    public Operation poll(int requestId) {
        if (requestId != -65537 && this.cache.get(requestId) != null) {
            Operation returnValue = (Operation)this.cache.get(requestId);
            this.cache.remove(requestId);
            this.operationQueue.remove(returnValue);
            Runnable timeoutTask = timeoutCache.get(requestId);
            timeoutCache.remove(requestId);
            if (timeoutTask != null) {
                timeoutHandler.removeCallbacks(timeoutTask);
            }
            return returnValue;
        }
        return this.poll();
    }

    public Operation poll() {
        return this.operationQueue.poll();
    }

    public void clear() {
        this.operationQueue.clear();
        this.cache.clear();
    }

    public boolean isEmpty() {
        return this.operationQueue.isEmpty();
    }

    static {
        timeoutHandlerThread.start();
        timeoutHandler = new Handler(timeoutHandlerThread.getLooper());
    }

    public static class Operation {
        int requestId;
        int operation;
        String sessionId;
        String conversationId;

        public static Operation getOperation(int operation, String sessionId, String conversationId, int requestId) {
            Operation op = new Operation();
            op.conversationId = conversationId;
            op.sessionId = sessionId;
            op.operation = operation;
            op.requestId = requestId;
            return op;
        }
    }
}

