/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMMessageOption;
import com.avos.avospush.session.PeerBasedCommandPacket;
import com.google.protobuf.ByteString;
import java.util.List;

public class ConversationDirectMessagePacket
extends PeerBasedCommandPacket {
    String conversationId;
    String message = null;
    boolean mentionAll = false;
    List<String> mentionList = null;
    String messageToken = null;
    AVIMMessageOption messageOption;
    ByteString binaryMessage = null;

    public ConversationDirectMessagePacket() {
        this.setCmd("direct");
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private void setMessageOption(AVIMMessageOption option) {
        this.messageOption = option;
    }

    public boolean isMentionAll() {
        return this.mentionAll;
    }

    public void setMentionAll(boolean mentionAll) {
        this.mentionAll = mentionAll;
    }

    public List<String> getMentionList() {
        return this.mentionList;
    }

    public void setMentionList(List<String> mentionList) {
        this.mentionList = mentionList;
    }

    public void setBinaryMessage(byte[] bytes) {
        this.binaryMessage = null == bytes ? null : ByteString.copyFrom((byte[])bytes);
    }

    @Override
    protected Messages.GenericCommand.Builder getGenericCommandBuilder() {
        Messages.GenericCommand.Builder builder = super.getGenericCommandBuilder();
        builder.setDirectMessage(this.getDirectCommand());
        if (null != this.messageOption && null != this.messageOption.getPriority()) {
            builder.setPriority(this.messageOption.getPriority().getNumber());
        }
        return builder;
    }

    protected Messages.DirectCommand getDirectCommand() {
        Messages.DirectCommand.Builder builder = Messages.DirectCommand.newBuilder();
        if (null != this.message) {
            builder.setMsg(this.message);
        }
        builder.setCid(this.conversationId);
        if (this.mentionAll) {
            builder.setMentionAll(this.mentionAll);
        }
        if (null != this.mentionList && this.mentionList.size() > 0) {
            builder.addAllMentionPids(this.mentionList);
        }
        if (null != this.messageOption) {
            String pushData;
            if (this.messageOption.isReceipt()) {
                builder.setR(true);
            }
            if (this.messageOption.isTransient()) {
                builder.setTransient(true);
            }
            if (!AVUtils.isBlankString((String)(pushData = this.messageOption.getPushData()))) {
                builder.setPushData(pushData);
            }
            if (this.messageOption.isWill()) {
                builder.setWill(true);
            }
        }
        if (!AVUtils.isBlankString((String)this.messageToken)) {
            builder.setDt(this.messageToken);
        }
        if (null != this.binaryMessage) {
            builder.setBinaryMsg(this.binaryMessage);
        }
        return builder.build();
    }

    public static ConversationDirectMessagePacket getConversationMessagePacket(String peerId, String conversationId, String msg, byte[] binaryMsg, boolean mentionAll, List<String> mentionList, AVIMMessageOption messageOption, int requestId) {
        ConversationDirectMessagePacket cdmp = new ConversationDirectMessagePacket();
        if (AVIMClient.getClientsCount() > 1) {
            cdmp.setPeerId(peerId);
        }
        cdmp.setConversationId(conversationId);
        cdmp.setRequestId(requestId);
        cdmp.setMessageOption(messageOption);
        cdmp.setMessage(msg);
        cdmp.setMentionAll(mentionAll);
        cdmp.setMentionList(mentionList);
        cdmp.setBinaryMessage(binaryMsg);
        return cdmp;
    }

    public static ConversationDirectMessagePacket getConversationMessagePacket(String peerId, String conversationId, String msg, byte[] binaryMsg, boolean mentionAll, List<String> mentionList, String messageToken, AVIMMessageOption option, int requestId) {
        ConversationDirectMessagePacket cdmp = ConversationDirectMessagePacket.getConversationMessagePacket(peerId, conversationId, msg, binaryMsg, mentionAll, mentionList, option, requestId);
        cdmp.messageToken = messageToken;
        return cdmp;
    }
}

