/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2.video;

import android.app.Activity;
import android.content.Intent;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;

public class AVIMVideoCapture
implements SurfaceHolder.Callback {
    public static final int REQUEST_VIDEO_CAPTURE = 1;
    private MediaRecorder mediaRecorder = null;
    private SurfaceView surfaceView = null;
    private CamcorderProfile profile = null;
    private String localPath = null;
    private int maxDuration;
    private int maxFileSize;
    private boolean recording = false;

    public static void dispatchTakeVideoIntent(Activity context) {
        Intent takeVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (takeVideoIntent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivityForResult(takeVideoIntent, 1);
        }
    }

    public AVIMVideoCapture(CamcorderProfile profile, String localPath, int maxDuration, int maxFileSize, SurfaceView surfaceView) {
        if (AVUtils.isBlankString((String)localPath)) {
            throw new IllegalArgumentException("local path is empty.");
        }
        if (maxDuration <= 0 || maxFileSize <= 0) {
            throw new IllegalArgumentException("maxDuration and maxFileSize must great than 0.");
        }
        if (null == surfaceView) {
            throw new IllegalArgumentException("SurfaceView is null.");
        }
        this.profile = profile;
        this.localPath = localPath;
        this.maxDuration = maxDuration;
        this.maxFileSize = maxFileSize;
        this.surfaceView = surfaceView;
        this.initRecorder();
    }

    private void initRecorder() {
        this.mediaRecorder = new MediaRecorder();
        this.mediaRecorder.setAudioSource(0);
        this.mediaRecorder.setVideoSource(0);
        this.mediaRecorder.setProfile(this.profile);
        this.mediaRecorder.setOutputFile(this.localPath);
        this.mediaRecorder.setMaxDuration(this.maxDuration);
        this.mediaRecorder.setMaxFileSize((long)this.maxFileSize);
        SurfaceHolder holder = this.surfaceView.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setType(3);
    }

    public void start() {
        if (this.recording) {
            return;
        }
        if (null != this.mediaRecorder) {
            this.mediaRecorder.start();
            this.recording = true;
        }
    }

    public void stop() {
        if (!this.recording) {
            return;
        }
        this.stopRecorder();
        this.recording = false;
        this.initRecorder();
        this.prepareRecorder(this.surfaceView.getHolder());
    }

    private void prepareRecorder(SurfaceHolder holder) {
        this.mediaRecorder.setPreviewDisplay(holder.getSurface());
        try {
            this.mediaRecorder.prepare();
        }
        catch (Exception e) {
            LogUtil.log.e((String)"failed to prepare MediaRecorder. cause: ", (Exception)e);
        }
    }

    private void stopRecorder() {
        if (null != this.mediaRecorder) {
            this.mediaRecorder.stop();
            this.mediaRecorder.release();
            this.mediaRecorder = null;
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.prepareRecorder(holder);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.stopRecorder();
    }
}

