/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2.messages;

import android.os.Parcelable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVHttpClient;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.im.v2.AVIMMessageCreator;
import com.avos.avoscloud.im.v2.AVIMMessageType;
import com.avos.avoscloud.im.v2.messages.AVIMFileMessage;
import com.avos.avoscloud.im.v2.messages.AVIMFileMessageAccessor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Callback;
import okhttp3.Request;

@AVIMMessageType(type=-4)
public class AVIMVideoMessage
extends AVIMFileMessage {
    public static final Parcelable.Creator<AVIMVideoMessage> CREATOR = new AVIMMessageCreator<AVIMVideoMessage>(AVIMVideoMessage.class);

    public AVIMVideoMessage() {
    }

    public AVIMVideoMessage(String localPath) throws IOException {
        super(localPath);
    }

    public AVIMVideoMessage(File localFile) throws IOException {
        super(localFile);
    }

    public AVIMVideoMessage(AVFile file) {
        super(file);
    }

    @Override
    public Map<String, Object> getFileMetaData() {
        if (this.file == null) {
            this.file = new HashMap();
        }
        if (this.file.containsKey("metaData")) {
            return (Map)this.file.get("metaData");
        }
        if (this.localFile != null) {
            Map<String, Object> meta = AVIMFileMessageAccessor.mediaInfo(this.localFile);
            meta.put("size", this.actualFile.getSize());
            this.file.put("metaData", meta);
            return meta;
        }
        if (this.actualFile != null) {
            HashMap meta = this.actualFile.getMetaData();
            this.file.put("metaData", meta);
            return meta;
        }
        return null;
    }

    public double getDuration() {
        Map<String, Object> meta = this.getFileMetaData();
        if (meta != null && meta.containsKey("duration")) {
            return ((Number)meta.get("duration")).doubleValue();
        }
        return 0.0;
    }

    @Override
    protected void getAdditionalMetaData(final Map<String, Object> meta, final SaveCallback callback) {
        if (!AVUtils.isBlankString((String)this.actualFile.getUrl()) && this.localFile == null && !AVIMVideoMessage.isExternalAVFile(this.actualFile)) {
            AVHttpClient client = AVHttpClient.clientInstance();
            Request.Builder builder = new Request.Builder();
            builder.url(this.actualFile.getUrl() + "?avinfo").get();
            client.execute(builder.build(), false, (Callback)new GetHttpResponseHandler(new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    try {
                        JSONObject response = JSON.parseObject((String)content);
                        JSONObject formatInfo = response.getJSONObject("format");
                        String fileFormat = formatInfo.getString("format_name");
                        Double durationInDouble = formatInfo.getDouble("duration");
                        long size = formatInfo.getLong("size");
                        meta.put("size", size);
                        meta.put("duration", durationInDouble);
                        meta.put("format", fileFormat);
                    }
                    catch (Exception e1) {
                        callback.internalDone(new AVException((Throwable)e1));
                    }
                    callback.internalDone(null);
                }

                public void onFailure(Throwable error, String content) {
                    callback.internalDone(new AVException(error));
                }
            }));
        } else {
            callback.internalDone(null);
        }
    }
}

