/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2.messages;

import android.os.Parcelable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVHttpClient;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.im.v2.AVIMMessageCreator;
import com.avos.avoscloud.im.v2.AVIMMessageType;
import com.avos.avoscloud.im.v2.messages.AVIMFileMessage;
import com.avos.avoscloud.im.v2.messages.AVIMFileMessageAccessor;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Callback;
import okhttp3.Request;

@AVIMMessageType(type=-2)
public class AVIMImageMessage
extends AVIMFileMessage {
    static final String IMAGE_HEIGHT = "height";
    static final String IMAGE_WIDTH = "width";
    public static final Parcelable.Creator<AVIMImageMessage> CREATOR = new AVIMMessageCreator<AVIMImageMessage>(AVIMImageMessage.class);

    public AVIMImageMessage() {
    }

    public AVIMImageMessage(String localPath) throws IOException {
        super(localPath);
    }

    public AVIMImageMessage(File localFile) throws IOException {
        super(localFile);
    }

    public AVIMImageMessage(AVFile file) {
        super(file);
    }

    @Override
    public Map<String, Object> getFileMetaData() {
        if (this.file == null) {
            this.file = new HashMap();
        }
        if (this.file.containsKey("metaData")) {
            return (Map)this.file.get("metaData");
        }
        if (this.localFile != null) {
            Map<String, Object> meta = AVIMFileMessageAccessor.getImageMeta(this.localFile);
            meta.put("size", this.actualFile.getSize());
            this.file.put("metaData", meta);
            return meta;
        }
        if (this.actualFile != null) {
            HashMap meta = this.actualFile.getMetaData();
            this.file.put("metaData", meta);
            return meta;
        }
        return null;
    }

    public int getHeight() {
        Map<String, Object> metaData = this.getFileMetaData();
        if (metaData != null && metaData.containsKey(IMAGE_HEIGHT)) {
            return AVIMImageMessage.parseIntValue(metaData.get(IMAGE_HEIGHT));
        }
        return 0;
    }

    public int getWidth() {
        Map<String, Object> metaData = this.getFileMetaData();
        if (metaData != null && metaData.containsKey(IMAGE_WIDTH)) {
            return AVIMImageMessage.parseIntValue(metaData.get(IMAGE_WIDTH));
        }
        return 0;
    }

    private static int parseIntValue(Object value) {
        if (null != value) {
            if (value instanceof Integer || value instanceof Long) {
                return (Integer)value;
            }
            if (value instanceof Double) {
                return (int)((Double)value).doubleValue();
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).intValue();
            }
        }
        return 0;
    }

    @Override
    protected void getAdditionalMetaData(final Map<String, Object> meta, final SaveCallback callback) {
        if (!AVUtils.isBlankString((String)this.actualFile.getUrl()) && this.localFile == null && !AVIMImageMessage.isExternalAVFile(this.actualFile)) {
            AVHttpClient client = AVHttpClient.clientInstance();
            Request.Builder builder = new Request.Builder();
            builder.url(this.actualFile.getUrl() + "?imageInfo").get();
            client.execute(builder.build(), false, (Callback)new GetHttpResponseHandler(new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    try {
                        JSONObject response = JSON.parseObject((String)content);
                        meta.put("format", response.getString("format"));
                        meta.put(AVIMImageMessage.IMAGE_HEIGHT, response.getInteger(AVIMImageMessage.IMAGE_HEIGHT));
                        meta.put(AVIMImageMessage.IMAGE_WIDTH, response.getInteger(AVIMImageMessage.IMAGE_WIDTH));
                    }
                    catch (Exception e1) {
                        callback.internalDone(new AVException((Throwable)e1));
                    }
                    callback.internalDone(null);
                }

                public void onFailure(Throwable error, String content) {
                    callback.internalDone(new AVException(error));
                }

                public boolean isRequestStatisticNeed() {
                    return false;
                }
            }));
        } else {
            callback.internalDone(null);
        }
    }
}

