/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVUtils;
import com.avos.avospush.session.MessageQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PendingMessageCache<E extends MessageQueue.HasId> {
    private Map<String, E> msgMapping;
    private MessageQueue<E> messages;

    PendingMessageCache(String peerId, Class<E> type) {
        this.messages = new MessageQueue<E>(peerId, type);
        this.setupMapping();
    }

    private void setupMapping() {
        this.msgMapping = new ConcurrentHashMap<String, E>();
        for (MessageQueue.HasId msg : this.messages) {
            if (AVUtils.isBlankString((String)msg.getId())) continue;
            this.msgMapping.put(msg.getId(), msg);
        }
    }

    void offer(E msg) {
        if (!AVUtils.isBlankString((String)msg.getId())) {
            this.msgMapping.put(msg.getId(), msg);
        }
        this.messages.offer(msg);
    }

    E poll(String msgId) {
        if (!AVUtils.isBlankString((String)msgId) && this.msgMapping.containsKey(msgId)) {
            MessageQueue.HasId returnValue = (MessageQueue.HasId)this.msgMapping.remove(msgId);
            this.messages.remove(returnValue);
            return (E)returnValue;
        }
        return this.poll();
    }

    E poll() {
        return (E)((MessageQueue.HasId)this.messages.poll());
    }

    public void clear() {
        this.messages.clear();
        this.msgMapping.clear();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public static class Message
    implements MessageQueue.HasId {
        public String msg;
        public String id;
        public long timestamp;
        boolean requestReceipt;
        String cid;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }

        public static Message getMessage(String msg, String id, boolean requestReceipt, String cid) {
            Message m = new Message();
            m.msg = msg;
            m.setId(id);
            m.requestReceipt = requestReceipt;
            m.cid = cid;
            return m;
        }
    }
}

