/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.Signature;
import com.avos.avoscloud.im.v2.AVIMClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class AVSessionCacheHelper {
    private static final String SESSION_KEY = "sessionids";
    private static SessionTagCache tagCacheInstance;

    AVSessionCacheHelper() {
    }

    static synchronized SessionTagCache getTagCacheInstance() {
        if (null == tagCacheInstance) {
            tagCacheInstance = new SessionTagCache();
        }
        return tagCacheInstance;
    }

    static {
        AVPersistenceUtils.sharedInstance().removePersistentSettingString("com.avos.avoscloud.session.version", SESSION_KEY);
        AVPersistenceUtils.sharedInstance().removePersistentSettingString("com.avos.avoscloud.session", SESSION_KEY);
        AVPersistenceUtils.sharedInstance().removePersistentSettingString("com.avos.avoscloud.session.tag", SESSION_KEY);
    }

    static class IMSessionTokenCache {
        private static final String SESSION_TOKEN_KEY = "com.avos.avoscloud.session.token";
        private static Map<String, String> imSessionTokenMap = new HashMap<String, String>();

        IMSessionTokenCache() {
        }

        static String getIMSessionToken(String clientId) {
            if (AVIMClient.isAutoOpen()) {
                String token = AVPersistenceUtils.sharedInstance().getPersistentSettingString(SESSION_TOKEN_KEY, clientId, null);
                String expiredAt = AVPersistenceUtils.sharedInstance().getPersistentSettingString(SESSION_TOKEN_KEY, IMSessionTokenCache.getSessionTokenExpiredAtKey(clientId), null);
                if (!AVUtils.isBlankString((String)token) && !AVUtils.isBlankString((String)expiredAt)) {
                    try {
                        long expiredAtInLong = Long.parseLong(expiredAt);
                        if (expiredAtInLong > System.currentTimeMillis()) {
                            return token;
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (imSessionTokenMap.containsKey(clientId)) {
                return imSessionTokenMap.get(clientId);
            }
            return null;
        }

        static void addIMSessionToken(String clientId, String realtimeSessionToken, long expireInSec) {
            if (AVIMClient.isAutoOpen()) {
                AVPersistenceUtils.sharedInstance().savePersistentSettingString(SESSION_TOKEN_KEY, clientId, realtimeSessionToken);
                AVPersistenceUtils.sharedInstance().savePersistentSettingString(SESSION_TOKEN_KEY, IMSessionTokenCache.getSessionTokenExpiredAtKey(clientId), String.valueOf(expireInSec));
            } else {
                imSessionTokenMap.put(clientId, realtimeSessionToken);
            }
        }

        static void removeIMSessionToken(String clientId) {
            if (AVIMClient.isAutoOpen()) {
                AVPersistenceUtils.sharedInstance().removePersistentSettingString(SESSION_TOKEN_KEY, clientId);
                AVPersistenceUtils.sharedInstance().removePersistentSettingString(SESSION_TOKEN_KEY, IMSessionTokenCache.getSessionTokenExpiredAtKey(clientId));
            } else {
                imSessionTokenMap.remove(clientId);
            }
        }

        private static String getSessionTokenExpiredAtKey(String clientId) {
            return clientId + ".expiredAt";
        }
    }

    static class SignatureCache {
        private static final String SESSION_SIGNATURE_KEY = "com.avos.avoscloud.session.signature";

        SignatureCache() {
        }

        static void addSessionSignature(String clientId, Signature signature) {
            Map<String, Signature> signatureMap = SignatureCache.getSessionSignatures();
            signatureMap.put(clientId, signature);
            AVPersistenceUtils.sharedInstance().savePersistentSettingString(SESSION_SIGNATURE_KEY, AVSessionCacheHelper.SESSION_KEY, JSON.toJSONString(signatureMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }

        static Signature getSessionSignature(String clientId) {
            Map<String, Signature> signatureMap = SignatureCache.getSessionSignatures();
            return signatureMap.get(clientId);
        }

        private static Map<String, Signature> getSessionSignatures() {
            String sessionSignatureString = AVPersistenceUtils.sharedInstance().getPersistentSettingString(SESSION_SIGNATURE_KEY, AVSessionCacheHelper.SESSION_KEY, "{}");
            Map signatureMap = (Map)JSON.parseObject((String)sessionSignatureString, Map.class);
            return signatureMap;
        }
    }

    static class SessionTagCache {
        private final String SESSION_TAG_CACHE_KEY = "session_tag_cache_key";
        Map<String, String> cachedTagMap = Collections.synchronizedMap(new HashMap());

        private SessionTagCache() {
            this.syncLocalToMemory(this.cachedTagMap);
        }

        private synchronized void syncTagsToLocal(Map<String, String> map) {
            if (null != map) {
                AVPersistenceUtils.sharedInstance().savePersistentSettingString(AVSessionCacheHelper.SESSION_KEY, "session_tag_cache_key", JSON.toJSONString(map));
            }
        }

        private void syncLocalToMemory(Map<String, String> map) {
            String sessionIdsString = AVPersistenceUtils.sharedInstance().getPersistentSettingString(AVSessionCacheHelper.SESSION_KEY, "session_tag_cache_key", "{}");
            Map sessionIds = (Map)JSON.parseObject((String)sessionIdsString, HashMap.class);
            if (sessionIds != null && !sessionIds.isEmpty()) {
                map.clear();
                map.putAll(sessionIds);
            }
        }

        void addSession(String clientId, String tag) {
            this.cachedTagMap.put(clientId, tag);
            if (AVIMClient.isAutoOpen()) {
                this.syncTagsToLocal(this.cachedTagMap);
            }
        }

        void removeSession(String clientId) {
            if (this.cachedTagMap.containsKey(clientId)) {
                this.cachedTagMap.remove(clientId);
                if (AVIMClient.isAutoOpen()) {
                    this.syncTagsToLocal(this.cachedTagMap);
                }
            }
        }

        Map<String, String> getAllSession() {
            HashMap<String, String> sessionMap = new HashMap<String, String>();
            sessionMap.putAll(this.cachedTagMap);
            return sessionMap;
        }
    }
}

