/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.SuppressLint;
import android.content.Context;
import com.avos.avoscloud.AVConversationHolder;
import com.avos.avoscloud.AVDefaultWebSocketListener;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVIMClientParcel;
import com.avos.avoscloud.AVIMOperationQueue;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVSessionCacheHelper;
import com.avos.avoscloud.AVSessionListener;
import com.avos.avoscloud.AVUserSignatureFactory;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.BroadcastUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PendingMessageCache;
import com.avos.avoscloud.PushService;
import com.avos.avoscloud.Signature;
import com.avos.avoscloud.SignatureCallback;
import com.avos.avoscloud.SignatureFactory;
import com.avos.avoscloud.SignatureTask;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.AVIMOptions;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avospush.push.AVWebSocketListener;
import com.avos.avospush.session.ConversationAckPacket;
import com.avos.avospush.session.ConversationControlPacket;
import com.avos.avospush.session.ConversationQueryPacket;
import com.avos.avospush.session.MessageReceiptCache;
import com.avos.avospush.session.SessionControlPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

@SuppressLint(value={"NewApi"})
public class AVSession {
    static final int OPERATION_OPEN_SESSION = 10004;
    static final int OPERATION_CLOSE_SESSION = 10005;
    static final int OPERATION_UNKNOW = -1;
    public static final String ERROR_INVALID_SESSION_ID = "Null id in session id list.";
    private final String LAST_NOTIFY_TIME = "lastNotifyTime";
    private final String LAST_PATCH_TIME = "lastPatchTime";
    private final String AVUSER_SESSION_TOKEN = "avuserSessionToken";
    private final Context context;
    private final String selfId;
    String tag;
    private String userSessionToken = null;
    private String realtimeSessionToken = null;
    private long realtimeSessionTokenExpired = 0L;
    private long lastNotifyTime = 0L;
    private long lastPatchTime = 0L;
    final AtomicBoolean sessionOpened = new AtomicBoolean(false);
    final AtomicBoolean sessionPaused = new AtomicBoolean(false);
    final AtomicBoolean sessionResume = new AtomicBoolean(false);
    private final AtomicLong lastServerAckReceived = new AtomicLong(0L);
    PendingMessageCache<PendingMessageCache.Message> pendingMessages;
    AVIMOperationQueue conversationOperationCache;
    private final ConcurrentHashMap<String, AVConversationHolder> conversationHolderCache = new ConcurrentHashMap();
    final AVSessionListener sessionListener;
    private final AVWebSocketListener websocketListener;
    private static boolean onlyPushCount = false;

    public AVWebSocketListener getWebSocketListener() {
        return this.websocketListener;
    }

    public AVSession(String selfId, AVSessionListener sessionListener) {
        this.selfId = selfId;
        this.context = AVOSCloud.applicationContext;
        this.sessionListener = sessionListener;
        this.websocketListener = new AVDefaultWebSocketListener(this);
        this.pendingMessages = new PendingMessageCache<PendingMessageCache.Message>(selfId, PendingMessageCache.Message.class);
        this.conversationOperationCache = new AVIMOperationQueue(selfId);
    }

    public void open(AVIMClientParcel parcel, int requestId) {
        this.tag = parcel.getClientTag();
        this.updateUserSessionToken(parcel.getSessionToken());
        try {
            if (PushService.isPushConnectionBroken()) {
                this.sessionListener.onError(AVOSCloud.applicationContext, this, new IllegalStateException("Connection Lost"), 10004, requestId);
                return;
            }
            if (this.sessionOpened.get()) {
                this.sessionListener.onSessionOpen(this.context, this, requestId);
                return;
            }
            this.openWithSignature(requestId, parcel.isReconnection(), true);
        }
        catch (Exception e) {
            this.sessionListener.onError(AVOSCloud.applicationContext, this, e, 10004, requestId);
        }
    }

    void reopen() {
        String rtmSessionToken = AVSessionCacheHelper.IMSessionTokenCache.getIMSessionToken(this.getSelfPeerId());
        if (!AVUtils.isBlankString((String)rtmSessionToken)) {
            this.openWithSessionToken(rtmSessionToken);
        } else {
            int requestId = AVUtils.getNextIMRequestId();
            this.openWithSignature(requestId, true, false);
        }
    }

    public void renewRealtimeSesionToken(final int requestId) {
        final SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException exception) {
                if (null != exception) {
                    LogUtil.log.d((String)"failed to generate signaure. cause:", (Exception)exception);
                } else {
                    SessionControlPacket scp = SessionControlPacket.genSessionCommand(AVSession.this.getSelfPeerId(), null, "refresh", sig, AVSession.this.getLastNotifyTime(), AVSession.this.getLastPatchTime(), requestId);
                    scp.setTag(AVSession.this.tag);
                    scp.setSessionToken(AVSession.this.realtimeSessionToken);
                    PushService.sendData(scp);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (null == signatureFactory && !AVUtils.isBlankString((String)AVSession.this.getUserSessionToken())) {
                    signatureFactory = new AVUserSignatureFactory(AVSession.this.getUserSessionToken());
                }
                if (null != signatureFactory) {
                    return signatureFactory.createSignature(AVSession.this.getSelfPeerId(), new ArrayList<String>());
                }
                return null;
            }
        };
        if (!AVUtils.isMainThread()) {
            AVOSCloud.handler.post(new Runnable(){

                @Override
                public void run() {
                    new SignatureTask(callback).commit(AVSession.this.getSelfPeerId());
                }
            });
        } else {
            new SignatureTask(callback).commit(this.getSelfPeerId());
        }
    }

    void updateRealtimeSessionToken(String sessionToken, int expireInSec) {
        this.realtimeSessionToken = sessionToken;
        this.realtimeSessionTokenExpired = System.currentTimeMillis() + (long)(expireInSec * 1000);
        AVIMClient client = AVIMClient.getInstance(this.selfId);
        if (null != client) {
            client.updateRealtimeSessionToken(sessionToken, this.realtimeSessionTokenExpired);
        }
        if (AVUtils.isBlankString((String)sessionToken)) {
            AVSessionCacheHelper.IMSessionTokenCache.removeIMSessionToken(this.getSelfPeerId());
        } else {
            AVSessionCacheHelper.IMSessionTokenCache.addIMSessionToken(this.getSelfPeerId(), sessionToken, this.realtimeSessionTokenExpired);
        }
    }

    private void openWithSessionToken(String rtmSessionToken) {
        SessionControlPacket scp = SessionControlPacket.genSessionCommand(this.getSelfPeerId(), null, "open", null, this.getLastNotifyTime(), this.getLastPatchTime(), null);
        scp.setSessionToken(rtmSessionToken);
        scp.setReconnectionRequest(true);
        PushService.sendData(scp);
    }

    private void openWithSignature(final int requestId, final boolean reconnectionFlag, final boolean notifyListener) {
        final SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException exception) {
                if (null != exception) {
                    if (notifyListener) {
                        AVSession.this.sessionListener.onError(AVOSCloud.applicationContext, AVSession.this, (Throwable)exception, 10004, requestId);
                    }
                    LogUtil.log.d((String)"failed to generate signaure. cause:", (Exception)exception);
                } else {
                    AVSession.this.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CLIENT_OPEN.getCode(), AVSession.this.getSelfPeerId(), null, requestId));
                    SessionControlPacket scp = SessionControlPacket.genSessionCommand(AVSession.this.getSelfPeerId(), null, "open", sig, AVSession.this.getLastNotifyTime(), AVSession.this.getLastPatchTime(), requestId);
                    scp.setTag(AVSession.this.tag);
                    scp.setReconnectionRequest(reconnectionFlag);
                    PushService.sendData(scp);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (null == signatureFactory && !AVUtils.isBlankString((String)AVSession.this.getUserSessionToken())) {
                    signatureFactory = new AVUserSignatureFactory(AVSession.this.getUserSessionToken());
                }
                if (null != signatureFactory) {
                    return signatureFactory.createSignature(AVSession.this.getSelfPeerId(), new ArrayList<String>());
                }
                return null;
            }
        };
        if (!AVUtils.isMainThread()) {
            AVOSCloud.handler.post(new Runnable(){

                @Override
                public void run() {
                    new SignatureTask(callback).commit(AVSession.this.getSelfPeerId());
                }
            });
        } else {
            new SignatureTask(callback).commit(this.getSelfPeerId());
        }
    }

    public void close() {
        this.close(-65537);
    }

    public void cleanUp() {
        this.updateRealtimeSessionToken("", 0);
        if (this.pendingMessages != null) {
            this.pendingMessages.clear();
        }
        if (this.conversationOperationCache != null) {
            this.conversationOperationCache.clear();
        }
        this.conversationHolderCache.clear();
        MessageReceiptCache.clean(this.getSelfPeerId());
    }

    protected void close(int requestId) {
        try {
            AVSessionCacheHelper.getTagCacheInstance().removeSession(this.getSelfPeerId());
            AVSessionCacheHelper.IMSessionTokenCache.removeIMSessionToken(this.getSelfPeerId());
            this.cleanUp();
            if (!this.sessionOpened.compareAndSet(true, false)) {
                this.sessionListener.onSessionClose(this.context, this, requestId);
                return;
            }
            if (!this.sessionPaused.getAndSet(false)) {
                this.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CLIENT_DISCONNECT.getCode(), this.selfId, null, requestId));
                SessionControlPacket scp = SessionControlPacket.genSessionCommand(this.selfId, null, "close", null, requestId);
                PushService.sendData(scp);
            } else {
                this.sessionListener.onSessionClose(this.context, this, requestId);
            }
        }
        catch (Exception e) {
            this.sessionListener.onError(AVOSCloud.applicationContext, this, e, 10005, requestId);
        }
    }

    protected void storeMessage(PendingMessageCache.Message cacheMessage, int requestId) {
        this.pendingMessages.offer(cacheMessage);
        this.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE.getCode(), this.getSelfPeerId(), cacheMessage.cid, requestId));
    }

    public String getSelfPeerId() {
        return this.selfId;
    }

    protected void setServerAckReceived(long lastAckReceivedTimestamp) {
        this.lastServerAckReceived.set(lastAckReceivedTimestamp);
    }

    protected void queryOnlinePeers(List<String> peerIds, int requestId) {
        SessionControlPacket scp = SessionControlPacket.genSessionCommand(this.selfId, peerIds, "query", null, requestId);
        PushService.sendData(scp);
    }

    protected void conversationQuery(Map<String, Object> params, int requestId) {
        if (this.sessionPaused.get()) {
            RuntimeException se = new RuntimeException("Connection Lost");
            BroadcastUtil.sendIMLocalBroadcast(this.getSelfPeerId(), null, requestId, se, Conversation.AVIMOperation.CONVERSATION_QUERY);
            return;
        }
        this.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_QUERY.getCode(), this.selfId, null, requestId));
        PushService.sendData(ConversationQueryPacket.getConversationQueryPacket(this.getSelfPeerId(), params, requestId));
    }

    public AVException checkSessionStatus() {
        if (!this.sessionOpened.get()) {
            return new AVException(119, "Please call AVIMClient.open() first");
        }
        if (this.sessionPaused.get()) {
            return new AVException((Throwable)new RuntimeException("Connection Lost"));
        }
        if (this.sessionResume.get()) {
            return new AVException((Throwable)new RuntimeException("Connecting to server"));
        }
        return null;
    }

    public AVConversationHolder getConversationHolder(String conversationId, int convType) {
        AVConversationHolder conversation = this.conversationHolderCache.get(conversationId);
        if (conversation != null) {
            return conversation;
        }
        conversation = new AVConversationHolder(conversationId, this, convType);
        AVConversationHolder elderObject = this.conversationHolderCache.putIfAbsent(conversationId, conversation);
        return elderObject == null ? conversation : elderObject;
    }

    protected void removeConversation(String conversationId) {
        this.conversationHolderCache.remove(conversationId);
    }

    protected void createConversation(final List<String> members, final Map<String, Object> attributes, final boolean isTransient, final boolean isUnique, final boolean isTemp, final int tempTTL, final boolean isSystem, final int requestId) {
        if (this.sessionPaused.get()) {
            RuntimeException se = new RuntimeException("Connection Lost");
            this.sessionListener.onError(this.context, this, se, Conversation.AVIMOperation.CONVERSATION_CREATION.getCode(), requestId);
            return;
        }
        SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException e) {
                if (e == null) {
                    AVSession.this.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_CREATION.getCode(), AVSession.this.getSelfPeerId(), null, requestId));
                    PushService.sendData(ConversationControlPacket.genConversationCommand(AVSession.this.selfId, null, members, "start", attributes, sig, isTransient, isUnique, isTemp, tempTTL, isSystem, requestId));
                } else {
                    BroadcastUtil.sendIMLocalBroadcast(AVSession.this.getSelfPeerId(), null, requestId, (Throwable)e, Conversation.AVIMOperation.CONVERSATION_CREATION);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (signatureFactory != null) {
                    return signatureFactory.createSignature(AVSession.this.selfId, members);
                }
                return null;
            }
        };
        new SignatureTask(callback).commit(this.selfId);
    }

    public static void setUnreadNotificationEnabled(boolean isOnlyCount) {
        onlyPushCount = isOnlyCount;
    }

    public static boolean isOnlyPushCount() {
        return onlyPushCount;
    }

    long getLastNotifyTime() {
        if (this.lastNotifyTime <= 0L) {
            this.lastNotifyTime = AVPersistenceUtils.sharedInstance().getPersistentSettingLong(this.selfId, "lastNotifyTime", Long.valueOf(0L));
        }
        return this.lastNotifyTime;
    }

    void updateLastNotifyTime(long notifyTime) {
        long currentTime = this.getLastNotifyTime();
        if (notifyTime > currentTime) {
            this.lastNotifyTime = notifyTime;
            AVPersistenceUtils.sharedInstance().savePersistentSettingLong(this.selfId, "lastNotifyTime", Long.valueOf(notifyTime));
        }
    }

    long getLastPatchTime() {
        if (this.lastPatchTime <= 0L) {
            this.lastPatchTime = AVPersistenceUtils.sharedInstance().getPersistentSettingLong(this.selfId, "lastPatchTime", Long.valueOf(0L));
        }
        if (this.lastPatchTime <= 0L) {
            this.lastPatchTime = System.currentTimeMillis();
            AVPersistenceUtils.sharedInstance().savePersistentSettingLong(this.selfId, "lastPatchTime", Long.valueOf(this.lastPatchTime));
        }
        return this.lastPatchTime;
    }

    void updateLastPatchTime(long patchTime) {
        long currentTime = this.getLastPatchTime();
        if (patchTime > currentTime) {
            this.lastPatchTime = patchTime;
            AVPersistenceUtils.sharedInstance().savePersistentSettingLong(this.selfId, "lastPatchTime", Long.valueOf(patchTime));
        }
    }

    String getUserSessionToken() {
        if (AVUtils.isBlankString((String)this.userSessionToken)) {
            this.userSessionToken = AVPersistenceUtils.sharedInstance().getPersistentSettingString(this.selfId, "avuserSessionToken", "");
        }
        return this.userSessionToken;
    }

    void updateUserSessionToken(String token) {
        this.userSessionToken = token;
        if (!AVUtils.isBlankString((String)this.userSessionToken)) {
            AVPersistenceUtils.sharedInstance().savePersistentSettingString(this.selfId, "avuserSessionToken", this.userSessionToken);
        }
    }

    public void sendUnreadMessagesAck(ArrayList<AVIMMessage> messages, String conversationId) {
        if (onlyPushCount && null != messages && messages.size() > 0) {
            Long largestTimeStamp = 0L;
            for (AVIMMessage message : messages) {
                if (largestTimeStamp >= message.getTimestamp()) continue;
                largestTimeStamp = message.getTimestamp();
            }
            PushService.sendData(ConversationAckPacket.getConversationAckPacket(this.getSelfPeerId(), conversationId, largestTimeStamp));
        }
    }
}

