/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.os.Build;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVLiveQuery;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.HeartBeatPolicy;
import com.avos.avoscloud.LogUtil;
import com.avos.avospush.session.CommandPacket;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.protocols.IProtocol;
import org.java_websocket.protocols.Protocol;

public class AVPushWebSocketClient
extends WebSocketClient {
    public static final String SUB_PROTOCOL_2_1 = "lc.protobuf2.1";
    public static final String SUB_PROTOCOL_2_3 = "lc.protobuf2.3";
    private static final String HEADER_SUB_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final String HEADER_SNI_HOST = "Host";
    private static final int PING_TIMEOUT_CODE = 3000;
    private HeartBeatPolicy heartBeatPolicy;
    private final long RECONNECT_INTERVAL = 10000L;
    Runnable reconnectTask = new Runnable(){

        @Override
        public void run() {
            AVPushWebSocketClient.this.autoReconnect();
        }
    };
    AVPacketParser receiver;
    SSLSessionCache sessionCache;
    private static ArrayList<IProtocol> protocols = new ArrayList();
    AtomicBoolean destroyed = new AtomicBoolean(false);

    public AVPushWebSocketClient(URI serverURI, AVPacketParser parser, final String subProtocol, boolean secEnabled) {
        super(serverURI, (Draft)new Draft_6455(Collections.emptyList(), protocols), (Map)new HashMap<String, String>(){
            {
                this.put(AVPushWebSocketClient.HEADER_SUB_PROTOCOL, subProtocol);
            }
        }, 0);
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("trying to connect " + serverURI + ", subProtocol=" + subProtocol));
        }
        this.initHeartBeatPolicy();
        if (secEnabled) {
            this.setSocket();
        }
        this.receiver = parser;
    }

    private void initHeartBeatPolicy() {
        this.heartBeatPolicy = new HeartBeatPolicy(){

            @Override
            public void onTimeOut() {
                AVPushWebSocketClient.this.closeConnection(3000, "No response for ping");
            }

            @Override
            public void sendPing() {
                AVPushWebSocketClient.this.ping();
            }
        };
    }

    private void setSocket() {
        block8: {
            try {
                String url = this.getURI().toString();
                if (AVUtils.isBlankContent((String)url)) break block8;
                if (url.startsWith("wss")) {
                    if (null == this.sessionCache) {
                        this.sessionCache = new SSLSessionCache(AVOSCloud.applicationContext);
                    }
                    SSLCertificateSocketFactory socketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)5000, (SSLSessionCache)this.sessionCache);
                    Socket socket = socketFactory.createSocket();
                    if (Build.VERSION.SDK_INT >= 17) {
                        socketFactory.setUseSessionTickets(socket, true);
                    }
                    if (Build.VERSION.SDK_INT >= 24 && socket instanceof SSLSocket) {
                        try {
                            SNIHostName serverName = new SNIHostName(this.getURI().getHost());
                            ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
                            serverNames.add(serverName);
                            SSLParameters params = ((SSLSocket)socket).getSSLParameters();
                            params.setServerNames(serverNames);
                            ((SSLSocket)socket).setSSLParameters(params);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.setSocket(socket);
                    break block8;
                }
                SocketFactory socketFactory = SocketFactory.getDefault();
                this.setSocket(socketFactory.createSocket());
            }
            catch (Exception e) {
                LogUtil.avlog.e((String)"Socket Error", (Exception)((Object)new AVException((Throwable)e)));
            }
        }
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.cancelReconnect();
        this.heartBeatPolicy.startHeartbeat();
        if (this.receiver != null) {
            this.receiver.loginCmd();
            this.receiver.processConnectionStatus(null);
            this.receiver.processSessionsStatus(false);
        }
        LogUtil.avlog.d((String)"onOpen()");
        AVLiveQuery.resumeSubscribeers();
    }

    public void onMessage(ByteBuffer byteBuffer) {
        if (this.receiver != null) {
            this.receiver.processCommand(byteBuffer);
        }
    }

    public void onMessage(String msg) {
    }

    public void onClose(int code, String reason, boolean remote) {
        this.heartBeatPolicy.stopHeartbeat();
        if (this.receiver != null) {
            this.receiver.processSessionsStatus(true);
        }
        if (this.receiver != null) {
            this.receiver.processConnectionStatus(new AVException(code, reason));
        }
        LogUtil.avlog.d((String)("onClose(). local disconnection code=" + code + ", reason=" + reason + ", remote=" + remote));
        switch (code) {
            case -1: {
                LogUtil.avlog.d((String)"connection refused");
                if (remote) {
                    if (this.receiver == null) break;
                    this.receiver.processRemoteServerNotAvailable();
                    break;
                }
                this.scheduleReconnect();
                break;
            }
            case 3000: {
                LogUtil.avlog.d((String)"connection unhealthy");
                this.autoReconnect();
                break;
            }
            default: {
                this.scheduleReconnect();
            }
        }
    }

    public void onError(Exception ex) {
        ex.printStackTrace();
        if (this.receiver != null && AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
            this.receiver.processRemoteServerNotAvailable();
        }
    }

    protected void scheduleReconnect() {
        AVOSCloud.handler.postDelayed(this.reconnectTask, 10000L);
    }

    protected void cancelReconnect() {
        AVOSCloud.handler.removeCallbacks(this.reconnectTask);
    }

    protected void destroy() {
        this.destroyed.set(true);
        this.cancelReconnect();
        this.heartBeatPolicy.stopHeartbeat();
        LogUtil.avlog.d((String)"connection destroyed");
    }

    protected boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected synchronized void autoReconnect() {
        if (this.isConnecting() || this.isOpen()) {
            return;
        }
        if (AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
            this.reconnect();
        } else if (!this.destroyed.get()) {
            this.scheduleReconnect();
        }
    }

    protected void ping() {
        PingFrame frame = new PingFrame();
        this.sendFrame((Framedata)frame);
    }

    public void send(CommandPacket packet) {
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("uplink : " + packet.getGenericCommand().toString()));
        }
        try {
            this.send(packet.getGenericCommand().toByteArray());
        }
        catch (Exception e) {
            LogUtil.avlog.e((String)e.getMessage());
        }
    }

    public void onWebsocketPong(WebSocket conn, Framedata f) {
        super.onWebsocketPong(conn, f);
        this.heartBeatPolicy.onPong();
    }

    static {
        protocols.add((IProtocol)new Protocol(SUB_PROTOCOL_2_3));
    }

    public static interface AVPacketParser {
        public void loginCmd();

        public void processCommand(ByteBuffer var1);

        public void processConnectionStatus(AVException var1);

        public void processRemoteServerNotAvailable();

        public void processSessionsStatus(boolean var1);
    }
}

