/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVDefaultSessionListener;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.AVLiveQuery;
import com.avos.avoscloud.AVNotificationManager;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPushWebSocketClient;
import com.avos.avoscloud.AVSession;
import com.avos.avoscloud.AVSessionCacheHelper;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avospush.push.AVPushRouter;
import com.avos.avospush.session.CommandPacket;
import com.avos.avospush.session.LiveQueryLoginPacket;
import com.avos.avospush.session.LoginPacket;
import com.avos.avospush.session.MessagePatchModifiedPacket;
import com.avos.avospush.session.PushAckPacket;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class AVPushConnectionManager
implements AVPushWebSocketClient.AVPacketParser {
    private static final String SUB_PROTOCOL_2_3 = "lc.protobuf2.3";
    private static final String SUB_PROTOCOL_2_1 = "lc.protobuf2.1";
    private static AVPushConnectionManager instance = null;
    private volatile AVPushWebSocketClient socketClient;
    private static final Map<String, AVSession> peerIdEnabledSessions = Collections.synchronizedMap(new HashMap());
    private List<AVCallback> connectionCallbacks = new LinkedList<AVCallback>();
    private AVPushRouter router;
    private static String liveQuerySubscribeId = "";

    private AVPushConnectionManager(Context ctx) {
        LogUtil.log.d((String)"begin to invoke AVPushConnectionManager(Context)");
        this.router = new AVPushRouter(ctx, new AVPushRouter.RouterResponseListener(){

            @Override
            public void onServerAddress(String address) {
                if (!AVUtils.isBlankString((String)address)) {
                    AVPushConnectionManager.this.createNewWebSocket(address);
                } else if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.d((String)"push server address is null");
                }
            }
        });
        this.initSessionsIfExists();
        boolean initializeConn = true;
        if (AVOSCloud.isGcmOpen()) {
            try {
                Class<?> gcmManagerClass = Class.forName("com.avos.avoscloud.AVGcmManager");
                Method getTokenMethod = gcmManagerClass.getMethod("getGcmTokenInBackground", Context.class);
                getTokenMethod.invoke(gcmManagerClass, ctx);
                initializeConn = false;
                LogUtil.log.d((String)"skip initialize connection bcz of GCM Push using");
            }
            catch (Exception e) {
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.i((String)"gcm library not started since not included");
                }
            }
        } else if (AVOSCloud.isFCMOpen()) {
            initializeConn = false;
            LogUtil.log.d((String)"skip initialize connection bcz of FCM Push using");
        }
        if (initializeConn) {
            this.initConnection();
        }
        LogUtil.log.d((String)"end of AVPushConnectionManager(Context)");
    }

    private void initSessionsIfExists() {
        Map<String, String> cachedSessions = AVSessionCacheHelper.getTagCacheInstance().getAllSession();
        for (Map.Entry<String, String> entry : cachedSessions.entrySet()) {
            AVSession s = this.getOrCreateSession(entry.getKey());
            s.sessionResume.set(true);
            s.tag = entry.getValue();
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)(cachedSessions.size() + " sessions recovered"));
        }
    }

    public static synchronized AVPushConnectionManager getInstance(Context ctx) {
        if (instance == null) {
            instance = new AVPushConnectionManager(ctx);
        }
        return instance;
    }

    public void initConnection() {
        this.initConnection(null);
    }

    public void initConnection(AVCallback cl) {
        if (this.socketClient != null && this.socketClient.isOpen()) {
            LogUtil.log.d((String)"push connection is open");
            return;
        }
        if (this.socketClient != null) {
            this.socketClient.cancelReconnect();
        }
        LogUtil.log.d((String)"try to query connection server via push router.");
        this.router.fetchPushServer();
        if (null != cl) {
            this.connectionCallbacks.add(cl);
        }
    }

    public boolean isConnectedToPushServer() {
        return this.socketClient != null && this.socketClient.isOpen();
    }

    public void stop() {
        this.cleanupSocketConnection();
    }

    public AVSession getOrCreateSession(String peerId) {
        try {
            boolean newAdded = !peerIdEnabledSessions.containsKey(peerId);
            AVSession session = null;
            if (newAdded) {
                session = new AVSession(peerId, new AVDefaultSessionListener(this));
                peerIdEnabledSessions.put(peerId, session);
                session.getWebSocketListener().onListenerAdded(this.socketClient != null && this.socketClient.isOpen());
            } else {
                session = peerIdEnabledSessions.get(peerId);
            }
            return session;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void removeSession(String peerId) {
        AVSession session = peerIdEnabledSessions.remove(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onListenerRemoved();
        }
    }

    public void sendData(CommandPacket packet) {
        if (this.socketClient != null && this.socketClient.isOpen()) {
            this.socketClient.send(packet);
        }
    }

    public void cleanupSocketConnection() {
        this.cleanupSocketConnection(1000, "");
    }

    public void cleanupSocketConnection(int code, String message) {
        if (this.socketClient != null && (this.socketClient.isConnecting() || this.socketClient.isOpen())) {
            try {
                LogUtil.avlog.d((String)"try to close and destroy connection");
                this.socketClient.closeConnection(code, message);
                this.socketClient.destroy();
            }
            catch (Exception e) {
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.e((String)"Close socket client failed.", (Exception)e);
                }
            }
        } else if (this.socketClient != null && this.socketClient.isClosing()) {
            LogUtil.avlog.d((String)"try to destroy connection");
            this.socketClient.destroy();
            this.socketClient = null;
        } else {
            LogUtil.avlog.d((String)"do nothing for invalid connection");
        }
    }

    private synchronized void createNewWebSocket(String pushServer) {
        if (this.socketClient == null || this.socketClient.isDestroyed() || this.socketClient.isClosed()) {
            if (this.socketClient != null && !this.socketClient.isDestroyed()) {
                LogUtil.log.d((String)"destroy socketClient first which is closed.");
                this.socketClient.destroy();
            }
            this.socketClient = AVSession.isOnlyPushCount() ? new AVPushWebSocketClient(URI.create(pushServer), this, SUB_PROTOCOL_2_3, true) : new AVPushWebSocketClient(URI.create(pushServer), this, SUB_PROTOCOL_2_1, true);
            this.socketClient.connect();
            if (AVOSCloud.isDebugLogEnabled()) {
                LogUtil.avlog.d((String)("connect to server: " + pushServer));
            }
        } else {
            LogUtil.log.d((String)"skip create socketClient.");
        }
    }

    private void processLiveQueryData(Messages.DataCommand dataCommand) {
        ProtocolStringList messageIds = dataCommand.getIdsList();
        List<Messages.JsonObjectMessage> messages = dataCommand.getMsgList();
        ArrayList<String> dataList = new ArrayList<String>();
        for (int i = 0; i < messages.size() && i < messageIds.size(); ++i) {
            Messages.JsonObjectMessage message = messages.get(i);
            if (null == message) continue;
            dataList.add(message.getData());
        }
        AVLiveQuery.processData(dataList);
    }

    private void processDataCommand(Messages.DataCommand dataCommand) {
        ProtocolStringList messageIds = dataCommand.getIdsList();
        List<Messages.JsonObjectMessage> messages = dataCommand.getMsgList();
        for (int i = 0; i < messages.size() && i < messageIds.size(); ++i) {
            if (null == messages.get(i)) continue;
            AVNotificationManager.getInstance().processPushMessage(messages.get(i).getData(), (String)messageIds.get(i));
        }
        PushAckPacket pap = new PushAckPacket();
        pap.setInstallationId(AVInstallation.getCurrentInstallation().getInstallationId());
        pap.setMessageIds((List<String>)messageIds);
        this.sendData(pap);
    }

    @Override
    public void processCommand(ByteBuffer bytes) {
        block24: {
            try {
                Integer requestKey;
                Messages.GenericCommand command = Messages.GenericCommand.parseFrom(bytes.array());
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.d((String)("downlink : " + command.toString()));
                }
                String peerId = command.getPeerId();
                Integer n = requestKey = command.hasI() ? Integer.valueOf(command.getI()) : null;
                if (AVUtils.isBlankString((String)peerId)) {
                    peerId = AVIMClient.getDefaultClient();
                }
                if (command.getCmd().getNumber() == 15) {
                    if (1 == command.getService()) {
                        this.processLoggedinCommand(requestKey);
                    }
                    break block24;
                }
                if (peerIdEnabledSessions.isEmpty() && command.getCmd().getNumber() != 9) break block24;
                switch (command.getCmd().getNumber()) {
                    case 9: {
                        if (command.hasService()) {
                            int service = command.getService();
                            if (0 == service) {
                                this.processDataCommand(command.getDataMessage());
                                break;
                            }
                            if (1 == service) {
                                this.processLiveQueryData(command.getDataMessage());
                            }
                            break;
                        }
                        this.processDataCommand(command.getDataMessage());
                        break;
                    }
                    case 2: {
                        this.processDirectCommand(peerId, command.getDirectMessage());
                        break;
                    }
                    case 0: {
                        this.processSessionCommand(peerId, command.getOp().name(), requestKey, command.getSessionMessage());
                        break;
                    }
                    case 3: {
                        this.processAckCommand(peerId, requestKey, command.getAckMessage());
                        break;
                    }
                    case 4: {
                        this.processRpcCommand(peerId, command.getRcpMessage());
                        break;
                    }
                    case 1: {
                        this.processConvCommand(peerId, command.getOp().name(), requestKey, command.getConvMessage());
                        break;
                    }
                    case 7: {
                        this.processErrorCommand(peerId, requestKey, command.getErrorMessage());
                        break;
                    }
                    case 6: {
                        this.processLogsCommand(peerId, requestKey, command.getLogsMessage());
                        break;
                    }
                    case 5: {
                        this.processUnreadCommand(peerId, command.getUnreadMessage());
                        break;
                    }
                    case 20: {
                        this.processBlacklistCommand(peerId, command.getOp().name(), requestKey, command.getBlacklistMessage());
                        break;
                    }
                    case 18: {
                        if (command.getOp().equals((Object)Messages.OpType.modify)) {
                            this.processPatchCommand(peerId, true, requestKey, command.getPatchMessage());
                            break;
                        }
                        if (!command.getOp().equals((Object)Messages.OpType.modified)) break;
                        this.processPatchCommand(peerId, false, requestKey, command.getPatchMessage());
                        break;
                    }
                    case 21: {
                        this.processGoawayCommand(peerId);
                        break;
                    }
                }
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void processConnectionStatus(final AVException e) {
        this.router.processSocketConnectionResult(e);
        AVOSCloud.handler.post(new Runnable(){

            @Override
            public void run() {
                if (null != AVPushConnectionManager.this.connectionCallbacks && AVPushConnectionManager.this.connectionCallbacks.size() > 0) {
                    Iterator iterator = AVPushConnectionManager.this.connectionCallbacks.iterator();
                    while (iterator.hasNext()) {
                        AVCallback callback = (AVCallback)iterator.next();
                        if (null != callback) {
                            callback.internalDone(null, e);
                        }
                        iterator.remove();
                    }
                }
            }
        });
    }

    private void processSessionCommand(String peerId, String op, Integer requestId, Messages.SessionCommand command) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onSessionCommand(op, requestId, command);
        }
    }

    private void processDirectCommand(String peerId, Messages.DirectCommand directCommand) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onDirectCommand(directCommand);
        }
    }

    private void processRpcCommand(String peerId, Messages.RcpCommand command) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            if (command.hasRead()) {
                session.getWebSocketListener().onReadCmdReceipt(command);
            } else {
                session.getWebSocketListener().onMessageReceipt(command);
            }
        }
    }

    private void processAckCommand(String peerId, Integer requestKey, Messages.AckCommand command) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onAckCommand(requestKey, command);
        }
    }

    private void processBlacklistCommand(String peerId, String operation, Integer requestKey, Messages.BlacklistCommand blacklistCommand) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onBlacklistCommand(operation, requestKey, blacklistCommand);
        }
    }

    private void processConvCommand(String peerId, String operation, Integer requestKey, Messages.ConvCommand convCommand) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onConversationCommand(operation, requestKey, convCommand);
        }
    }

    private void processErrorCommand(String peerId, Integer requestKey, Messages.ErrorCommand errorCommand) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onError(requestKey, errorCommand);
        }
    }

    private void processLogsCommand(String peerId, Integer requestKey, Messages.LogsCommand logsCommand) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        session.getWebSocketListener().onHistoryMessageQuery(requestKey, logsCommand);
    }

    private void processUnreadCommand(String peerId, Messages.UnreadCommand unreadCommand) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onUnreadMessagesCommand(unreadCommand);
        }
    }

    private void processPatchCommand(String peerId, boolean isModify, Integer requestKey, Messages.PatchCommand patchCommand) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (null != session && null != session.getWebSocketListener()) {
            session.getWebSocketListener().onMessagePatchCommand(isModify, requestKey, patchCommand);
        }
        if (isModify) {
            long lastPatchTime = 0L;
            for (Messages.PatchItem item : patchCommand.getPatchesList()) {
                if (item.getPatchTimestamp() <= lastPatchTime) continue;
                lastPatchTime = item.getPatchTimestamp();
            }
            this.sendData(MessagePatchModifiedPacket.getPatchMessagePacket(peerId, lastPatchTime));
        }
    }

    private void processLoggedinCommand(Integer requestKey) {
        if (null != requestKey) {
            Intent intent = new Intent();
            intent.setAction("live_query_" + requestKey);
            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).sendBroadcast(intent);
        }
    }

    private void processGoawayCommand(String peerId) {
        AVSession session = peerIdEnabledSessions.get(peerId);
        if (session != null && session.getWebSocketListener() != null) {
            session.getWebSocketListener().onGoaway();
        } else {
            LogUtil.avlog.d((String)("peerId(" + peerId + ") is invalid within GOAWAY command."));
        }
    }

    public void sendLiveQueryLoginCmd(String subscribeId, int requestId) {
        if (!AVUtils.isBlankString((String)subscribeId)) {
            liveQuerySubscribeId = subscribeId;
            LiveQueryLoginPacket lp = new LiveQueryLoginPacket();
            lp.setSubscribeId(subscribeId);
            if (0 != requestId) {
                lp.setRequestId(requestId);
            }
            this.socketClient.send(lp);
        }
    }

    @Override
    public void loginCmd() {
        LoginPacket lp = new LoginPacket();
        lp.setAppId(AVOSCloud.applicationId);
        lp.setInstallationId(AVInstallation.getCurrentInstallation().getInstallationId());
        this.socketClient.send(lp);
        if (!AVUtils.isBlankString((String)liveQuerySubscribeId)) {
            this.sendLiveQueryLoginCmd(liveQuerySubscribeId, 0);
        }
    }

    @Override
    public void processSessionsStatus(boolean closeEvent) {
        for (AVSession session : peerIdEnabledSessions.values()) {
            if (session.getWebSocketListener() == null) continue;
            if (closeEvent) {
                session.getWebSocketListener().onWebSocketClose();
                continue;
            }
            session.getWebSocketListener().onWebSocketOpen();
        }
    }

    @Override
    public void processRemoteServerNotAvailable() {
        this.router.fetchPushServer();
    }
}

