/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVClassName;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ObjectValueFilter;
import com.avos.avoscloud.PaasClient;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;
import java.util.UUID;

@AVClassName(value="_Installation")
public final class AVInstallation
extends AVObject {
    private static final String LOGTAG = AVInstallation.class.getName();
    private static final String DEVICETYPETAG = "deviceType";
    private static final String CHANNELSTAG = "channel";
    private static final String INSTALLATIONIDTAG = "installationId";
    private static final String INSTALLATION_AVNAME = "_Installation";
    public static final String REGISTRATION_ID = "registrationId";
    public static final String VENDOR = "vendor";
    private static volatile AVInstallation currentInstallation;
    private volatile String installationId = null;
    public static final String AVINSTALLATION_ENDPOINT = "installations";
    public static final transient Parcelable.Creator CREATOR;

    void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    public static AVInstallation getCurrentInstallation() {
        return AVInstallation.getCurrentInstallation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static AVInstallation getCurrentInstallation(Context ctx) {
        Context usingCtx;
        Context context = usingCtx = null == ctx ? AVOSCloud.applicationContext : ctx;
        if (currentInstallation == null) {
            Class<AVInstallation> clazz = AVInstallation.class;
            // MONITORENTER : com.avos.avoscloud.AVInstallation.class
            if (currentInstallation == null && AVInstallation.readInstallationFile(usingCtx) == null) {
                AVInstallation.createNewInstallation(usingCtx);
            }
            // MONITOREXIT : clazz
        }
        if (currentInstallation == null) return currentInstallation;
        currentInstallation.initialize();
        return currentInstallation;
    }

    private static void createNewInstallation(Context ctx) {
        String id = AVInstallation.genInstallationId();
        currentInstallation = new AVInstallation();
        currentInstallation.setInstallationId(id);
        currentInstallation.put(INSTALLATIONIDTAG, id);
        AVInstallation.saveCurrentInstalationToLocal(ctx);
    }

    private static String genInstallationId() {
        String packageName = AVOSCloud.applicationContext.getPackageName();
        String additionalStr = UUID.randomUUID().toString();
        return AVUtils.md5((String)(packageName + additionalStr));
    }

    private static void saveCurrentInstalationToLocal(Context ctx) {
        try {
            AVInstallation.writeInstallationFile(ctx, currentInstallation);
        }
        catch (Exception e) {
            LogUtil.log.e((String)LOGTAG, (Exception)e);
        }
    }

    public AVInstallation() {
        super(INSTALLATION_AVNAME);
        this.requestStatistic = false;
        this.initialize();
    }

    public AVInstallation(Parcel in) {
        super(in);
    }

    private void initialize() {
        try {
            if (!AVUtils.isBlankString((String)this.getInstallationId())) {
                this.put(INSTALLATIONIDTAG, this.getInstallationId(), false);
            }
            if (currentInstallation != null) {
                this.put(INSTALLATIONIDTAG, currentInstallation.getInstallationId(), false);
            }
            this.put(DEVICETYPETAG, AVInstallation.deviceType(), false);
            this.put("timeZone", AVInstallation.timezone(), false);
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace();
        }
    }

    private static String timezone() {
        TimeZone defaultTimezone = TimeZone.getDefault();
        return defaultTimezone != null ? defaultTimezone.getID() : "unknown";
    }

    public String getInstallationId() {
        return this.installationId;
    }

    protected void onSaveSuccess() {
        super.onSaveSuccess();
        try {
            AVInstallation.writeInstallationFile(AVOSCloud.applicationContext, this);
        }
        catch (Exception e) {
            LogUtil.log.e((String)LOGTAG, (Exception)e);
        }
    }

    protected void onDataSynchronized() {
        super.onDataSynchronized();
        this.onSaveSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSaveFailure() {
        LogUtil.avlog.d((String)"roll back installationId since error there");
        Class<AVInstallation> clazz = AVInstallation.class;
        synchronized (AVInstallation.class) {
            if (AVInstallation.readInstallationFile(AVOSCloud.applicationContext) == null) {
                AVInstallation.createNewInstallation(AVOSCloud.applicationContext);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static AVInstallation readInstallationFile(Context usingCtx) {
        if (null == usingCtx) {
            LogUtil.log.e((String)LOGTAG, (String)"Please call AVOSCloud.initialize at first in Application");
            return null;
        }
        String json = "";
        try {
            File installationFile = AVPersistenceUtils.getInstallationFile((Context)usingCtx);
            if (installationFile.exists()) {
                json = AVPersistenceUtils.readContentFromFile((File)installationFile);
                if (json.indexOf("{") >= 0) {
                    currentInstallation = (AVInstallation)((Object)JSON.parse((String)json));
                } else if (json.length() == UUID_LEN) {
                    currentInstallation = new AVInstallation();
                    currentInstallation.setInstallationId(json);
                    AVInstallation.saveCurrentInstalationToLocal(usingCtx);
                }
                return currentInstallation;
            }
        }
        catch (Exception e) {
            LogUtil.log.e((String)LOGTAG, (String)json, (Exception)e);
        }
        return null;
    }

    private static void writeInstallationFile(Context ctx, AVInstallation installation) throws IOException {
        if (null != ctx && null != installation) {
            installation.initialize();
            File installationFile = AVPersistenceUtils.getInstallationFile((Context)ctx);
            String jsonString = JSON.toJSONString((Object)((Object)installation), (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect});
            AVPersistenceUtils.saveContentToFile((String)jsonString, (File)installationFile);
        }
    }

    public static AVQuery<AVInstallation> getQuery() {
        AVQuery query = new AVQuery(INSTALLATION_AVNAME);
        return query;
    }

    public void put(String key, Object value) {
        super.put(key, value);
    }

    public void remove(String key) {
        super.remove(key);
    }

    private static String deviceType() {
        return "android";
    }

    protected boolean alwaysUsePost() {
        return true;
    }

    protected static void updateCurrentInstallation() {
        block4: {
            try {
                AVInstallation currentInstallation;
                if (AVOSCloud.showInternalDebugLog()) {
                    LogUtil.avlog.d((String)"try to update installation to fix date type data");
                }
                if ((currentInstallation = AVInstallation.readInstallationFile(AVOSCloud.applicationContext)) != null && !AVUtils.isBlankString((String)currentInstallation.getObjectId())) {
                    currentInstallation.fetchInBackground((GetCallback)new GetCallback<AVObject>(){

                        public void done(AVObject object, AVException e) {
                            block2: {
                                AVInstallation updatedInstallation = (AVInstallation)object;
                                try {
                                    AVInstallation.writeInstallationFile(AVOSCloud.applicationContext, updatedInstallation);
                                }
                                catch (IOException e1) {
                                    if (!AVOSCloud.showInternalDebugLog()) break block2;
                                    e1.printStackTrace();
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!AVOSCloud.showInternalDebugLog()) break block4;
                LogUtil.log.e((String)"failed to update installation", (Exception)e);
            }
        }
    }

    protected boolean isDirty() {
        return AVUtils.isBlankString((String)this.objectId) || !this.operationQueue.isEmpty() || this.getUpdatedAt() == null || System.currentTimeMillis() - this.getUpdatedAt().getTime() > 86400000L;
    }

    protected void rebuildInstanceData() {
        super.rebuildInstanceData();
        this.installationId = this.getString(INSTALLATIONIDTAG);
    }

    protected PaasClient getPaasClientInstance() {
        return PaasClient.pushInstance();
    }

    static {
        AVPowerfulUtils.createSettings((String)AVInstallation.class.getSimpleName(), (String)AVINSTALLATION_ENDPOINT, (String)INSTALLATION_AVNAME);
        AVPowerfulUtils.createSettings((String)INSTALLATION_AVNAME, (String)AVINSTALLATION_ENDPOINT, (String)INSTALLATION_AVNAME);
        AVObject.registerSubclass(AVInstallation.class);
        CREATOR = AVObject.AVObjectCreator.instance;
    }
}

