/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Bundle;
import com.avos.avoscloud.AVConversationHolder;
import com.avos.avoscloud.AVIMOperationQueue;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVSession;
import com.avos.avoscloud.AVSessionCacheHelper;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.BroadcastUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.PendingMessageCache;
import com.avos.avoscloud.PushService;
import com.avos.avoscloud.im.v2.AVIMBinaryMessage;
import com.avos.avoscloud.im.v2.AVIMException;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.AVIMTypedMessage;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avospush.push.AVWebSocketListener;
import com.avos.avospush.session.ConversationAckPacket;
import com.avos.avospush.session.MessageReceiptCache;
import com.avos.avospush.session.SessionAckPacket;
import com.avos.avospush.session.StaleMessageDepot;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import java.util.List;

class AVDefaultWebSocketListener
implements AVWebSocketListener {
    AVSession session;
    private final StaleMessageDepot depot;
    private static final String SESSION_MESSASGE_DEPOT = "com.avos.push.session.message.";
    private static final int CODE_SESSION_SIGNATURE_FAILURE = 4102;
    private static final int CODE_SESSION_TOKEN_FAILURE = 4112;

    public AVDefaultWebSocketListener(AVSession session) {
        this.session = session;
        this.depot = new StaleMessageDepot(SESSION_MESSASGE_DEPOT + session.getSelfPeerId());
    }

    @Override
    public void onWebSocketOpen() {
        if (this.session.sessionOpened.get() || this.session.sessionResume.get()) {
            if (AVOSCloud.showInternalDebugLog()) {
                LogUtil.avlog.d((String)"web socket opened, send session open.");
            }
            this.session.reopen();
        }
    }

    @Override
    public void onWebSocketClose() {
        if (!this.session.sessionPaused.getAndSet(true)) {
            try {
                this.session.sessionListener.onSessionPaused(AVOSCloud.applicationContext, this.session);
                if (this.session.pendingMessages != null && !this.session.pendingMessages.isEmpty()) {
                    while (!this.session.pendingMessages.isEmpty()) {
                        PendingMessageCache.Message m = this.session.pendingMessages.poll();
                        if (AVUtils.isBlankString((String)m.cid)) continue;
                        AVConversationHolder conversation = this.session.getConversationHolder(m.cid, 1);
                        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), conversation.conversationId, Integer.parseInt(m.id), new RuntimeException("Connection Lost"), Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE);
                    }
                }
                if (this.session.conversationOperationCache != null && !this.session.conversationOperationCache.isEmpty()) {
                    for (int i = 0; i < this.session.conversationOperationCache.cache.size(); ++i) {
                        int requestId = this.session.conversationOperationCache.cache.keyAt(i);
                        AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestId);
                        BroadcastUtil.sendIMLocalBroadcast(op.sessionId, op.conversationId, requestId, new IllegalStateException("Connection Lost"), Conversation.AVIMOperation.getAVIMOperation(op.operation));
                    }
                }
            }
            catch (Exception e) {
                this.session.sessionListener.onError(AVOSCloud.applicationContext, this.session, e);
            }
        }
    }

    @Override
    public void onDirectCommand(Messages.DirectCommand directCommand) {
        String msg = directCommand.getMsg();
        ByteString binaryMsg = directCommand.getBinaryMsg();
        String fromPeerId = directCommand.getFromPeerId();
        String conversationId = directCommand.getCid();
        Long timestamp = directCommand.getTimestamp();
        String messageId = directCommand.getId();
        int convType = directCommand.hasConvType() ? directCommand.getConvType() : 1;
        boolean isTransient = directCommand.hasTransient() && directCommand.getTransient();
        boolean hasMore = directCommand.hasHasMore() && directCommand.getHasMore();
        long patchTimestamp = directCommand.getPatchTimestamp();
        boolean mentionAll = directCommand.hasMentionAll() ? directCommand.getMentionAll() : false;
        ProtocolStringList mentionList = directCommand.getMentionPidsList();
        try {
            if (!isTransient) {
                if (!AVUtils.isBlankString((String)conversationId)) {
                    PushService.sendData(ConversationAckPacket.getConversationAckPacket(this.session.getSelfPeerId(), conversationId, messageId));
                } else {
                    PushService.sendData(this.genSessionAckPacket(messageId));
                }
            }
            if (this.depot.putStableMessage(messageId) && !AVUtils.isBlankString((String)conversationId)) {
                AVConversationHolder conversation = this.session.getConversationHolder(conversationId, convType);
                AVIMMessage message = null;
                if (AVUtils.isBlankString((String)msg) && null != binaryMsg) {
                    message = new AVIMBinaryMessage(conversationId, fromPeerId, timestamp, -1L);
                    ((AVIMBinaryMessage)message).setBytes(binaryMsg.toByteArray());
                } else {
                    message = new AVIMMessage(conversationId, fromPeerId, timestamp, -1L);
                    message.setContent(msg);
                }
                message.setMessageId(messageId);
                message.setUpdateAt(patchTimestamp);
                message.setMentionAll(mentionAll);
                message.setMentionList((List<String>)mentionList);
                conversation.onMessage(message, hasMore, isTransient);
            }
        }
        catch (Exception e) {
            this.session.sessionListener.onError(AVOSCloud.applicationContext, this.session, e);
        }
    }

    @Override
    public void onSessionCommand(String op, Integer requestKey, Messages.SessionCommand command) {
        int requestId;
        int n = requestId = null != requestKey ? requestKey : -65537;
        if (op.equals("opened")) {
            try {
                this.session.sessionOpened.set(true);
                this.session.sessionResume.set(false);
                if (!this.session.sessionPaused.getAndSet(false)) {
                    if (requestId != -65537) {
                        this.session.conversationOperationCache.poll(requestId);
                    }
                    this.session.sessionListener.onSessionOpen(AVOSCloud.applicationContext, this.session, requestId);
                } else {
                    if (AVOSCloud.showInternalDebugLog()) {
                        LogUtil.avlog.d((String)"session resumed");
                    }
                    this.session.sessionListener.onSessionResumed(AVOSCloud.applicationContext, this.session);
                }
                if (command.hasSt() && command.hasStTtl()) {
                    this.session.updateRealtimeSessionToken(command.getSt(), command.getStTtl());
                }
            }
            catch (Exception e) {
                this.session.sessionListener.onError(AVOSCloud.applicationContext, this.session, e);
            }
        } else if (op.equals("refreshed")) {
            if (command.hasSt() && command.hasStTtl()) {
                this.session.updateRealtimeSessionToken(command.getSt(), command.getStTtl());
            }
            this.session.sessionListener.onSessionTokenRenewed(AVOSCloud.applicationContext, this.session, requestId);
        } else if (op.equals("query_result")) {
            ProtocolStringList sessionPeerIds = command.getOnlineSessionPeerIdsList();
            this.session.sessionListener.onOnlineQuery(AVOSCloud.applicationContext, this.session, (List<String>)sessionPeerIds, requestId);
        } else if (op.equals("closed")) {
            if (command.hasCode()) {
                this.session.sessionListener.onSessionClosedFromServer(AVOSCloud.applicationContext, this.session, command.getCode());
            } else {
                if (requestId != -65537) {
                    this.session.conversationOperationCache.poll(requestId);
                }
                this.session.sessionListener.onSessionClose(AVOSCloud.applicationContext, this.session, requestId);
            }
        }
    }

    private void onAckError(Integer requestKey, Messages.AckCommand command, PendingMessageCache.Message m) {
        AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
        if (op.operation == Conversation.AVIMOperation.CLIENT_OPEN.getCode()) {
            this.session.sessionOpened.set(false);
            this.session.sessionResume.set(false);
        }
        Conversation.AVIMOperation operation = Conversation.AVIMOperation.getAVIMOperation(op.operation);
        int code = command.getCode();
        int appCode = command.hasAppCode() ? command.getAppCode() : 0;
        String reason = command.getReason();
        AVIMException error = new AVIMException(code, appCode, reason);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), op.conversationId, (int)requestKey, (Throwable)((Object)error), operation);
    }

    @Override
    public void onAckCommand(Integer requestKey, Messages.AckCommand ackCommand) {
        this.session.setServerAckReceived(System.currentTimeMillis() / 1000L);
        long timestamp = ackCommand.getT();
        PendingMessageCache.Message m = this.session.pendingMessages.poll(String.valueOf(requestKey));
        if (ackCommand.hasCode()) {
            this.onAckError(requestKey, ackCommand, m);
        } else if (null != m && !AVUtils.isBlankString((String)m.cid)) {
            AVConversationHolder conversation = this.session.getConversationHolder(m.cid, 1);
            this.session.conversationOperationCache.poll(requestKey);
            String msgId = ackCommand.getUid();
            conversation.onMessageSent(requestKey, msgId, timestamp);
            if (m.requestReceipt) {
                m.timestamp = timestamp;
                m.id = msgId;
                MessageReceiptCache.add(this.session.getSelfPeerId(), msgId, m);
            }
        }
    }

    @Override
    public void onGoaway() {
        if (null != this.session.sessionListener) {
            this.session.sessionListener.onGoaway(null, this.session);
        } else {
            LogUtil.avlog.d((String)"sessionListener is null, ignore GOAWAY command.");
        }
    }

    @Override
    public void onListenerAdded(boolean open) {
        if (open) {
            if (AVOSCloud.showInternalDebugLog()) {
                LogUtil.avlog.d((String)"web socket opened, send session open.");
            }
            this.onWebSocketOpen();
        }
    }

    @Override
    public void onListenerRemoved() {
    }

    @Override
    public void onMessageReceipt(Messages.RcpCommand rcpCommand) {
        try {
            if (rcpCommand.hasT()) {
                Long timestamp = rcpCommand.getT();
                String conversationId = rcpCommand.getCid();
                int convType = 1;
                if (!AVUtils.isBlankString((String)conversationId)) {
                    this.processConversationDeliveredAt(conversationId, convType, timestamp);
                    this.processMessageReceipt(rcpCommand.getId(), conversationId, convType, timestamp);
                }
            }
        }
        catch (Exception e) {
            this.session.sessionListener.onError(AVOSCloud.applicationContext, this.session, e);
        }
    }

    private void processConversationDeliveredAt(String conversationId, int convType, long timestamp) {
        AVConversationHolder conversation = this.session.getConversationHolder(conversationId, convType);
        conversation.onConversationDeliveredAtEvent(timestamp);
    }

    private void processMessageReceipt(String msgId, String conversationId, int convType, long timestamp) {
        Object messageCache = MessageReceiptCache.get(this.session.getSelfPeerId(), msgId);
        if (messageCache == null) {
            return;
        }
        PendingMessageCache.Message m = (PendingMessageCache.Message)messageCache;
        AVIMMessage msg = new AVIMMessage(conversationId, this.session.getSelfPeerId(), m.timestamp, timestamp);
        msg.setMessageId(m.id);
        msg.setContent(m.msg);
        msg.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusReceipt);
        AVConversationHolder conversation = this.session.getConversationHolder(conversationId, convType);
        conversation.onMessageReceipt(msg);
    }

    @Override
    public void onReadCmdReceipt(Messages.RcpCommand rcpCommand) {
        if (rcpCommand.hasRead() && rcpCommand.hasCid()) {
            Long timestamp = rcpCommand.getT();
            String conversationId = rcpCommand.getCid();
            AVConversationHolder conversation = this.session.getConversationHolder(conversationId, 1);
            conversation.onConversationReadAtEvent(timestamp);
        }
    }

    @Override
    public void onBlacklistCommand(String operation, Integer requestKey, Messages.BlacklistCommand blacklistCommand) {
        if ("query_result".equals(operation)) {
            AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
            if (null == op || op.operation != Conversation.AVIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY.getCode()) {
                LogUtil.log.w((String)("not found requestKey: " + requestKey));
            } else {
                ProtocolStringList result = blacklistCommand.getBlockedPidsList();
                String[] resultArray = new String[null == result ? 0 : result.size()];
                if (null != result) {
                    result.toArray(resultArray);
                }
                String cid = blacklistCommand.getSrcCid();
                Bundle bundle = new Bundle();
                bundle.putStringArray("callbackData", resultArray);
                BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), cid, (int)requestKey, bundle, Conversation.AVIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY);
            }
        } else if ("blocked".equals(operation) || "unblocked".equals(operation)) {
            String conversationId = blacklistCommand.getSrcCid();
            AVConversationHolder internalConversation = this.session.getConversationHolder(conversationId, 1);
            AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
            if (null != op && null != internalConversation) {
                Conversation.AVIMOperation originOperation = Conversation.AVIMOperation.getAVIMOperation(op.operation);
                internalConversation.onResponse4MemberBlock(originOperation, operation, requestKey, blacklistCommand);
            }
        }
    }

    @Override
    public void onConversationCommand(String operation, Integer requestKey, Messages.ConvCommand convCommand) {
        if ("results".equals(operation)) {
            AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
            if (null != op && op.operation == Conversation.AVIMOperation.CONVERSATION_QUERY.getCode()) {
                String result = convCommand.getResults().getData();
                Bundle bundle = new Bundle();
                bundle.putString("callbackData", result);
                BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), null, (int)requestKey, bundle, Conversation.AVIMOperation.CONVERSATION_QUERY);
            } else {
                LogUtil.log.w((String)("not found requestKey: " + requestKey));
            }
        } else if ("shutup_result".equals(operation)) {
            AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
            if (null != op && op.operation == Conversation.AVIMOperation.CONVERSATION_MUTED_MEMBER_QUERY.getCode()) {
                ProtocolStringList result = convCommand.getMList();
                String[] resultMembers = new String[null == result ? 0 : result.size()];
                if (null != result) {
                    result.toArray(resultMembers);
                }
                Bundle bundle = new Bundle();
                bundle.putStringArray("callbackData", resultMembers);
                BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), null, (int)requestKey, bundle, Conversation.AVIMOperation.CONVERSATION_MUTED_MEMBER_QUERY);
            } else {
                LogUtil.log.w((String)("not found requestKey: " + requestKey));
            }
        } else {
            String conversationId = null;
            int requestId = null != requestKey ? requestKey : -65537;
            Conversation.AVIMOperation originOperation = null;
            if ((operation.equals("added") || operation.equals("removed") || operation.equals("updated") || operation.equals("result") || operation.equals("shutup_added") || operation.equals("shutup_removed") || operation.equals("member_info_updated")) && requestId != -65537) {
                AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestId);
                if (null != op) {
                    originOperation = Conversation.AVIMOperation.getAVIMOperation(op.operation);
                    conversationId = op.conversationId;
                } else {
                    conversationId = convCommand.getCid();
                }
            } else {
                if (operation.equals("started")) {
                    this.session.conversationOperationCache.poll(requestId);
                }
                conversationId = convCommand.getCid();
            }
            int convType = 1;
            if (convCommand.hasTempConv() && convCommand.getTempConv()) {
                convType = 4;
            } else if (convCommand.hasTransient() && convCommand.getTransient()) {
                convType = 2;
            }
            if (!AVUtils.isBlankString((String)conversationId)) {
                AVConversationHolder conversation = this.session.getConversationHolder(conversationId, convType);
                conversation.processConversationCommandFromServer(originOperation, operation, requestId, convCommand);
            }
        }
    }

    private SessionAckPacket genSessionAckPacket(String messageId) {
        SessionAckPacket sap = new SessionAckPacket();
        sap.setPeerId(this.session.getSelfPeerId());
        if (!AVUtils.isBlankString((String)messageId)) {
            sap.setMessageId(messageId);
        }
        return sap;
    }

    @Override
    public void onError(Integer requestKey, Messages.ErrorCommand errorCommand) {
        if (null != requestKey && requestKey != -65537) {
            AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
            if (null != op && op.operation == Conversation.AVIMOperation.CLIENT_OPEN.getCode()) {
                this.session.sessionOpened.set(false);
                this.session.sessionResume.set(false);
            }
            int code = errorCommand.getCode();
            int appCode = errorCommand.hasAppCode() ? errorCommand.getAppCode() : 0;
            String reason = errorCommand.getReason();
            Conversation.AVIMOperation operation = null != op ? Conversation.AVIMOperation.getAVIMOperation(op.operation) : null;
            BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), null, (int)requestKey, (Throwable)((Object)new AVIMException(code, appCode, reason)), operation);
        }
        if (null == requestKey) {
            int code = errorCommand.getCode();
            if (4102 == code) {
                AVSessionCacheHelper.getTagCacheInstance().removeSession(this.session.getSelfPeerId());
            } else if (4112 == code) {
                this.session.updateRealtimeSessionToken("", 0);
                this.onWebSocketOpen();
            }
        }
    }

    @Override
    public void onHistoryMessageQuery(Integer requestKey, Messages.LogsCommand command) {
        if (null != requestKey && requestKey != -65537) {
            Messages.LogItem item;
            AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
            int convType = 1;
            if (command.getLogsCount() > 0 && null != (item = command.getLogs(0)) && item.hasConvType()) {
                convType = item.getConvType();
            }
            AVConversationHolder conversation = this.session.getConversationHolder(op.conversationId, convType);
            conversation.processMessages(requestKey, command.getLogsList());
        }
    }

    @Override
    public void onUnreadMessagesCommand(Messages.UnreadCommand unreadCommand) {
        List<Messages.UnreadTuple> unreadTupleList;
        this.session.updateLastNotifyTime(unreadCommand.getNotifTime());
        if (unreadCommand.getConvsCount() > 0 && null != (unreadTupleList = unreadCommand.getConvsList())) {
            for (Messages.UnreadTuple unreadTuple : unreadTupleList) {
                String msgId = unreadTuple.getMid();
                String msgContent = unreadTuple.getData();
                long ts = unreadTuple.getTimestamp();
                long updateTS = unreadTuple.getPatchTimestamp();
                String conversationId = unreadTuple.getCid();
                boolean mentioned = unreadTuple.getMentioned();
                ByteString binaryMsg = unreadTuple.getBinaryMsg();
                String from = unreadTuple.getFrom();
                int convType = unreadTuple.hasConvType() ? unreadTuple.getConvType() : 1;
                AVIMMessage message = null;
                if (AVUtils.isBlankString((String)msgContent) && null != binaryMsg) {
                    message = new AVIMBinaryMessage(conversationId, from, ts, -1L);
                    ((AVIMBinaryMessage)message).setBytes(binaryMsg.toByteArray());
                } else {
                    message = new AVIMMessage(conversationId, from, ts, -1L);
                    message.setContent(msgContent);
                }
                message.setMessageId(msgId);
                message.setUpdateAt(updateTS);
                AVConversationHolder conversation = this.session.getConversationHolder(conversationId, convType);
                conversation.onUnreadMessagesEvent(message, unreadTuple.getUnread(), mentioned);
            }
        }
    }

    @Override
    public void onMessagePatchCommand(boolean isModify, Integer requestKey, Messages.PatchCommand patchCommand) {
        this.updateLocalPatchTime(isModify, patchCommand);
        if (isModify) {
            if (patchCommand.getPatchesCount() > 0) {
                for (Messages.PatchItem patchItem : patchCommand.getPatchesList()) {
                    AVIMMessage message = AVIMTypedMessage.getMessage(patchItem.getCid(), patchItem.getMid(), patchItem.getData(), patchItem.getFrom(), patchItem.getTimestamp(), 0L, 0L);
                    message.setUpdateAt(patchItem.getPatchTimestamp());
                    AVConversationHolder conversation = this.session.getConversationHolder(patchItem.getCid(), 1);
                    conversation.onMessageUpdateEvent(message, patchItem.getRecall());
                }
            }
        } else {
            AVIMOperationQueue.Operation op = this.session.conversationOperationCache.poll(requestKey);
            Conversation.AVIMOperation operation = Conversation.AVIMOperation.getAVIMOperation(op.operation);
            Bundle bundle = new Bundle();
            bundle.putLong("message_patch_time", patchCommand.getLastPatchTime());
            BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), null, (int)requestKey, bundle, operation);
        }
    }

    private void updateLocalPatchTime(boolean isModify, Messages.PatchCommand patchCommand) {
        if (isModify) {
            long lastPatchTime = 0L;
            for (Messages.PatchItem item : patchCommand.getPatchesList()) {
                if (item.getPatchTimestamp() <= lastPatchTime) continue;
                lastPatchTime = item.getPatchTimestamp();
            }
            this.session.updateLastPatchTime(lastPatchTime);
        } else {
            this.session.updateLastPatchTime(patchCommand.getLastPatchTime());
        }
    }
}

