/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Pair;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVIMOperationQueue;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVSession;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.BroadcastUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.PendingMessageCache;
import com.avos.avoscloud.PushService;
import com.avos.avoscloud.PushServiceParcel;
import com.avos.avoscloud.Signature;
import com.avos.avoscloud.SignatureCallback;
import com.avos.avoscloud.SignatureFactory;
import com.avos.avoscloud.SignatureTask;
import com.avos.avoscloud.im.v2.AVIMBaseBroadcastReceiver;
import com.avos.avoscloud.im.v2.AVIMBinaryMessage;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMConversation;
import com.avos.avoscloud.im.v2.AVIMConversationEventHandler;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.AVIMMessageManagerHelper;
import com.avos.avoscloud.im.v2.AVIMMessageOption;
import com.avos.avoscloud.im.v2.AVIMMessageQueryDirection;
import com.avos.avoscloud.im.v2.AVIMOptions;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avoscloud.im.v2.callback.AVIMOperationFailure;
import com.avos.avoscloud.im.v2.conversation.AVIMConversationMemberInfo;
import com.avos.avoscloud.im.v2.conversation.ConversationMemberRole;
import com.avos.avospush.session.BlacklistCommandPacket;
import com.avos.avospush.session.ConversationControlPacket;
import com.avos.avospush.session.ConversationDirectMessagePacket;
import com.avos.avospush.session.ConversationMessageQueryPacket;
import com.avos.avospush.session.MessagePatchModifyPacket;
import com.avos.avospush.session.UnreadMessagesClearPacket;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=11)
class AVConversationHolder {
    AVSession session;
    String conversationId;
    int convType;
    private static final String GROUP_INVITE = "invite";
    private static final String GROUP_KICK = "kick";
    private static final String BLOCK_MEMBER = "conversation-block-clients";
    private static final String UNBLOCK_MEMBER = "conversation-unblock-clients";
    private String conversationGene = null;

    public AVConversationHolder(String conversationId, AVSession session, int convType) {
        this.session = session;
        this.conversationId = conversationId;
        this.conversationGene = this.getConversationGeneString();
        this.convType = convType;
    }

    public void addMembers(final List<String> members, final int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_ADD_MEMBER, requestId)) {
            return;
        }
        SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException e) {
                if (e == null) {
                    AVConversationHolder.this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_ADD_MEMBER.getCode(), AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId));
                    PushService.sendData(ConversationControlPacket.genConversationCommand(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, members, "add", null, sig, requestId));
                } else {
                    BroadcastUtil.sendIMLocalBroadcast(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId, e, Conversation.AVIMOperation.CONVERSATION_ADD_MEMBER);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (null != signatureFactory) {
                    return signatureFactory.createConversationSignature(AVConversationHolder.this.conversationId, AVConversationHolder.this.session.getSelfPeerId(), members, AVConversationHolder.GROUP_INVITE);
                }
                return null;
            }
        };
        new SignatureTask(callback).commit(this.session.getSelfPeerId());
    }

    public void kickMembers(final List<String> members, final int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_RM_MEMBER, requestId)) {
            return;
        }
        SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException e) {
                if (e == null) {
                    AVConversationHolder.this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_RM_MEMBER.getCode(), AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId));
                    PushService.sendData(ConversationControlPacket.genConversationCommand(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, members, "remove", null, sig, requestId));
                } else {
                    BroadcastUtil.sendIMLocalBroadcast(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId, e, Conversation.AVIMOperation.CONVERSATION_RM_MEMBER);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (signatureFactory != null) {
                    return signatureFactory.createConversationSignature(AVConversationHolder.this.conversationId, AVConversationHolder.this.session.getSelfPeerId(), members, AVConversationHolder.GROUP_KICK);
                }
                return null;
            }
        };
        new SignatureTask(callback).commit(this.session.getSelfPeerId());
    }

    public void muteMembers(List<String> members, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_MUTE_MEMBER, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_MUTE_MEMBER.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, members, "add_shutup", null, null, requestId));
    }

    public void unmuteMembers(List<String> members, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_UNMUTE_MEMBER, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_UNMUTE_MEMBER.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, members, "remove_shutup", null, null, requestId));
    }

    public void blockMembers(final List<String> members, final int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_BLOCK_MEMBER, requestId)) {
            return;
        }
        SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException e) {
                if (e == null) {
                    AVConversationHolder.this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_BLOCK_MEMBER.getCode(), AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId));
                    PushService.sendData(BlacklistCommandPacket.genBlacklistCommandPacket(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, "block", members, sig, requestId));
                } else {
                    BroadcastUtil.sendIMLocalBroadcast(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId, e, Conversation.AVIMOperation.CONVERSATION_BLOCK_MEMBER);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (signatureFactory != null) {
                    return signatureFactory.createBlacklistSignature(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, members, AVConversationHolder.BLOCK_MEMBER);
                }
                return null;
            }
        };
        new SignatureTask(callback).commit(this.session.getSelfPeerId());
    }

    public void unblockMembers(final List<String> members, final int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_UNBLOCK_MEMBER, requestId)) {
            return;
        }
        SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException e) {
                if (e == null) {
                    AVConversationHolder.this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_UNBLOCK_MEMBER.getCode(), AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId));
                    PushService.sendData(BlacklistCommandPacket.genBlacklistCommandPacket(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, "unblock", members, sig, requestId));
                } else {
                    BroadcastUtil.sendIMLocalBroadcast(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId, e, Conversation.AVIMOperation.CONVERSATION_UNBLOCK_MEMBER);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (signatureFactory != null) {
                    return signatureFactory.createBlacklistSignature(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, members, AVConversationHolder.UNBLOCK_MEMBER);
                }
                return null;
            }
        };
        new SignatureTask(callback).commit(this.session.getSelfPeerId());
    }

    public void join(final int requestId) {
        SignatureCallback callback = new SignatureCallback(){

            @Override
            public void onSignatureReady(Signature sig, AVException e) {
                if (e == null) {
                    AVConversationHolder.this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_JOIN.getCode(), AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId));
                    PushService.sendData(ConversationControlPacket.genConversationCommand(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, Arrays.asList(AVConversationHolder.this.session.getSelfPeerId()), "add", null, sig, requestId));
                } else {
                    BroadcastUtil.sendIMLocalBroadcast(AVConversationHolder.this.session.getSelfPeerId(), AVConversationHolder.this.conversationId, requestId, e, Conversation.AVIMOperation.CONVERSATION_JOIN);
                }
            }

            @Override
            public Signature computeSignature() throws SignatureFactory.SignatureException {
                SignatureFactory signatureFactory = AVIMOptions.getGlobalOptions().getSignatureFactory();
                if (null != signatureFactory) {
                    return signatureFactory.createConversationSignature(AVConversationHolder.this.conversationId, AVConversationHolder.this.session.getSelfPeerId(), Arrays.asList(AVConversationHolder.this.session.getSelfPeerId()), AVConversationHolder.GROUP_INVITE);
                }
                return null;
            }
        };
        new SignatureTask(callback).commit(this.session.getSelfPeerId());
    }

    public void queryMutedMembers(int offset, int limit, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_MUTED_MEMBER_QUERY, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_MUTED_MEMBER_QUERY.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        ConversationControlPacket packet = ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, null, "query_shutup", null, null, requestId);
        packet.setQueryOffset(offset);
        packet.setQueryLimit(limit);
        PushService.sendData(packet);
    }

    public void queryBlockedMembers(int offset, int limit, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        BlacklistCommandPacket packet = BlacklistCommandPacket.genBlacklistCommandPacket(this.session.getSelfPeerId(), this.conversationId, "query", offset, limit, requestId);
        PushService.sendData(packet);
    }

    public void updateInfo(Map<String, Object> attr, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_UPDATE, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_UPDATE.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, null, "update", attr, null, requestId));
    }

    public void promoteMember(Map<String, Object> member, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_PROMOTE_MEMBER, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_PROMOTE_MEMBER.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        ConversationControlPacket ccp = ConversationControlPacket.genConversationMemberCommand(this.session.getSelfPeerId(), this.conversationId, "member_info_update", member, null, requestId);
        PushService.sendData(ccp);
    }

    public void sendMessage(AVIMMessage message, int requestId, AVIMMessageOption messageOption) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE, requestId)) {
            return;
        }
        byte[] binaryMessage = null;
        if (message instanceof AVIMBinaryMessage) {
            binaryMessage = ((AVIMBinaryMessage)message).getBytes();
        }
        this.session.storeMessage(PendingMessageCache.Message.getMessage(message.getContent(), String.valueOf(requestId), messageOption.isReceipt(), this.conversationId), requestId);
        PushService.sendData(ConversationDirectMessagePacket.getConversationMessagePacket(this.session.getSelfPeerId(), this.conversationId, message.getContent(), binaryMessage, message.isMentionAll(), message.getMentionList(), AVIMMessageManagerHelper.getMessageToken(message), messageOption, requestId));
    }

    public void patchMessage(PushServiceParcel pushServiceParcel, Conversation.AVIMOperation operation, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_RECALL_MESSAGE, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(operation.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        if (operation.equals((Object)Conversation.AVIMOperation.CONVERSATION_RECALL_MESSAGE)) {
            String messageId = pushServiceParcel.getRecallMessage().getMessageId();
            long timeStamp = pushServiceParcel.getRecallMessage().getTimestamp();
            PushService.sendData(MessagePatchModifyPacket.getMessagePatchPacketForRecall(this.session.getSelfPeerId(), this.conversationId, messageId, timeStamp, requestId));
        } else if (operation.equals((Object)Conversation.AVIMOperation.CONVERSATION_UPDATE_MESSAGE)) {
            String messageId = pushServiceParcel.getOldMessage().getMessageId();
            long timeStamp = pushServiceParcel.getOldMessage().getTimestamp();
            AVIMMessage newMessage = pushServiceParcel.getNewMessage();
            String data = newMessage.getContent();
            boolean mentionAll = newMessage.isMentionAll();
            List<String> mentionList = newMessage.getMentionList();
            byte[] binaryData = null;
            if (newMessage instanceof AVIMBinaryMessage) {
                binaryData = ((AVIMBinaryMessage)newMessage).getBytes();
            }
            PushService.sendData(MessagePatchModifyPacket.getMessagePatchPacketForUpdate(this.session.getSelfPeerId(), this.conversationId, messageId, data, binaryData, mentionAll, mentionList, timeStamp, requestId));
        }
    }

    public void quit(int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_QUIT, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_QUIT.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, Arrays.asList(this.session.getSelfPeerId()), "remove", null, null, requestId));
    }

    public void queryHistoryMessages(String msgId, long timestamp, int limit, String toMsgId, long toTimestamp, int requestId) {
        this.queryHistoryMessages(msgId, timestamp, false, toMsgId, toTimestamp, false, AVIMMessageQueryDirection.AVIMMessageQueryDirectionFromNewToOld.getCode(), limit, 0, requestId);
    }

    public void queryHistoryMessages(String msgId, long timestamp, boolean sclosed, String toMsgId, long toTimestamp, boolean toclosed, int direct, int limit, int msgType, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationMessageQueryPacket.getConversationMessageQueryPacket(this.session.getSelfPeerId(), this.conversationId, msgId, timestamp, sclosed, toMsgId, toTimestamp, toclosed, direct, limit, msgType, requestId));
    }

    public void mute(int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_MUTE, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_MUTE.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, null, "mute", null, null, requestId));
    }

    public void unmute(int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_UNMUTE, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_UNMUTE.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, null, "unmute", null, null, requestId));
    }

    public void getMemberCount(int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_MEMBER_COUNT_QUERY, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_MEMBER_COUNT_QUERY.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, null, "count", null, null, requestId));
    }

    private void getReceiptTime(int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_FETCH_RECEIPT_TIME, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_FETCH_RECEIPT_TIME.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        PushService.sendData(ConversationControlPacket.genConversationCommand(this.session.getSelfPeerId(), this.conversationId, null, "max_read", null, null, requestId));
    }

    private void read(String msgId, long timestamp, int requestId) {
        if (!this.checkSessionStatus(Conversation.AVIMOperation.CONVERSATION_READ, requestId)) {
            return;
        }
        this.session.conversationOperationCache.offer(AVIMOperationQueue.Operation.getOperation(Conversation.AVIMOperation.CONVERSATION_READ.getCode(), this.session.getSelfPeerId(), this.conversationId, requestId));
        UnreadMessagesClearPacket packet = UnreadMessagesClearPacket.getUnreadClearPacket(this.session.getSelfPeerId(), this.conversationId, msgId, timestamp, requestId);
        PushService.sendData(packet);
        this.onUnreadMessagesEvent(null, 0, false);
    }

    private boolean checkSessionStatus(Conversation.AVIMOperation operation, int requestId) {
        if (this.session.sessionPaused.get()) {
            RuntimeException se = new RuntimeException("Connection Lost");
            BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, se, operation);
            return false;
        }
        return true;
    }

    public void processConversationCommandFromClient(Conversation.AVIMOperation imop, Map<String, Object> params, int requestId) {
        List members = null != params ? (List)params.get("conversation.member") : null;
        switch (imop) {
            case CONVERSATION_JOIN: {
                this.join(requestId);
                break;
            }
            case CONVERSATION_ADD_MEMBER: {
                this.addMembers(members, requestId);
                break;
            }
            case CONVERSATION_RM_MEMBER: {
                this.kickMembers(members, requestId);
                break;
            }
            case CONVERSATION_QUIT: {
                this.quit(requestId);
                break;
            }
            case CONVERSATION_UPDATE: {
                Map attr = (Map)params.get("conversation.attributes");
                this.updateInfo(attr, requestId);
                break;
            }
            case CONVERSATION_MUTE: {
                this.mute(requestId);
                break;
            }
            case CONVERSATION_UNMUTE: {
                this.unmute(requestId);
                break;
            }
            case CONVERSATION_MEMBER_COUNT_QUERY: {
                this.getMemberCount(requestId);
                break;
            }
            case CONVERSATION_FETCH_RECEIPT_TIME: {
                this.getReceiptTime(requestId);
                break;
            }
            case CONVERSATION_READ: {
                String messageId = "";
                if (null != params && params.containsKey("mid")) {
                    messageId = (String)params.get("mid");
                }
                long messageTS = 0L;
                if (null != params && params.containsKey("ts")) {
                    messageTS = ((Number)params.get("ts")).longValue();
                }
                this.read(messageId, messageTS, requestId);
                break;
            }
            case CONVERSATION_PROMOTE_MEMBER: {
                Map memberInfo;
                Map map = memberInfo = null != params ? (Map)params.get("conversation.memberDetails") : null;
                if (null == memberInfo) break;
                this.promoteMember(memberInfo, requestId);
                break;
            }
            case CONVERSATION_MUTE_MEMBER: {
                this.muteMembers(members, requestId);
                break;
            }
            case CONVERSATION_UNMUTE_MEMBER: {
                this.unmuteMembers(members, requestId);
                break;
            }
            case CONVERSATION_BLOCK_MEMBER: {
                this.blockMembers(members, requestId);
                break;
            }
            case CONVERSATION_UNBLOCK_MEMBER: {
                this.unblockMembers(members, requestId);
                break;
            }
            case CONVERSATION_MUTED_MEMBER_QUERY: {
                int offset = (Integer)params.get("skip");
                int sizeLimit = (Integer)params.get("limit");
                this.queryMutedMembers(offset, sizeLimit, requestId);
                break;
            }
            case CONVERSATION_BLOCKED_MEMBER_QUERY: {
                int blockedOffset = (Integer)params.get("skip");
                int blockedSizeLimit = (Integer)params.get("limit");
                this.queryBlockedMembers(blockedOffset, blockedSizeLimit, requestId);
                break;
            }
            case CONVERSATION_MESSAGE_QUERY: {
                String msgId = (String)params.get("mid");
                long ts = ((Number)params.get("ts")).longValue();
                boolean sclosed = (Boolean)params.get("sinc");
                String toMsgId = (String)params.get("tmid");
                long tts = ((Number)params.get("tt")).longValue();
                boolean tclosed = (Boolean)params.get("tinc");
                int direct = (Integer)params.get("direct");
                int limit = (Integer)params.get("limit");
                int msgType = (Integer)params.get("type");
                this.queryHistoryMessages(msgId, ts, sclosed, toMsgId, tts, tclosed, direct, limit, msgType, requestId);
                break;
            }
        }
    }

    public void processConversationCommandFromServer(Conversation.AVIMOperation imop, String operation, int requestId, Messages.ConvCommand convCommand) {
        if ("started".equals(operation)) {
            this.onConversationCreated(requestId, convCommand);
        } else if ("joined".equals(operation)) {
            String invitedBy = convCommand.getInitBy();
            if (invitedBy.equals(this.session.getSelfPeerId())) {
                return;
            }
            if (!invitedBy.equals(this.session.getSelfPeerId())) {
                this.onInvitedToConversation(invitedBy, convCommand);
            }
        } else if ("removed".equals(operation)) {
            if (requestId != -65537) {
                if (null == imop) {
                    LogUtil.log.e((String)("IllegalState. operation is null, excepted is QUIT / KICK, originalOp=" + operation));
                } else if (imop.getCode() == Conversation.AVIMOperation.CONVERSATION_QUIT.getCode()) {
                    this.onQuit(requestId);
                } else if (imop.getCode() == Conversation.AVIMOperation.CONVERSATION_RM_MEMBER.getCode()) {
                    this.onKicked(requestId);
                }
            }
        } else if ("added".equals(operation)) {
            if (requestId != -65537) {
                if (null == imop) {
                    LogUtil.log.e((String)("IllegalState. operation is null, excepted is JOIN / INVITE, originalOp=" + operation));
                } else if (imop.getCode() == Conversation.AVIMOperation.CONVERSATION_JOIN.getCode()) {
                    this.onJoined(requestId);
                } else if (imop.getCode() == Conversation.AVIMOperation.CONVERSATION_ADD_MEMBER.getCode()) {
                    this.onInvited(requestId);
                }
            }
        } else if ("left".equals(operation)) {
            String invitedBy = convCommand.getInitBy();
            if (invitedBy != null && !invitedBy.equals(this.session.getSelfPeerId())) {
                this.onKickedFromConversation(invitedBy);
            }
        } else if ("updated".equals(operation)) {
            if (null == imop) {
                this.onInfoChangedNotify(convCommand);
            } else if (Conversation.AVIMOperation.CONVERSATION_MUTE.getCode() == imop.getCode()) {
                this.onMuted(requestId);
            } else if (Conversation.AVIMOperation.CONVERSATION_UNMUTE.getCode() == imop.getCode()) {
                this.onUnmuted(requestId);
            } else if (Conversation.AVIMOperation.CONVERSATION_UPDATE.getCode() == imop.getCode()) {
                this.onInfoUpdated(requestId, convCommand.getUdate());
            }
        } else if ("result".equals(operation)) {
            int memberCount = convCommand.getCount();
            this.onMemberCount(memberCount, requestId);
        } else if ("max_read".equals(operation)) {
            long receiptTime = convCommand.getMaxAckTimestamp();
            long readTime = convCommand.getMaxReadTimestamp();
            this.onTimesReceipt(requestId, receiptTime, readTime);
        } else if ("member_info_updated".equals(operation)) {
            this.onMemberUpdated(requestId);
        } else if ("shutup_added".equals(operation) || "shutup_removed".equals(operation)) {
            if (null == imop) {
                LogUtil.log.e((String)("IllegalState. operation is null, excepted is member_shutupped / member_unshutuped, originalOp=" + operation));
            } else {
                this.onResponse4MemberMute(imop, operation, requestId, convCommand);
            }
        } else if ("members_joined".equals(operation)) {
            String invitedBy = convCommand.getInitBy();
            ProtocolStringList joinedMembers = convCommand.getMList();
            this.onMembersJoined((List<String>)joinedMembers, invitedBy);
        } else if ("members_left".equals(operation)) {
            String removedBy = convCommand.getInitBy();
            ProtocolStringList leftMembers = convCommand.getMList();
            this.onMembersLeft((List<String>)leftMembers, removedBy);
        } else if ("member_info_changed".equals(operation)) {
            String changedBy = convCommand.getInitBy();
            Messages.ConvMemberInfo member = convCommand.getInfo();
            this.onMemberChanged(changedBy, member);
        } else if ("shutuped".equals(operation) || "unshutuped".equals(operation)) {
            String operator = convCommand.getInitBy();
            if (null != operator && operator.equals(this.session.getSelfPeerId())) {
                return;
            }
            this.onSelfShutupedNotify("shutuped".equals(operation), operator, convCommand);
        } else if ("members_shutuped".equals(operation) || "members_unshutuped".equals(operation)) {
            String operator = convCommand.getInitBy();
            if (null != operator && operator.equals(this.session.getSelfPeerId())) {
                return;
            }
            this.onMemberShutupedNotify("members_shutuped".equals(operation), operator, convCommand);
        } else if ("blocked".equals(operation) || "unblocked".equals(operation)) {
            String operator = convCommand.getInitBy();
            if (null != operator && operator.equals(this.session.getSelfPeerId())) {
                return;
            }
            this.onSelfBlockedNotify("blocked".equals(operation), operator, convCommand);
        } else if ("members_blocked".equals(operation) || "members_unblocked".equals(operation)) {
            String operator = convCommand.getInitBy();
            if (null != operator && operator.equals(this.session.getSelfPeerId())) {
                return;
            }
            this.onMemberBlockedNotify("members_blocked".equals(operation), operator, convCommand);
        }
    }

    void onResponse4MemberBlock(Conversation.AVIMOperation imop, String operation, int reqeustId, Messages.BlacklistCommand blacklistCommand) {
        if (null == blacklistCommand) {
            return;
        }
        ProtocolStringList allowedList = blacklistCommand.getAllowedPidsList();
        List<Messages.ErrorCommand> errorCommandList = blacklistCommand.getFailedPidsList();
        Bundle bundle = this.genBundleFromPartiallyResult((List<String>)allowedList, errorCommandList);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), blacklistCommand.getSrcCid(), reqeustId, bundle, imop);
    }

    void onResponse4MemberMute(Conversation.AVIMOperation imop, String operation, int requestId, Messages.ConvCommand convCommand) {
        if (null == convCommand) {
            return;
        }
        ProtocolStringList allowedList = convCommand.getAllowedPidsList();
        List<Messages.ErrorCommand> errorCommandList = convCommand.getFailedPidsList();
        Bundle bundle = this.genBundleFromPartiallyResult((List<String>)allowedList, errorCommandList);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, bundle, imop);
    }

    private Bundle genBundleFromPartiallyResult(List<String> allowedList, List<Messages.ErrorCommand> errorCommandList) {
        String[] allowedMembers = new String[null == allowedList ? 0 : allowedList.size()];
        if (null != allowedList) {
            allowedList.toArray(allowedMembers);
        }
        int errorCommandSize = null == errorCommandList ? 0 : errorCommandList.size();
        ArrayList<AVIMOperationFailure> failedList = new ArrayList<AVIMOperationFailure>(errorCommandSize);
        if (null != errorCommandList) {
            for (Messages.ErrorCommand cmd : errorCommandList) {
                AVIMOperationFailure failure = new AVIMOperationFailure();
                failure.setCode(cmd.getCode());
                failure.setMemberIds((List<String>)cmd.getPidsList());
                failure.setReason(cmd.getReason());
                failedList.add(failure);
            }
        }
        Bundle bundle = new Bundle();
        bundle.putStringArray("callbackConvMemberMutedSUCC", allowedMembers);
        bundle.putParcelableArrayList("callbackConvMemberMutedFAIL", failedList);
        return bundle;
    }

    public void processMessages(Integer requestKey, List<Messages.LogItem> logItems) {
        ArrayList<AVIMMessage> messageList = new ArrayList<AVIMMessage>();
        long lastDeliveredAt = -1L;
        long lastReadAt = -1L;
        for (Messages.LogItem item : logItems) {
            long readAt;
            long ackAt = item.hasAckAt() ? -1L : item.getAckAt();
            long l = readAt = item.hasReadAt() ? -1L : item.getReadAt();
            if (lastDeliveredAt < ackAt) {
                lastDeliveredAt = ackAt;
            }
            if (lastReadAt < readAt) {
                lastReadAt = readAt;
            }
            String from = item.getFrom();
            String data = item.getData();
            long timestamp = item.getTimestamp();
            String msgId = item.getMsgId();
            boolean mentionAll = item.hasMentionAll() ? item.getMentionAll() : false;
            ProtocolStringList mentionList = item.getMentionPidsList();
            boolean isBinaryMsg = item.hasBin() && item.getBin();
            AVIMMessage message = null;
            if (isBinaryMsg && null != data) {
                message = new AVIMBinaryMessage(this.conversationId, from, timestamp, ackAt, readAt);
                ((AVIMBinaryMessage)message).setBytes(AVUtils.base64Decode((String)data.toString()));
            } else {
                if (!(data instanceof String) && !(data instanceof JSON)) continue;
                message = new AVIMMessage(this.conversationId, from, timestamp, ackAt, readAt);
                message.setContent(data.toString());
            }
            message.setMessageId(msgId);
            message.setMentionAll(mentionAll);
            message.setMentionList((List<String>)mentionList);
            message = AVIMMessageManagerHelper.parseTypedMessage(message);
            messageList.add(message);
        }
        this.onHistoryMessageQuery(messageList, requestKey, lastDeliveredAt, lastReadAt);
    }

    void onConversationCreated(int requestId, Messages.ConvCommand convCommand) {
        String createdAt = convCommand.getCdate();
        String cid = convCommand.getCid();
        int tempTTL = convCommand.hasTempConvTTL() ? convCommand.getTempConvTTL() : 0;
        Bundle bundle = new Bundle();
        bundle.putString("callbackCreatedAt", createdAt);
        bundle.putString("callbackconversation", cid);
        bundle.putInt("callbackTemporaryTTL", tempTTL);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, bundle, Conversation.AVIMOperation.CONVERSATION_CREATION);
    }

    void onJoined(int requestId) {
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, Conversation.AVIMOperation.CONVERSATION_JOIN);
    }

    void onInvited(int requestId) {
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, Conversation.AVIMOperation.CONVERSATION_ADD_MEMBER);
    }

    void onKicked(int requestId) {
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, Conversation.AVIMOperation.CONVERSATION_RM_MEMBER);
    }

    void onQuit(int requestId) {
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, Conversation.AVIMOperation.CONVERSATION_QUIT);
    }

    private void onInfoUpdated(int requestId, String updatedAt) {
        Bundle bundle = new Bundle();
        bundle.putString("callbackUpdatedAt", updatedAt);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, bundle, Conversation.AVIMOperation.CONVERSATION_UPDATE);
    }

    private void onMemberUpdated(int requestId) {
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, Conversation.AVIMOperation.CONVERSATION_PROMOTE_MEMBER);
    }

    private void onMemberChanged(final String operator, Messages.ConvMemberInfo member) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = client.getConversation(this.conversationId);
            String objectId = member.getInfoId();
            String roleStr = member.getRole();
            String peerId = member.getPid();
            final AVIMConversationMemberInfo memberInfo = new AVIMConversationMemberInfo(objectId, this.conversationId, peerId, ConversationMemberRole.fromString(roleStr));
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    handler.processEvent(50017, operator, memberInfo, conversation);
                }
            });
        }
    }

    void onMuted(int requestId) {
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, Conversation.AVIMOperation.CONVERSATION_MUTE);
    }

    void onUnmuted(int requestId) {
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, Conversation.AVIMOperation.CONVERSATION_UNMUTE);
    }

    void onMemberCount(int count, int requestId) {
        Bundle bundle = new Bundle();
        bundle.putInt("callbackMemberCount", count);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, bundle, Conversation.AVIMOperation.CONVERSATION_MEMBER_COUNT_QUERY);
    }

    void onMessageSent(int requestId, String msgId, long timestamp) {
        Bundle bundle = new Bundle();
        bundle.putLong("callbackMessageTimeStamp", timestamp);
        bundle.putString("callbackMessageId", msgId);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, bundle, Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE);
    }

    void onHistoryMessageQuery(ArrayList<AVIMMessage> messages, int requestId, long deliveredAt, long readAt) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("callbackHistoryMessages", messages);
        bundle.putLong("callbackDeliveredAt", deliveredAt);
        bundle.putLong("callbackReadAt", readAt);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, bundle, Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY);
        this.session.sendUnreadMessagesAck(messages, this.conversationId);
    }

    void onTimesReceipt(int requestId, long deliveredAt, long readAt) {
        Bundle bundle = new Bundle();
        bundle.putLong("callbackReadAt", readAt);
        bundle.putLong("callbackDeliveredAt", deliveredAt);
        BroadcastUtil.sendIMLocalBroadcast(this.session.getSelfPeerId(), this.conversationId, requestId, bundle, Conversation.AVIMOperation.CONVERSATION_FETCH_RECEIPT_TIME);
    }

    void onInvitedToConversation(final String invitedBy, Messages.ConvCommand convCommand) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = this.parseConversation(client, convCommand);
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    handler.processEvent(50008, invitedBy, null, conversation);
                }
            });
        }
    }

    void onInfoChangedNotify(Messages.ConvCommand convCommand) {
        AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (null != handler) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            AVIMConversation conversation = this.parseConversation(client, convCommand);
            String operator = convCommand.getInitBy();
            Messages.JsonObjectMessage attrMsg = convCommand.getAttr();
            JSONObject operand = null;
            if (null == attrMsg || null == attrMsg.getData() || attrMsg.getData().trim().length() < 1) {
                conversation.setMustFetch();
            } else {
                operand = JSON.parseObject((String)attrMsg.getData());
                AVIMConversation.mergeConversationFromJsonObject(conversation, operand);
            }
            handler.processEvent(50026, operator, operand, conversation);
        }
    }

    void onKickedFromConversation(final String invitedBy) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
        final AVIMConversation conversation = client.getConversation(this.conversationId);
        if (handler != null) {
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    handler.processEvent(50009, invitedBy, null, conversation);
                }
            });
        }
        this.session.removeConversation(this.conversationId);
        AVIMMessageManagerHelper.removeConversationCache(conversation);
    }

    void onSelfShutupedNotify(final boolean isMuted, final String operator, Messages.ConvCommand convCommand) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = this.parseConversation(client, convCommand);
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    if (isMuted) {
                        handler.processEvent(50018, operator, null, conversation);
                    } else {
                        handler.processEvent(50019, operator, null, conversation);
                    }
                }
            });
        }
    }

    void onMemberShutupedNotify(final boolean isMuted, final String operator, Messages.ConvCommand convCommand) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        ProtocolStringList members = convCommand.getMList();
        if (handler != null && null != members) {
            final ArrayList copyMembers = new ArrayList(members);
            copyMembers.remove(this.session.getSelfPeerId());
            if (copyMembers.size() < 1) {
                LogUtil.log.d((String)"Notification --- ignore shutuped/unshutuped notify bcz duplicated.");
            } else {
                AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
                final AVIMConversation conversation = this.parseConversation(client, convCommand);
                this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                    @Override
                    public void done() {
                        if (isMuted) {
                            handler.processEvent(50020, operator, copyMembers, conversation);
                        } else {
                            handler.processEvent(50021, operator, copyMembers, conversation);
                        }
                    }
                });
            }
        }
    }

    void onSelfBlockedNotify(final boolean isBlocked, final String operator, Messages.ConvCommand convCommand) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (null == handler) {
            return;
        }
        AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
        final AVIMConversation conversation = this.parseConversation(client, convCommand);
        this.refreshConversationThenNotify(conversation, new SimpleCallback(){

            @Override
            public void done() {
                if (isBlocked) {
                    handler.processEvent(50022, operator, null, conversation);
                } else {
                    handler.processEvent(50023, operator, null, conversation);
                }
            }
        });
    }

    void onMemberBlockedNotify(final boolean isBlocked, final String operator, Messages.ConvCommand convCommand) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        ProtocolStringList members = convCommand.getMList();
        if (handler != null && null != members) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            AVIMConversation conversation = this.parseConversation(client, convCommand);
            this.refreshConversationThenNotify(conversation, new SimpleCallback((List)members, conversation){
                final /* synthetic */ List val$members;
                final /* synthetic */ AVIMConversation val$conversation;
                {
                    this.val$members = list;
                    this.val$conversation = aVIMConversation;
                }

                @Override
                public void done() {
                    if (isBlocked) {
                        handler.processEvent(50024, operator, this.val$members, this.val$conversation);
                    } else {
                        handler.processEvent(50025, operator, this.val$members, this.val$conversation);
                    }
                }
            });
        }
    }

    private AVIMConversation parseConversation(AVIMClient client, Messages.ConvCommand convCommand) {
        if (null == client || null == convCommand) {
            return null;
        }
        boolean isTemp = convCommand.hasTempConv() ? convCommand.getTempConv() : false;
        boolean isTransient = convCommand.hasTransient() ? convCommand.getTransient() : false;
        int tempTTL = convCommand.hasTempConvTTL() ? convCommand.getTempConvTTL() : 0;
        AVIMConversation conversation = client.getConversation(this.conversationId, isTransient, isTemp);
        conversation.setTemporaryExpiredat(System.currentTimeMillis() / 1000L + (long)tempTTL);
        return conversation;
    }

    void onMembersJoined(final List<String> members, final String invitedBy) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = client.getConversation(this.conversationId);
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    handler.processEvent(50005, invitedBy, members, conversation);
                }
            });
        }
    }

    void onMembersLeft(final List<String> members, final String removedBy) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = client.getConversation(this.conversationId);
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    handler.processEvent(50004, removedBy, members, conversation);
                }
            });
        }
    }

    void onMessageUpdateEvent(final AVIMMessage message, final boolean isRecall) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = client.getConversation(this.conversationId);
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    if (isRecall) {
                        handler.processEvent(50016, message, null, conversation);
                    } else {
                        handler.processEvent(50015, message, null, conversation);
                    }
                }
            });
        }
    }

    void onMessage(final AVIMMessage message, final boolean hasMore, final boolean isTransient) {
        message.setMessageIOType(AVIMMessage.AVIMMessageIOType.AVIMMessageIOTypeIn);
        message.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusSent);
        final AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
        this.refreshConversationThenNotify(message, new SimpleCallback(){

            @Override
            public void done() {
                AVIMMessageManagerHelper.processMessage(message, AVConversationHolder.this.convType, client, hasMore, isTransient);
            }
        });
    }

    void onMessageReceipt(final AVIMMessage message) {
        this.refreshConversationThenNotify(message, new SimpleCallback(){

            @Override
            public void done() {
                AVIMMessageManagerHelper.processMessageReceipt(message, AVIMClient.getInstance(AVConversationHolder.this.session.getSelfPeerId()));
            }
        });
    }

    private void refreshConversationThenNotify(AVIMMessage message, SimpleCallback callback) {
        if (null == message || null == callback) {
            return;
        }
        AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
        AVIMConversation conversation = client.getConversation(message.getConversationId(), this.convType);
        this.refreshConversationThenNotify(conversation, callback);
    }

    private void refreshConversationThenNotify(final AVIMConversation conversation, final SimpleCallback callback) {
        if (null == conversation) {
            return;
        }
        if (!conversation.isShouldFetch()) {
            callback.done();
        } else {
            LogUtil.log.d((String)("try to query conversation info for id=" + conversation.getConversationId()));
            Map<String, Object> fetchParams = conversation.getFetchRequestParams();
            Map params = (Map)JSON.parseObject((String)JSON.toJSONString(fetchParams), Map.class);
            int requestId = AVUtils.getNextIMRequestId();
            Conversation.AVIMOperation operation = Conversation.AVIMOperation.CONVERSATION_QUERY;
            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).registerReceiver((BroadcastReceiver)new AVIMBaseBroadcastReceiver(null){

                @Override
                public void execute(Intent intent, Throwable ex) {
                    if (null == ex) {
                        conversation.processQueryResult(intent.getExtras().getSerializable("callbackData"));
                        LogUtil.log.d((String)("updated conversation info. id=" + conversation.getConversationId()));
                    }
                    callback.done();
                }
            }, new IntentFilter(operation.getOperation() + requestId));
            this.session.conversationQuery(params, requestId);
        }
    }

    void onUnreadMessagesEvent(AVIMMessage message, int unreadCount, boolean mentioned) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (null == handler) {
            LogUtil.log.d((String)"conversation event handler is none.");
        } else {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = client.getConversation(this.conversationId);
            if (conversation.getUnreadMessagesCount() == unreadCount) {
                LogUtil.log.d((String)"unread count isn't changed, ignore command...");
            } else {
                final Pair unreadInfo = new Pair((Object)unreadCount, (Object)mentioned);
                if (null != message) {
                    message.setMessageIOType(AVIMMessage.AVIMMessageIOType.AVIMMessageIOTypeIn);
                    message.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusSent);
                    message = AVIMMessageManagerHelper.parseTypedMessage(message);
                }
                final AVIMMessage msgCopy = message;
                this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                    @Override
                    public void done() {
                        handler.processEvent(50012, msgCopy, unreadInfo, conversation);
                    }
                });
            }
        }
    }

    void onConversationReadAtEvent(final long readAt) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = client.getConversation(this.conversationId);
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    handler.processEvent(50013, readAt, null, conversation);
                }
            });
        }
    }

    void onConversationDeliveredAtEvent(final long deliveredAt) {
        final AVIMConversationEventHandler handler = AVIMMessageManagerHelper.getConversationEventHandler();
        if (handler != null) {
            AVIMClient client = AVIMClient.getInstance(this.session.getSelfPeerId());
            final AVIMConversation conversation = client.getConversation(this.conversationId);
            this.refreshConversationThenNotify(conversation, new SimpleCallback(){

                @Override
                public void done() {
                    handler.processEvent(50014, deliveredAt, null, conversation);
                }
            });
        }
    }

    private String getConversationGeneString() {
        if (AVUtils.isBlankString((String)this.conversationGene)) {
            HashMap<String, String> conversationGeneMap = new HashMap<String, String>();
            conversationGeneMap.put("conversation.client", this.session.getSelfPeerId());
            conversationGeneMap.put("convesration.id", this.conversationId);
            this.conversationGene = JSON.toJSONString(conversationGeneMap);
        }
        return this.conversationGene;
    }

    private static abstract class SimpleCallback {
        private SimpleCallback() {
        }

        public abstract void done();
    }
}

