/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.content.Intent;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.AVMixPushManager;
import com.avos.avoscloud.AVNotificationManager;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.utils.StringUtils;
import com.meizu.cloud.pushsdk.MzPushMessageReceiver;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.notification.PushNotificationBuilder;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;

public class AVFlymePushMessageReceiver
extends MzPushMessageReceiver {
    private final String FLYME_VERDOR = "mz";

    private void updateAVInstallation(String flymePushId) {
        if (!AVUtils.isBlankString((String)flymePushId)) {
            String localProfile;
            AVInstallation installation = AVInstallation.getCurrentInstallation();
            if (!"mz".equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)"mz");
            }
            if (!flymePushId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)flymePushId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(AVMixPushManager.flymeDevicePrifile)) {
                installation.put("deviceProfile", (Object)AVMixPushManager.flymeDevicePrifile);
            }
            installation.saveInBackground(new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        LogUtil.avlog.e((String)"update installation error!", (Exception)e);
                    } else {
                        LogUtil.avlog.d((String)"flyme push registration successful!");
                    }
                }
            });
        }
    }

    public void onMessage(Context context, String s) {
        if (null == context || null == s) {
            return;
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("throughMessage coming, message=" + s));
        }
        AVNotificationManager.getInstance().processMixPushMessage(s);
    }

    public void onMessage(Context var1, String message, String platformExtra) {
    }

    public void onMessage(Context context, Intent intent) {
    }

    public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
        String pushId;
        if (null == context || null == pushSwitchStatus) {
            return;
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("switchNotificationMessage=" + pushSwitchStatus.isSwitchNotificationMessage() + ", switchThroughMessage=" + pushSwitchStatus.isSwitchThroughMessage() + ", pushId=" + pushSwitchStatus.getPushId()));
        }
        if (!StringUtils.isBlankString((String)(pushId = pushSwitchStatus.getPushId())) && (pushSwitchStatus.isSwitchNotificationMessage() || pushSwitchStatus.isSwitchThroughMessage())) {
            this.updateAVInstallation(pushId);
        }
    }

    public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
        String pushId;
        if (null == context || null == registerStatus) {
            return;
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("register successed, pushId=" + registerStatus.getPushId()));
        }
        if (!AVUtils.isBlankContent((String)(pushId = registerStatus.getPushId()))) {
            this.updateAVInstallation(pushId);
        }
    }

    public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
        if (null == context || null == unRegisterStatus) {
            return;
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("unregister successed, message=" + unRegisterStatus.getMessage()));
        }
    }

    public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
    }

    public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
    }

    public void onUnRegister(Context var1, boolean var2) {
    }

    public void onRegister(Context var1, String var2) {
    }

    public void onUpdateNotificationBuilder(PushNotificationBuilder pushNotificationBuilder) {
        if (AVMixPushManager.flymeMStatusBarIcon != 0) {
            pushNotificationBuilder.setmStatusbarIcon(AVMixPushManager.flymeMStatusBarIcon);
        }
    }

    public void onNotificationArrived(Context context, MzPushMessage var2) {
    }

    public void onNotificationClicked(Context context, MzPushMessage var2) {
        if (null == context || null == var2) {
            return;
        }
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("notificationClicked, message=" + var2.getSelfDefineContentString()));
        }
        String selfDefineContentString = var2.getSelfDefineContentString();
        AVNotificationManager.getInstance().processMixNotification(selfDefineContentString, "com.avos.avoscloud.flyme_notification_action");
    }

    public void onNotificationDeleted(Context context, MzPushMessage var2) {
    }

    public void onNotifyMessageArrived(Context context, String message) {
    }
}

