/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.AVMixPushManager;
import com.avos.avoscloud.AVNotificationManager;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.SaveCallback;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import java.util.List;

public class AVMiPushMessageReceiver
extends PushMessageReceiver {
    private void updateAVInstallation(String miRegId) {
        if (!AVUtils.isBlankString((String)miRegId)) {
            String localProfile;
            AVInstallation installation = AVInstallation.getCurrentInstallation();
            if (!"mi".equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)"mi");
            }
            if (!miRegId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)miRegId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(AVMixPushManager.miDeviceProfile)) {
                installation.put("deviceProfile", (Object)AVMixPushManager.miDeviceProfile);
            }
            installation.saveInBackground(new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        LogUtil.avlog.e((String)"update installation error!", (Exception)e);
                    } else {
                        LogUtil.avlog.d((String)"Xiaomi push registration successful!");
                    }
                }
            });
        }
    }

    private void processMiPushMessage(MiPushMessage miPushMessage) {
        if (null != miPushMessage) {
            String title = miPushMessage.getTitle();
            String description = miPushMessage.getDescription();
            String content = miPushMessage.getContent();
            JSONObject jsonObject = null;
            if (!TextUtils.isEmpty((CharSequence)content)) {
                try {
                    jsonObject = JSON.parseObject((String)content);
                }
                catch (Exception exception) {
                    LogUtil.avlog.e((String)("Parsing json data error, " + content), (Exception)exception);
                }
            }
            if (null == jsonObject) {
                jsonObject = new JSONObject();
            }
            if (!AVUtils.isBlankString((String)title)) {
                jsonObject.put("title", (Object)title);
            }
            if (!AVUtils.isBlankString((String)description)) {
                jsonObject.put("alert", (Object)description);
            }
            AVNotificationManager.getInstance().processMixPushMessage(jsonObject.toJSONString());
        }
    }

    private void processMiNotification(MiPushMessage miPushMessage) {
        String content;
        if (null != miPushMessage && !AVUtils.isBlankString((String)(content = miPushMessage.getContent()))) {
            AVNotificationManager.getInstance().processMixNotification(content, "com.avos.avoscloud.mi_notification_action");
        }
    }

    public void onReceiveRegisterResult(Context context, MiPushCommandMessage miPushCommandMessage) {
        String cmdArg1;
        super.onReceiveRegisterResult(context, miPushCommandMessage);
        String command = miPushCommandMessage.getCommand();
        List arguments = miPushCommandMessage.getCommandArguments();
        String string = cmdArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        if ("register".equals(command)) {
            if (miPushCommandMessage.getResultCode() == 0L) {
                this.updateAVInstallation(cmdArg1);
            } else {
                LogUtil.avlog.d((String)("register error, " + miPushCommandMessage.toString()));
            }
        }
    }

    public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
        String content;
        if (null != miPushMessage && !AVUtils.isBlankString((String)(content = miPushMessage.getContent()))) {
            AVNotificationManager.getInstance().porcessMixNotificationArrived(content, "com.avos.avoscloud.mi_notification_arrived_action");
        }
    }

    public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
        this.processMiPushMessage(miPushMessage);
    }

    public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
        this.processMiNotification(miPushMessage);
    }
}

