package com.avos.avoscloud;

import android.Manifest;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;

import java.util.List;

/**
 * Created by wli on 16/6/27.
 */
public class AVMixPushManager {

  static final String MIXPUSH_PROFILE = "deviceProfile";

  /**
   * 小米推送的 deviceProfile
   */
  static String miDeviceProfile = "";

  /**
   * 华为推送的 deviceProfile
   */
  static String hwDeviceProfile = "";

  /**
   * 魅族推送的 deviceProfile
   */
  static String flymeDeviceProfile = "";
  static int flymeMStatusBarIcon = 0;

  /**
   * VIVO 推送的 deviceProfile
   */
  static String vivoDeviceProfile = "";

  static String oppoDeviceProfile = "";

  /**
   * 注册小米推送
   * 只有 appId、appKey 有效 && MIUI && manifest 正确填写 才能注册
   *
   * @param context
   * @param miAppId
   * @param miAppKey
   */
  public static void registerXiaomiPush(Context context, String miAppId, String miAppKey) {
    registerXiaomiPush(context, miAppId, miAppKey, "");
  }

  /**
   * 注册小米推送
   * 只有 appId、appKey 有效 && MIUI && manifest 正确填写 才能注册
   *
   * @param context
   * @param miAppId
   * @param miAppKey
   * @param profile  小米推送配置
   */
  public static void registerXiaomiPush(Context context, String miAppId, String miAppKey, String profile) {
    if (null == context) {
      throw new IllegalArgumentException("context cannot be null.");
    }

    if (AVUtils.isBlankString(miAppId)) {
      throw new IllegalArgumentException("miAppId cannot be null.");
    }

    if (AVUtils.isBlankString(miAppKey)) {
      throw new IllegalArgumentException("miAppKey cannot be null.");
    }

    if (!isXiaomiPhone()) {
      printErrorLog("register error, is not xiaomi phone!");
      return;
    }

    if (!checkXiaomiManifest(context)) {
      printErrorLog("register error, mainifest is incomplete!");
      return;
    }

    miDeviceProfile = profile;

    com.xiaomi.mipush.sdk.MiPushClient.registerPush(context, miAppId, miAppKey);

    if (AVOSCloud.isDebugLogEnabled()) {
      LogUtil.avlog.d("start register mi push");
    }
  }

  /**
   * 注册华为推送
   * 只有 EMUI && manifest 正确填写 才能注册
   *
   * 这是老版本推送，现在已经不推荐使用了。
   *
   * @param context
   */
  @Deprecated
  public static void registerHuaweiPush(Context context) throws IllegalAccessException {
    registerHuaweiPush(context, "");
  }

  /**
   * 注册华为推送
   * 只有是 EMUI && manifest 正确填写 才能注册
   *
   * 这是老版本推送，现在已经不推荐使用了。
   *
   * @param context
   * @param profile 华为推送配置
   */
  @Deprecated
  public static void registerHuaweiPush(Context context, String profile) throws IllegalAccessException {
    throw new IllegalAccessException("registerHuaweiPush is deprecated, please use registerHMSPush instead.");
  }

  /**
   * 初始化方法，建议在 Application onCreate 里面调用
   * @param application
   */
  public static void registerHMSPush(Application application) {
    registerHMSPush(application, "");
  }

  /**
   * 初始化方法，建议在 Application onCreate 里面调用
   * @param application
   * @param profile 华为推送配置
   */
  public static void registerHMSPush(Application application, String profile) {
    if (null == application) {
      throw new IllegalArgumentException("[HMS] context cannot be null.");
    }

    if (!isHuaweiPhone()) {
      printErrorLog("[HMS] register error, is not huawei phone!");
      return;
    }

    if (!checkHuaweiManifest(application)) {
      printErrorLog("[HMS] register error, mainifest is incomplete!");
      return;
    }

    hwDeviceProfile = profile;
    boolean hmsInitResult = com.huawei.android.hms.agent.HMSAgent.init(application);
    if (!hmsInitResult) {
      LogUtil.avlog.e("failed to init HMSAgent.");
    }

    if (AVOSCloud.isDebugLogEnabled()) {
      LogUtil.avlog.d("[HMS] start register HMS push");
    }
  }

  /**
   * 连接HMS SDK， 可能拉起界面(包括升级引导等)，建议在第一个界面进行连接。
   * 此方法可以重复调用，没必要为了只调用一次做复杂处理
   * 方法为异步调用，调用结果在主线程回调
   *  Connecting to the HMS SDK may pull up the activity (including upgrade guard, etc.), and it is recommended that you connect in the first activity.
   *  This method can be called repeatedly, and there is no need to do complex processing for only one call at a time
   *  Method is called asynchronously, and the result is invoked in the main thread callback
   */
  public static void connectHMS(Activity activity) {
    if (null == activity) {
      throw new IllegalArgumentException("[HMS] activity cannot be null.");
    }
    com.huawei.android.hms.agent.HMSAgent.connect(activity,
        new com.huawei.android.hms.agent.common.handler.ConnectHandler() {
          @Override
          public void onConnect(int rst) {
            LogUtil.avlog.d("[HMS] connect end:" + rst);
            com.huawei.android.hms.agent.HMSAgent.Push.getToken(
                new com.huawei.android.hms.agent.push.handler.GetTokenHandler() {
                  @Override
                  public void onResult(int rst) {
                    LogUtil.avlog.d("[HMS] get token: end. returnCode=" + rst);
                  }
                }
            );
          }
        });
  }

  /**
   * 打开/关闭透传消息
   *  Turn on/off notification bar messages
   * @param enable 打开/关闭（默认为打开）
   *                Turn ON/off
   */
  public static void setHMSReceiveNormalMsg(final boolean enable) {
    com.huawei.android.hms.agent.HMSAgent.Push.enableReceiveNormalMsg(enable,
        new com.huawei.android.hms.agent.push.handler.EnableReceiveNormalMsgHandler() {
          @Override
          public void onResult(int rst) {
            LogUtil.avlog.d("[HMS] enableReceiveNormalMsg(flag=" + enable + ") returnCode=" + rst);
          }
        });
  }

  /**
   * 打开/关闭通知栏消息
   *  Turn on/off notification bar messages
   * @param enable 打开/关闭（默认为打开）
   *                Turn ON/off
   */
  public static void setHMSReceiveNotifyMsg(final boolean enable) {
    com.huawei.android.hms.agent.HMSAgent.Push.enableReceiveNotifyMsg(enable,
        new com.huawei.android.hms.agent.push.handler.EnableReceiveNotifyMsgHandler() {
          @Override
          public void onResult(int rst) {
            LogUtil.avlog.d("[HMS] enableReceiveNotifyMsg(flag=" + enable + ") returnCode=" + rst);
          }
        });
  }
  /**
   * 请求push协议展示
   *  Request Push Protocol Display
   */
  public static void showHMSAgreement() {
    com.huawei.android.hms.agent.HMSAgent.Push.queryAgreement(new com.huawei.android.hms.agent.push.handler.QueryAgreementHandler() {
      @Override
      public void onResult(int rst) {
        LogUtil.avlog.d("[HMS] query agreement result: " + rst);
      }
    });
  }

  /**
   * 注册魅族推送
   * @param context
   * @param flymeId
   * @param flymeKey
   * @param profile 魅族推送配置
   */
  public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, String profile) {
    if (null == context) {
      printErrorLog("register error, context is null!");
      return false;
    }
    boolean result = false;
    if (!com.meizu.cloud.pushsdk.util.MzSystemUtils.isBrandMeizu(context)) {
      printErrorLog("register error, is not flyme phone!");
    } else {
      if (!checkFlymeManifest(context)) {
        printErrorLog("register error, mainifest is incomplete!");
      } else {
        flymeDeviceProfile = profile;
        com.meizu.cloud.pushsdk.PushManager.register(context, flymeId, flymeKey);
        result = true;
        if (AVOSCloud.isDebugLogEnabled()) {
          LogUtil.avlog.d("start register flyme push");
        }
      }
    }
    return result;
  }

  /**
   * 注册魅族推送
   * @param context
   * @param flymeId
   * @param flymeKey
   */
  public static boolean registerFlymePush(Context context, String flymeId, String flymeKey) {
    return registerFlymePush(context, flymeId, flymeKey, "");
  }

  public static void setFlymeMStatusbarIcon(int icon) {
    flymeMStatusBarIcon = icon;
  }

  /**
   * 初始化方法，建议在 Application onCreate 里面调用
   * @param application
   */
  public static boolean registerVIVOPush(Application application) {
    return AVMixPushManager.registerVIVOPush(application, "");
  }
  /**
   * 初始化方法，建议在 Application onCreate 里面调用
   * @param application
   */
  public static boolean registerVIVOPush(Application application, String profile) {
    vivoDeviceProfile = profile;
    com.vivo.push.PushClient client = com.vivo.push.PushClient.getInstance(application.getApplicationContext());
    try {
      client.checkManifest();
      client.initialize();
      return true;
    } catch (com.vivo.push.util.VivoPushException ex) {
      printErrorLog("register error, mainifest is incomplete! details=" + ex.getMessage());
      return false;
    }
  }

  /**
   * turn off VIVO push.
   */
  public static void turnOffVIVOPush(final AVCallback<Boolean> callback) {
    com.vivo.push.PushClient.getInstance(AVOSCloud.applicationContext).turnOffPush(new com.vivo.push.IPushActionListener() {
      public void onStateChanged(int state) {
        if (null == callback) {
          AVException exception = null;
          if (0 != state) {
            exception = new AVException(AVException.UNKNOWN, "VIVO server internal error, state=" + state);
          }
          callback.internalDone(null == exception, exception);
        }
      }
    });
  }

  /**
   * turn on VIVO push.
   */
  public static void turnOnVIVOPush(final AVCallback<Boolean> callback) {
    com.vivo.push.PushClient.getInstance(AVOSCloud.applicationContext).turnOnPush(new com.vivo.push.IPushActionListener() {
      public void onStateChanged(int state) {
        if (null == callback) {
          AVException exception = null;
          if (0 != state) {
            exception = new AVException(AVException.UNKNOWN, "VIVO server internal error, state=" + state);
          }
          callback.internalDone(null == exception, exception);
        }
      }
    });
  }

  /**
   * current device support VIVO push or not.
   *
   * @param context
   * @return
   */
  public static boolean isSupportVIVOPush(Context context) {
    com.vivo.push.PushClient client = com.vivo.push.PushClient.getInstance(context);
    if (null == client) {
      return false;
    }
    return client.isSupport();
  }

  /**
   * bind vivo alias
   *
   * @param context
   * @param alias
   * @param callback
   */
  public static void bindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
    if (null == context) {
      if (null != callback) {
        callback.internalDone(false, new AVException(AVException.VALIDATION_ERROR, "context is null"));
      }
    } else {
      com.vivo.push.PushClient.getInstance(context).bindAlias(alias, new com.vivo.push.IPushActionListener() {
        public void onStateChanged(int state) {
          if (null == callback) {
            AVException exception = null;
            if (0 != state) {
              exception = new AVException(AVException.UNKNOWN, "VIVO server internal error, state=" + state);
            }
            callback.internalDone(null == exception, exception);
          }
        }
      });
    }
  }

  /**
   * unbind vivo alias
   *
   * @param context
   * @param alias
   * @param callback
   */
  public static void unbindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
    if (null == context) {
      if (null != callback) {
        callback.internalDone(false, new AVException(AVException.VALIDATION_ERROR, "context is null"));
      }
    } else {
      com.vivo.push.PushClient.getInstance(context).unBindAlias(alias, new com.vivo.push.IPushActionListener() {
        public void onStateChanged(int state) {
          if (null == callback) {
            AVException exception = null;
            if (0 != state) {
              exception = new AVException(AVException.UNKNOWN, "VIVO server internal error, state=" + state);
            }
            callback.internalDone(null == exception, exception);
          }
        }
      });
    }
  }

  /**
   * get vivo alias
   *
   * @param context
   * @return
   */
  public static String getVIVOAlias(Context context) {
    if (null == context) {
      return null;
    }
    return com.vivo.push.PushClient.getInstance(context).getAlias();
  }

  /**
   * set vivo topic
   *
   * @param context
   * @param topic
   * @param callback
   */
  public static void setVIVOTopic(Context context, String topic, final AVCallback<Boolean> callback) {
    if (null == context) {
      if (null != callback) {
        callback.internalDone(false, new AVException(AVException.VALIDATION_ERROR, "context is null"));
      }
    } else {
      com.vivo.push.PushClient.getInstance(context).setTopic(topic, new com.vivo.push.IPushActionListener() {
        public void onStateChanged(int state) {
          if (null == callback) {
            AVException exception = null;
            if (0 != state) {
              exception = new AVException(AVException.UNKNOWN, "VIVO server internal error, state=" + state);
            }
            callback.internalDone(null == exception, exception);
          }
        }
      });
    }
  }

  /**
   * delete vivo topic
   *
   * @param context
   * @param topic
   * @param callback
   */
  public static void delVIVOTopic(Context context, String topic, final AVCallback<Boolean> callback) {
    if (null == context) {
      if (null != callback) {
        callback.internalDone(false, new AVException(AVException.VALIDATION_ERROR, "context is null"));
      }
    } else {
      com.vivo.push.PushClient.getInstance(context).delTopic(topic, new com.vivo.push.IPushActionListener() {
        public void onStateChanged(int state) {
          if (null == callback) {
            AVException exception = null;
            if (0 != state) {
              exception = new AVException(AVException.UNKNOWN, "VIVO server internal error, state=" + state);
            }
            callback.internalDone(null == exception, exception);
          }
        }
      });
    }
  }

  /**
   * get vivo topics
   *
   * @param context
   * @return
   */
  public static List<String> getVIVOTopics(Context context) {
    if (null == context) {
      return null;
    }
    return com.vivo.push.PushClient.getInstance(context).getTopics();
  }

  /**
   * Oppo push
   */


  public static boolean registerOppoPush(Context context, String appKey, String appSecret,
                                         AVOPPOPushAdapter callback) {
    if (!isSupportOppoPush(context)) {
      return false;
    }
    com.coloros.mcssdk.PushManager.getInstance().register(context, appKey, appSecret, callback);
    return true;
  }

  public static boolean isSupportOppoPush(Context context) {
    return com.coloros.mcssdk.PushManager.isSupportPush(context);
  }

  public static void pauseOppoPush() {
    com.coloros.mcssdk.PushManager.getInstance().pausePush();
  }

  public static void resumeOppoPush() {
    com.coloros.mcssdk.PushManager.getInstance().resumePush();
  }

  public static void setOppoPushTime(List<Integer> weekDays, int startHour, int startMinute,
                                     int endHour, int endMinute) {
    com.coloros.mcssdk.PushManager.getInstance().setPushTime(weekDays, startHour, startMinute,
        endHour, endMinute);
  }

  public static void getOppoPushTime() {
    com.coloros.mcssdk.PushManager.getInstance().getPushTime();
  }

  public static void setOppoAliases(List<String> aliases) {
    com.coloros.mcssdk.PushManager.getInstance().setAliases(aliases);
  }

  public static void unsetOppoAlias(String alias) {
    com.coloros.mcssdk.PushManager.getInstance().unsetAlias(alias);
  }

  public static void getOppoAliases() {
    com.coloros.mcssdk.PushManager.getInstance().getAliases();
  }

  public static void setOppoUserAccount(String account) {
    com.coloros.mcssdk.PushManager.getInstance().setUserAccount(account);
  }

  public static void unsetOppoUserAccouts(List<String> accounts) {
    com.coloros.mcssdk.PushManager.getInstance().unsetUserAccounts(accounts);
  }

  public static void getOppoUserAccounts() {
    com.coloros.mcssdk.PushManager.getInstance().getUserAccounts();
  }

  public static void setOppoTags(List<String> tags) {
    com.coloros.mcssdk.PushManager.getInstance().setTags(tags);
  }

  public static void unsetOppoTags(List<String> tags) {
    com.coloros.mcssdk.PushManager.getInstance().unsetTags(tags);
  }

  public static void getOppoTags() {
    com.coloros.mcssdk.PushManager.getInstance().getTags();
  }

  public static void getOppoPushStatus() {
    com.coloros.mcssdk.PushManager.getInstance().getPushStatus();
  }

  public static void getOppoNotificationStatus() {
    com.coloros.mcssdk.PushManager.getInstance().getNotificationStatus();
  }

  /**
   * 取消混合推送的注册
   * 取消成功后，消息会通过 LeanCloud websocket 发送
   */
  public static void unRegisterMixPush() {
    AVInstallation installation = AVInstallation.getCurrentInstallation();
    String vendor = installation.getString(AVInstallation.VENDOR);
    if (!AVUtils.isBlankContent(vendor)) {
      installation.put(AVInstallation.VENDOR, "lc");
      installation.saveInBackground(new SaveCallback() {
        @Override
        public void done(AVException e) {
          if (null != e) {
            printErrorLog("unRegisterMixPush error!");
          } else {
            LogUtil.avlog.d("Registration canceled successfully!");
          }
        }
      });
    }
  }

  private static boolean isHuaweiPhone() {
    final String phoneBrand = Build.BRAND;
    try {
      return (phoneBrand.equalsIgnoreCase("huawei") || phoneBrand.equalsIgnoreCase("honor"));
    } catch (Exception e) {
      return false;
    }
  }

  private static boolean isXiaomiPhone() {
    final String phoneManufacturer = Build.MANUFACTURER;
    return !AVUtils.isBlankString(phoneManufacturer)
      && phoneManufacturer.toLowerCase().contains("xiaomi");
  }

  private static boolean checkXiaomiManifest(Context context) {
    try {
      return AVManifestUtils.checkReceiver(context, AVMiPushMessageReceiver.class);
    } catch (Exception e) {
      LogUtil.avlog.d(e.getMessage());
    }
    return false;
  }

  private static boolean checkHuaweiManifest(Context context) {
    boolean result = false;
    try {
      result = AVManifestUtils.checkPermission(context, android.Manifest.permission.INTERNET)
        && AVManifestUtils.checkPermission(context, android.Manifest.permission.ACCESS_NETWORK_STATE)
        && AVManifestUtils.checkPermission(context, android.Manifest.permission.ACCESS_WIFI_STATE)
        && AVManifestUtils.checkPermission(context, android.Manifest.permission.READ_PHONE_STATE)
        && AVManifestUtils.checkReceiver(context, AVHMSPushMessageReceiver.class);
    } catch (Exception e) {
    }
    return result;
  }

  private static boolean checkFlymeManifest(Context context) {
    boolean result = false;
    try {
      result = AVManifestUtils.checkPermission(context, android.Manifest.permission.INTERNET)
        && AVManifestUtils.checkPermission(context, android.Manifest.permission.READ_PHONE_STATE)
        && AVManifestUtils.checkPermission(context, android.Manifest.permission.ACCESS_NETWORK_STATE)
        && AVManifestUtils.checkPermission(context, Manifest.permission.WRITE_EXTERNAL_STORAGE)
        && AVManifestUtils.checkReceiver(context, AVFlymePushMessageReceiver.class);
    } catch (Exception e) {
    }
    return result;
  }

  private static void printErrorLog(String error) {
    if (AVOSCloud.isDebugLogEnabled() && !AVUtils.isBlankString(error)) {
      LogUtil.avlog.e(error);
    }
  }
}
