/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.AVMixPushManager;
import com.avos.avoscloud.AVNotificationManager;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.utils.StringUtils;
import com.huawei.hms.support.api.push.PushReceiver;

public class AVHMSPushMessageReceiver
extends PushReceiver {
    static final String MIXPUSH_PRIFILE = "deviceProfile";
    static final String VENDOR = "HMS";

    private void updateAVInstallation(String hwToken) {
        String localProfile;
        if (StringUtils.isBlankString((String)hwToken)) {
            return;
        }
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        if (!VENDOR.equals(installation.getString("vendor"))) {
            installation.put("vendor", (Object)VENDOR);
        }
        if (!hwToken.equals(installation.getString("registrationId"))) {
            installation.put("registrationId", (Object)hwToken);
        }
        if (null == (localProfile = installation.getString(MIXPUSH_PRIFILE))) {
            localProfile = "";
        }
        if (!localProfile.equals(AVMixPushManager.hwDeviceProfile)) {
            installation.put(MIXPUSH_PRIFILE, (Object)AVMixPushManager.hwDeviceProfile);
        }
        installation.saveInBackground(new SaveCallback(){

            public void done(AVException e) {
                if (null != e) {
                    LogUtil.avlog.e((String)"update installation error!", (Exception)e);
                } else {
                    LogUtil.avlog.d((String)"Huawei push registration successful!");
                }
            }
        });
    }

    public void onToken(Context context, String token, Bundle bundle) {
        this.updateAVInstallation(token);
    }

    public void onPushMsg(Context var1, byte[] var2, String var3) {
        try {
            String message = new String(var2, "UTF-8");
            AVNotificationManager.getInstance().processMixPushMessage(message);
        }
        catch (Exception ex) {
            LogUtil.avlog.e((String)"failed to process PushMessage.", (Exception)ex);
        }
    }

    public void onEvent(Context context, PushReceiver.Event event, Bundle extras) {
        LogUtil.avlog.d((String)("received Notify Event. Event=" + event));
        if (PushReceiver.Event.NOTIFICATION_CLICK_BTN.equals((Object)event) || PushReceiver.Event.NOTIFICATION_OPENED.equals((Object)event)) {
            int notifyId = extras.getInt("pushNotifyId", 0);
            LogUtil.avlog.d((String)("received Push Event. notifyId:" + notifyId));
            if (0 != notifyId) {
                NotificationManager manager = (NotificationManager)context.getSystemService("notification");
                manager.cancel(notifyId);
            }
        } else {
            LogUtil.avlog.d((String)"unknow event.");
        }
        super.onEvent(context, event, extras);
    }

    public void onPushState(Context context, boolean pushState) {
        LogUtil.avlog.d((String)("pushState changed, current=" + pushState));
    }
}

