/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.utils.StringUtils;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;

public class AVFirebaseInstanceIDService
extends FirebaseInstanceIdService {
    private final String VENDOR = "fcm";

    public void onTokenRefresh() {
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        this.sendRegistrationToServer(refreshedToken);
        LogUtil.log.d((String)("refreshed token: " + refreshedToken));
    }

    private void sendRegistrationToServer(String refreshedToken) {
        if (StringUtils.isBlankString((String)refreshedToken)) {
            return;
        }
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        if (!"fcm".equals(installation.getString("vendor"))) {
            installation.put("vendor", (Object)"fcm");
        }
        if (!refreshedToken.equals(installation.getString("registrationId"))) {
            installation.put("registrationId", (Object)refreshedToken);
        }
        installation.saveInBackground(new SaveCallback(){

            public void done(AVException e) {
                if (null != e) {
                    LogUtil.avlog.e((String)"failed to update installation.", (Exception)e);
                } else {
                    LogUtil.avlog.d((String)"succeed to update installation.");
                }
            }
        });
        LogUtil.log.d((String)("FCM registration success! registrationId=" + refreshedToken));
    }
}

