/*
 * Decompiled with CFR 0.152.
 */
package cn.lazytool.json;

import cn.lazytool.core.collection.CollectionTools;
import cn.lazytool.core.util.ArrayTools;
import cn.lazytool.core.util.StringTools;
import cn.lazytool.json.JSON;
import cn.lazytool.json.JSONArray;
import cn.lazytool.json.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class JSONTools {
    private JSONTools() {
    }

    public static String toJsonStr(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof CharSequence) {
            return StringTools.str((CharSequence)((CharSequence)obj));
        }
        return JSONTools.toJsonStr(JSONTools.parse(obj));
    }

    public static String toJsonStr(JSON json) {
        StringBuilder sb = new StringBuilder();
        if (json instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)json;
            sb.append("{");
            Set keySet = jsonObject.keySet();
            int len = keySet.size();
            CollectionTools.forEach(keySet, (item, index) -> {
                String key = StringTools.format((CharSequence)"\"{}\"", (Object[])new Object[]{item});
                Object o = jsonObject.get(item);
                sb.append(key).append(":");
                if (JSONTools.isJsonBaseType(o)) {
                    sb.append(JSONTools.baseTypeToJsonStr(o));
                } else {
                    sb.append(JSONTools.toJsonStr(o));
                }
                if (index < len - 1) {
                    sb.append(',');
                }
            });
            sb.append("}");
        } else if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            sb.append("[");
            int len = jsonArray.size();
            CollectionTools.forEach((Iterable)jsonArray, (item, index) -> {
                if (JSONTools.isJsonBaseType(item)) {
                    sb.append(JSONTools.baseTypeToJsonStr(item));
                } else {
                    sb.append(JSONTools.toJsonStr(item));
                }
                if (index < len - 1) {
                    sb.append(',');
                }
            });
            sb.append("]");
        }
        return sb.toString();
    }

    private static String baseTypeToJsonStr(Object obj) {
        if (JSONTools.isJsonBaseType(obj)) {
            if (obj == null) {
                return "null";
            }
            if (obj instanceof CharSequence) {
                return StringTools.format((CharSequence)"\"{}\"", (Object[])new Object[]{obj.toString()});
            }
            if (obj instanceof Number) {
                if (obj instanceof Double || obj instanceof Float || obj instanceof BigDecimal) {
                    return String.valueOf(((Number)obj).doubleValue());
                }
                return String.valueOf(((Number)obj).longValue());
            }
            if (obj instanceof Boolean) {
                return obj.toString();
            }
            if (obj instanceof Date) {
                return String.valueOf(((Date)obj).getTime());
            }
        }
        throw new ClassCastException("\u5bf9\u8c61\u4e0d\u662f\u57fa\u672c\u7c7b\u578b");
    }

    public static JSON parse(Object obj) {
        if (JSONTools.isJsonBaseType(obj)) {
            throw new ClassCastException("\u6b64\u7c7b\u578b\u4e0d\u53ef\u88ab\u8f6c\u6362");
        }
        if (obj instanceof JSON) {
            return (JSON)obj;
        }
        if (JSONTools.isJsonArray(obj)) {
            return JSONTools.parseArray(obj);
        }
        return JSONTools.parseObject(obj);
    }

    public static JSONArray parseArray(Object obj) {
        return new JSONArray(obj);
    }

    public static JSONObject parseObject(Object obj) {
        return new JSONObject(obj);
    }

    private static boolean isJsonArray(Object obj) {
        return ArrayTools.isArray((Object)obj) || CollectionTools.isIterable((Object)obj);
    }

    protected static boolean isJsonBaseType(Object obj) {
        return obj == null || obj instanceof CharSequence || obj instanceof Number || obj instanceof Date || obj instanceof Boolean;
    }
}

