/*
 * Decompiled with CFR 0.152.
 */
package cn.lazytool.json;

import cn.lazytool.core.collection.CollectionTools;
import cn.lazytool.core.map.MapTools;
import cn.lazytool.core.util.ReflectTools;
import cn.lazytool.json.JSON;
import cn.lazytool.json.JSONTools;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONObject
extends HashMap<String, Object>
implements JSON {
    private Object obj;
    private Type type;

    public JSONObject(Object obj) {
        this.init(obj);
    }

    private void init(Object obj) {
        this.obj = obj;
        Type type = this.type = MapTools.isMap((Object)obj) ? Type.MAP : Type.OBJECT;
        if (this.type == Type.OBJECT) {
            this.convertObject();
        } else {
            this.convertMap();
        }
    }

    private void convertMap() {
        Map map = (Map)this.obj;
        map.forEach((k, v) -> {
            if (!(k instanceof CharSequence)) {
                throw new ClassCastException("key\u53ea\u53ef\u4e3a\u5b57\u7b26\u4e32");
            }
            this.put(k.toString(), v);
        });
    }

    @Override
    public Object put(String key, Object value) {
        if (JSONTools.isJsonBaseType(value)) {
            super.put(key, value);
        } else {
            JSON json = JSONTools.parse(value);
            super.put(key, json);
        }
        return value;
    }

    public JSON getJson(String key) {
        Object o = super.get(key);
        return JSONTools.parse(o);
    }

    private void convertObject() {
        Class<?> aClass = this.obj.getClass();
        List fieldWithMethod = ReflectTools.getFieldWithMethod(aClass);
        CollectionTools.forEach((Iterable)fieldWithMethod, (item, index) -> {
            Field field = item.getField();
            Method get = item.getGetMethod();
            if (get != null) {
                try {
                    Object getObj = get.invoke(this.obj, new Object[0]);
                    this.put(field.getName(), getObj);
                }
                catch (Exception e) {
                    throw new ClassCastException("\u83b7\u53d6\u503c\u5931\u8d25");
                }
            }
        });
    }

    @Override
    public String toString() {
        return JSONTools.toJsonStr(this);
    }

    private static enum Type {
        OBJECT,
        MAP;

    }
}

