package cn.lazytool.json;

import cn.lazytool.core.collection.CollectionTools;
import cn.lazytool.core.map.MapTools;
import cn.lazytool.core.util.ReflectTools;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * JOSN 关于Object类型
 * @author fenqing
 * @version 0.0.1
 */
public class JSONObject extends HashMap<String, Object> implements JSON {

    /**
     * 对象
     */
    private Object obj;

    /**
     * 对象的类型
     */
    private Type type;

    public JSONObject(Object obj) {
        init(obj);
    }

    private void init(Object obj){
        this.obj = obj;
        this.type = MapTools.isMap(obj) ? Type.MAP : Type.OBJECT;
        if(this.type == Type.OBJECT){
            this.convertObject();
        } else {
            this.convertMap();
        }
    }

    /**
     * 转换map
     * @author fenqing
     */
    @SuppressWarnings("all")
    private void convertMap(){
        Map<Object, Object> map = (Map<Object, Object>) this.obj;
        map.forEach((k, v) -> {
           if(!(k instanceof CharSequence)){
               throw new ClassCastException("key只可为字符串");
           }
           put(k.toString(), v);
        });
    }

    @Override
    public Object put(String key, Object value) {
        if(JSONTools.isJsonBaseType(value)){
            super.put(key, value);
        } else {
            final JSON json = JSONTools.parse(value);
            super.put(key, json);
        }
        return value;
    }

    /**
     * 获取值，并转换成JSON对象
     * @author fenqing
     * @param key key
     * @return cn.lazytool.json.JSON
     */
    public JSON getJson(String key) {
        final Object o = super.get(key);
        return JSONTools.parse(o);
    }

    /**
     * 转换对象
     * @author fenqing
     */
    private void convertObject(){
        final Class<?> aClass = this.obj.getClass();
        final List<ReflectTools.FieldWithMethod> fieldWithMethod = ReflectTools.getFieldWithMethod(aClass);
        CollectionTools.forEach(fieldWithMethod, (item, index) -> {
            final Field field = item.getField();
            Method get = item.getGetMethod();
            if(get != null){
                try {
                    final Object getObj = get.invoke(this.obj);
                    put(field.getName(), getObj);
                } catch (Exception e) {
                    throw new ClassCastException("获取值失败");
                }
            }
        });
    }


    /**
     * 对象类型
     */
    private enum Type {
        /**
         * 对象
         * map
         */
        OBJECT, MAP;
    }

    @Override
    public String toString() {
        return JSONTools.toJsonStr(this);
    }

}
