package cn.lazytool.json;

import cn.lazytool.core.collection.ArrayIter;
import cn.lazytool.core.collection.CollectionTools;
import cn.lazytool.core.util.ArrayTools;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * json 数组类型
 *
 * @author fenqing
 * @version 0.0.1
 */
public class JSONArray extends ArrayList<Object> implements JSON {

    Iterator<?> iterator;

    public JSONArray(Object obj) {
        init(obj);
    }

    /**
     * 初始化
     * @param obj 对象
     */
    private void init(Object obj){
        if(ArrayTools.isArray(obj)){
            iterator = new ArrayIter<>(obj);
        } else if (CollectionTools.isIterable(obj)) {
            iterator = ((Iterable<?>)obj).iterator();
        } else {
            throw new ClassCastException("对象不是可迭代类型");
        }
        startIterator();
    }

    /**
     * 开始迭代
     */
    private void startIterator() {
        while(iterator.hasNext()) {
            final Object next = iterator.next();
            this.add(next);
        }
    }

    @Override
    public boolean add(Object o) {
        if (JSONTools.isJsonBaseType(o)) {
            super.add(o);
        } else {
            final JSON json = JSONTools.parse(o);
            return super.add(json);
        }
        return true;
    }

    @Override
    public String toString() {
        return JSONTools.toJsonStr(this);
    }
}
