/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.entity.data.EntityData;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.utils.BinaryStream;
import lib.net.easecation.ghosty.entity.PlaybackNPC;
import lib.net.easecation.ghosty.recording.RecordNode;
import lib.net.easecation.ghosty.recording.Updated;

class UpdatedDataFlags
implements Updated {
    private long flags;

    static UpdatedDataFlags of(long flags) {
        return new UpdatedDataFlags(flags);
    }

    @Override
    public int getUpdateTypeId() {
        return 4;
    }

    @Override
    public void processTo(PlaybackNPC ghost) {
        ghost.setDataProperty((EntityData)new LongEntityData(0, this.flags));
    }

    @Override
    public RecordNode applyTo(RecordNode node) {
        node.setDataFlags(this.flags);
        return node;
    }

    public UpdatedDataFlags(BinaryStream stream) {
        this.read(stream);
    }

    private UpdatedDataFlags(long flags) {
        this.flags = flags;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdatedDataFlags)) {
            return false;
        }
        UpdatedDataFlags o = (UpdatedDataFlags)obj;
        return this.flags == o.flags;
    }

    @Override
    public void write(BinaryStream stream) {
        stream.putVarLong(this.flags);
    }

    @Override
    public void read(BinaryStream stream) {
        this.flags = stream.getVarLong();
    }
}

