/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.item.Item;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BinaryStream;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import lib.net.easecation.ghosty.MathUtil;
import lib.net.easecation.ghosty.recording.PlayerRecord;
import lib.net.easecation.ghosty.recording.RecordIterator;
import lib.net.easecation.ghosty.recording.RecordNode;
import lib.net.easecation.ghosty.recording.Updated;
import lib.net.easecation.ghosty.recording.UpdatedDataFlags;
import lib.net.easecation.ghosty.recording.UpdatedItem;
import lib.net.easecation.ghosty.recording.UpdatedPositionXYZ;
import lib.net.easecation.ghosty.recording.UpdatedRotation;
import lib.net.easecation.ghosty.recording.UpdatedTagName;
import lib.net.easecation.ghosty.recording.UpdatedWorld;

public class SkinlessPlayerRecord
implements PlayerRecord {
    private RecordNode last = RecordNode.ZERO;
    private final List<RecordPair> rec = new LinkedList<RecordPair>();
    private final String playerName;
    private Skin tempSkin = null;

    public SkinlessPlayerRecord(BinaryStream stream) {
        this.playerName = stream.getString();
        int len = (int)stream.getUnsignedVarInt();
        for (int i = 0; i < len; ++i) {
            RecordPair pair = new RecordPair(stream);
            this.rec.add(pair);
        }
    }

    public SkinlessPlayerRecord(Player player) {
        this.playerName = player.getName();
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public void record(long tick, RecordNode node) {
        long flags;
        long lastFlags;
        Item i;
        Item li;
        String w;
        String lw;
        String n;
        String ln;
        double lx = this.last.getX();
        double x = node.getX();
        double ly = this.last.getY();
        double y = node.getY();
        double lz = this.last.getZ();
        double z = node.getZ();
        if (lx != x || ly != y || lz != z) {
            this.push(tick, UpdatedPositionXYZ.of(x, y, z));
        }
        double la = this.last.getYaw();
        double a = node.getYaw();
        double lp = this.last.getPitch();
        double p = node.getPitch();
        if (la != a || lp != p) {
            this.push(tick, UpdatedRotation.of(a, p));
        }
        if (!Objects.equals(ln = this.last.getTagName(), n = node.getTagName())) {
            this.push(tick, UpdatedTagName.of(n));
        }
        if (!Objects.equals(lw = this.last.getLevel(), w = node.getLevel())) {
            this.push(tick, UpdatedWorld.of(w));
        }
        if (!Objects.equals(li = this.last.getItem(), i = node.getItem())) {
            this.push(tick, UpdatedItem.of(i));
        }
        if ((lastFlags = this.last.getDataFlags()) != (flags = node.getDataFlags())) {
            this.push(tick, UpdatedDataFlags.of(flags));
        }
        this.last = node;
    }

    private void push(long tick, Updated updated) {
        this.rec.add(new RecordPair(tick, updated));
    }

    @Override
    public RecordIterator iterator() {
        LmlRecordIterator recordIterator = new LmlRecordIterator();
        this.rec.forEach(e -> recordIterator.queue.offer((RecordPair)e));
        return recordIterator;
    }

    public void setSkin(Skin skin) {
        this.tempSkin = skin;
    }

    @Override
    public Skin getSkin() {
        return this.tempSkin;
    }

    @Override
    public byte[] toBinary() {
        BinaryStream stream = new BinaryStream();
        stream.putByte((byte)1);
        stream.putString(this.playerName);
        stream.putUnsignedVarInt((long)this.rec.size());
        for (RecordPair pair : this.rec) {
            pair.write(stream);
        }
        return stream.getBuffer();
    }

    public double getMaxMovement() {
        Vector3 lastPos = null;
        double maxMovement = 0.0;
        for (RecordPair pair : this.rec.stream().filter(p -> p.updated instanceof UpdatedPositionXYZ).collect(Collectors.toList())) {
            double distance;
            UpdatedPositionXYZ pos = (UpdatedPositionXYZ)pair.updated;
            Vector3 newPos = pos.asVector3();
            if (lastPos != null && (distance = newPos.distance(lastPos)) > maxMovement) {
                maxMovement = distance;
            }
            lastPos = newPos;
        }
        return maxMovement;
    }

    public double calculateMovementVariance() {
        Vector3 lastPos = null;
        List pairs = this.rec.stream().filter(p -> p.updated instanceof UpdatedPositionXYZ).collect(Collectors.toList());
        if (pairs.size() <= 1) {
            return 0.0;
        }
        double[] distances = new double[pairs.size() - 1];
        for (int i = 0; i < pairs.size(); ++i) {
            RecordPair pair = (RecordPair)pairs.get(i);
            UpdatedPositionXYZ pos = (UpdatedPositionXYZ)pair.updated;
            Vector3 newPos = pos.asVector3();
            if (lastPos != null) {
                distances[i - 1] = newPos.distance(lastPos);
            }
            lastPos = newPos;
        }
        return MathUtil.getVariance(distances);
    }

    private static class LmlRecordIterator
    implements RecordIterator {
        static Comparator<RecordPair> comparator = (recordPairA, recordPairB) -> {
            if (recordPairA.tick < recordPairB.tick) {
                return -1;
            }
            if (recordPairA.tick == recordPairB.tick) {
                return 0;
            }
            return 1;
        };
        PriorityQueue<RecordPair> queue = new PriorityQueue<RecordPair>(comparator);

        private LmlRecordIterator() {
        }

        @Override
        public RecordNode initialValue(long tick) {
            RecordNode n = RecordNode.ZERO;
            if (this.queue.peek() == null) {
                return n;
            }
            while (!this.queue.isEmpty() && this.queue.peek().tick < tick) {
                this.queue.poll();
            }
            if (this.queue.peek() == null) {
                return n;
            }
            while (!this.queue.isEmpty() && this.queue.peek().tick == tick) {
                Updated updated = this.queue.poll().updated;
                n = updated.applyTo(n);
            }
            return n;
        }

        @Override
        public List<Updated> peek() {
            LinkedList<Updated> ans = new LinkedList<Updated>();
            if (this.queue.isEmpty()) {
                return ans;
            }
            long tick = this.queue.peek().tick;
            while (!this.queue.isEmpty() && this.queue.peek().tick == tick) {
                Updated u = this.queue.poll().updated;
                ans.add(u);
            }
            return ans;
        }

        @Override
        public long peekTick() {
            if (this.queue.isEmpty()) {
                return -1L;
            }
            return this.queue.peek().tick;
        }

        @Override
        public long pollTick() {
            if (this.queue.isEmpty()) {
                return -1L;
            }
            long tick = this.queue.peek().tick;
            while (!this.queue.isEmpty() && this.queue.peek().tick == tick) {
                this.queue.poll();
            }
            return tick;
        }
    }

    private class RecordPair {
        long tick;
        Updated updated;

        private RecordPair(BinaryStream stream) {
            try {
                this.tick = stream.getUnsignedVarInt();
                this.updated = Updated.fromBinaryStream(stream);
            }
            catch (Exception e) {
                Server.getInstance().getLogger().logException((Throwable)e);
                throw e;
            }
        }

        private RecordPair(long tick, Updated updated) {
            this.tick = tick;
            this.updated = updated;
        }

        private void write(BinaryStream stream) {
            stream.putUnsignedVarInt((long)((int)this.tick));
            stream.putByte((byte)this.updated.getUpdateTypeId());
            this.updated.write(stream);
        }
    }
}

