/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.nukkit.Server;

public class NukkitTypeUtils {
    private static final NukkitType nukkitType;

    public static NukkitType getNukkitType() {
        return nukkitType;
    }

    static {
        String codename = Server.getInstance().getCodename();
        nukkitType = "PowerNukkitX".equalsIgnoreCase(codename) ? NukkitType.POWER_NUKKIT_X : ("PowerNukkit".equalsIgnoreCase(codename) ? NukkitType.POWER_NUKKIT : ("PM1E".equalsIgnoreCase(codename) ? NukkitType.PM1E : NukkitType.NUKKITX));
    }

    public static enum NukkitType {
        NUKKITX("NukkitX"),
        POWER_NUKKIT("PowerNukkit"),
        POWER_NUKKIT_X("PowerNukkitX"),
        PM1E("Nukkit PetteriM1 Edition");

        private final String showName;

        private NukkitType(String showName) {
            this.showName = showName;
        }

        public String getShowName() {
            return this.showName;
        }
    }
}

