/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.lanink.gamecore.GameCore;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ItemInfoUtils {
    private static final ItemInfo UNKNOWN = new ItemInfo(-1, 0, "unknown", "\u672a\u77e5", "unknown");
    private static final ArrayList<ItemInfo> ITEM_INFOS = new ArrayList();

    private ItemInfoUtils() {
        throw new RuntimeException("error");
    }

    public static boolean registerCustomItemsFromMaps(@NonNull List<Map<String, Object>> maps) {
        if (maps == null) {
            throw new NullPointerException("maps is marked non-null but is null");
        }
        for (Map<String, Object> map : maps) {
            if (ItemInfoUtils.registerCustomItemFromMap(map)) continue;
            return false;
        }
        return true;
    }

    public static void registerCustomItem(int id, int damage, String imagePath, String nameChinese, String nameEnglish) {
        ITEM_INFOS.add(new ItemInfo(id, damage, imagePath, nameChinese, nameEnglish));
    }

    public static boolean registerCustomItemFromMap(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        try {
            ItemInfo itemInfo = ItemInfo.fromMap(map);
            ITEM_INFOS.add(itemInfo);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static ItemInfo getItemInfoById(int id) {
        return ItemInfoUtils.getItemInfoById(id, 0);
    }

    public static ItemInfo getItemInfoById(int id, int damage) {
        for (ItemInfo itemInfo : ITEM_INFOS) {
            if (itemInfo.getId() != id || itemInfo.getDamage() != damage) continue;
            return itemInfo;
        }
        return UNKNOWN;
    }

    public static String getNameChineseById(int id) {
        return ItemInfoUtils.getNameChineseById(id, 0);
    }

    public static String getNameChineseById(int id, int damage) {
        return ItemInfoUtils.getItemInfoById(id, damage).getNameChinese();
    }

    public static String getNameEnglishById(int id) {
        return ItemInfoUtils.getNameEnglishById(id, 0);
    }

    public static String getNameEnglishById(int id, int damage) {
        return ItemInfoUtils.getItemInfoById(id, damage).getNameEnglish();
    }

    public static String getImgPathById(int id, int damage) {
        return ItemInfoUtils.getItemInfoById(id, damage).getImagePath();
    }

    public static List<Integer> getAllMetaDamagesFromAnId(int id) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (ItemInfo itemInfo : ITEM_INFOS) {
            if (itemInfo.id != id) continue;
            ret.add(itemInfo.damage);
        }
        return ret;
    }

    static {
        InputStream stream = GameCore.class.getClassLoader().getResourceAsStream("Resources/ItemInfoData.json");
        if (stream == null) {
            throw new AssertionError((Object)"Unable to load Resources/ItemInfoData.json");
        }
        JsonArray json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonArray();
        for (JsonElement element : json) {
            if (!element.isJsonObject()) {
                throw new IllegalStateException("Invalid entry");
            }
            JsonObject entry = element.getAsJsonObject();
            ITEM_INFOS.add(new ItemInfo(entry.get("id").getAsInt(), entry.get("damage").getAsInt(), entry.get("imagePath").getAsString(), entry.get("nameChinese").getAsString(), entry.get("nameEnglish").getAsString()));
        }
    }

    public static class ItemInfo {
        private final int id;
        private final int damage;
        private final String imagePath;
        private final String nameChinese;
        private final String nameEnglish;
        private static final ImmutableList<String> availableKeys = new ImmutableList.Builder().add((Object)"id").add((Object)"damage").add((Object)"imagePath").add((Object)"nameChinese").add((Object)"nameEnglish").build();

        public static ItemInfo fromMap(@NonNull Map<String, Object> map) {
            if (map == null) {
                throw new NullPointerException("map is marked non-null but is null");
            }
            if (map.size() != availableKeys.size()) {
                throw new RuntimeException("unexpected arguments in formMap(), expect 5 elements in map");
            }
            map.keySet().forEach(key -> {
                if (!availableKeys.contains(key)) {
                    throw new RuntimeException("unexpected arguments in formMap(), expect " + availableKeys + " in map");
                }
            });
            return new ItemInfo((Integer)map.get("id"), (Integer)map.get("damage"), (String)map.get("imagePath"), (String)map.get("nameChinese"), (String)map.get("nameEnglish"));
        }

        public LinkedHashMap<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", this.id);
            map.put("damage", this.damage);
            map.put("imagePath", this.imagePath);
            map.put("nameChinese", this.nameChinese);
            map.put("nameEnglish", this.nameEnglish);
            return map;
        }

        public ItemInfo(int id, int damage, String imagePath, String nameChinese, String nameEnglish) {
            this.id = id;
            this.damage = damage;
            this.imagePath = imagePath;
            this.nameChinese = nameChinese;
            this.nameEnglish = nameEnglish;
        }

        public int getId() {
            return this.id;
        }

        public int getDamage() {
            return this.damage;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public String getNameChinese() {
            return this.nameChinese;
        }

        public String getNameEnglish() {
            return this.nameEnglish;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemInfo)) {
                return false;
            }
            ItemInfo other = (ItemInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.getDamage() != other.getDamage()) {
                return false;
            }
            String this$imagePath = this.getImagePath();
            String other$imagePath = other.getImagePath();
            if (this$imagePath == null ? other$imagePath != null : !this$imagePath.equals(other$imagePath)) {
                return false;
            }
            String this$nameChinese = this.getNameChinese();
            String other$nameChinese = other.getNameChinese();
            if (this$nameChinese == null ? other$nameChinese != null : !this$nameChinese.equals(other$nameChinese)) {
                return false;
            }
            String this$nameEnglish = this.getNameEnglish();
            String other$nameEnglish = other.getNameEnglish();
            return !(this$nameEnglish == null ? other$nameEnglish != null : !this$nameEnglish.equals(other$nameEnglish));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ItemInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            result = result * 59 + this.getDamage();
            String $imagePath = this.getImagePath();
            result = result * 59 + ($imagePath == null ? 43 : $imagePath.hashCode());
            String $nameChinese = this.getNameChinese();
            result = result * 59 + ($nameChinese == null ? 43 : $nameChinese.hashCode());
            String $nameEnglish = this.getNameEnglish();
            result = result * 59 + ($nameEnglish == null ? 43 : $nameEnglish.hashCode());
            return result;
        }

        public String toString() {
            return "ItemInfoUtils.ItemInfo(id=" + this.getId() + ", damage=" + this.getDamage() + ", imagePath=" + this.getImagePath() + ", nameChinese=" + this.getNameChinese() + ", nameEnglish=" + this.getNameEnglish() + ")";
        }
    }
}

