/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.api.Info;
import cn.nukkit.Nukkit;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.AvailableEntityIdentifiersPacket;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Info(value="\u6ce8\u518c\u81ea\u5b9a\u4e49\u5b9e\u4f53\u6807\u8bc6\u7b26  \u6ce8\u610f\uff1a\u6b64\u5de5\u5177\u7c7b\u4ec5\u5728NK\u6709\u6548\uff0cPNX PM1E\u5747\u6709\u81ea\u5df1\u7684API\u7528\u4e8e\u5b9e\u73b0\u81ea\u5b9a\u4e49\u5b9e\u4f53\uff01")
public class CustomEntityUtils {
    private static final ConcurrentHashMap<String, Integer> IDENTIFIER_MAP = new ConcurrentHashMap();
    private static final AtomicInteger RUNTIME_ID = new AtomicInteger(10000);

    private CustomEntityUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasCustomEntity(String name) {
        return IDENTIFIER_MAP.containsKey(name);
    }

    public static int getRuntimeId(String identifier) {
        if (identifier == null) {
            return -1;
        }
        return IDENTIFIER_MAP.getOrDefault(identifier, -1);
    }

    public static void registerCustomEntity(String identifier) {
        IDENTIFIER_MAP.put(identifier, RUNTIME_ID.getAndIncrement());
        try {
            InputStream inputStream = Nukkit.class.getClassLoader().getResourceAsStream("entity_identifiers.dat");
            if (inputStream == null) {
                throw new AssertionError((Object)"Could not find entity_identifiers.dat");
            }
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            CompoundTag nbt = NBTIO.read((InputStream)bis, (ByteOrder)ByteOrder.BIG_ENDIAN, (boolean)true);
            ListTag list = nbt.getList("idlist", CompoundTag.class);
            for (Map.Entry<String, Integer> entry : IDENTIFIER_MAP.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.putBoolean("hasspawnegg", false);
                tag.putString("id", entry.getKey());
                tag.putBoolean("summonable", false);
                tag.putString("bid", "");
                tag.putInt("rid", entry.getValue().intValue());
                tag.putBoolean("experimental", false);
                list.add((Tag)tag);
            }
            nbt.putList(list);
            Class<AvailableEntityIdentifiersPacket> aClass = AvailableEntityIdentifiersPacket.class;
            Field tagField = aClass.getDeclaredField("TAG");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(tagField, tagField.getModifiers() & 0xFFFFFFEF);
            tagField.setAccessible(true);
            tagField.set(null, NBTIO.write((CompoundTag)nbt, (ByteOrder)ByteOrder.BIG_ENDIAN, (boolean)true));
        }
        catch (Exception e) {
            IDENTIFIER_MAP.remove(identifier);
            GameCore.getInstance().getLogger().error("\u6ce8\u518c\u81ea\u5b9a\u4e49\u5b9e\u4f53\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

