/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.scoreboard.ltname.packet;

import cn.lanink.gamecore.scoreboard.ltname.packet.data.ScoreData;
import cn.nukkit.network.protocol.DataPacket;
import java.util.List;

public class SetScorePacket
extends DataPacket {
    public static final byte NETWORK_ID = 108;
    public byte type;
    public List<ScoreData> scoreDataList;

    public byte pid() {
        return 108;
    }

    public void decode() {
    }

    public void encode() {
        this.reset();
        this.putByte(this.type);
        this.putUnsignedVarInt(this.scoreDataList.size());
        for (ScoreData scoreData : this.scoreDataList) {
            this.putVarLong(scoreData.scoreId);
            this.putString(scoreData.objective);
            this.putLInt(scoreData.score);
            if (this.type != Action.SET.ordinal()) continue;
            this.putByte(scoreData.entityType);
            switch (scoreData.entityType) {
                case 3: {
                    this.putString(scoreData.fakeEntity);
                    break;
                }
                case 1: 
                case 2: {
                    this.putUnsignedVarLong(scoreData.entityId);
                }
            }
        }
    }

    public static enum Type {
        INVALID,
        PLAYER,
        ENTITY,
        FAKE;

    }

    public static enum Action {
        SET,
        REMOVE;

    }
}

