/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.ranking.task;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.ranking.Ranking;
import cn.lanink.gamecore.ranking.task.IRankingAPITask;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.PluginTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class UpdateTask
extends PluginTask<GameCore>
implements IRankingAPITask {
    private final Set<Ranking> updateRankings = Collections.newSetFromMap(new ConcurrentHashMap());

    public UpdateTask(GameCore owner) {
        super((Plugin)owner);
    }

    @Override
    public Set<Ranking> getRankings() {
        return this.updateRankings;
    }

    @Override
    public boolean addRanking(@NotNull Ranking ranking) {
        return this.updateRankings.add(ranking);
    }

    @Override
    public void removeRanking(@NotNull Ranking ranking) {
        this.updateRankings.remove(ranking);
    }

    public void onRun(int i) {
        for (Ranking ranking : this.updateRankings) {
            try {
                ranking.onTick(i);
            }
            catch (Exception e) {
                GameCore.getInstance().getLogger().error("Ranking " + ranking.getClass().getName() + " onTick error: ", (Throwable)e);
            }
        }
    }

    public void onCancel() {
        for (Ranking ranking : new HashSet<Ranking>(this.updateRankings)) {
            ranking.close();
        }
    }
}

