/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.pathfinder.utils;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;

public class BlockUtil {
    public static final int[][] MOTION = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {-1, -1, 0}, {1, -1, 0}, {-1, 1, 0}, {1, 1, 0}, {0, 0, 1}, {-1, 0, 1}, {1, 0, 1}, {0, -1, 1}, {0, 1, 1}, {-1, -1, 1}, {1, -1, 1}, {-1, 1, 1}, {1, 1, 1}, {0, 0, -1}, {-1, 0, -1}, {1, 0, -1}, {0, -1, -1}, {0, 1, -1}, {-1, -1, -1}, {1, -1, -1}, {-1, 1, -1}, {1, 1, -1}};

    public static double MHDistance(Vector3 start, Vector3 target) {
        return Math.abs(start.x - target.x) + Math.abs(start.y - target.y) + Math.abs(start.z - target.z);
    }

    public static boolean isPermeable(Block block) {
        return block.canPassThrough();
    }

    public static boolean canStand(Block block) {
        return !BlockUtil.isPermeable(block) || block.canBeClimbed();
    }

    public static boolean checkUpAccessed(Block block) {
        return BlockUtil.canStand(BlockUtil.getNearBlock(block, BlockFace.DOWN)) || block.canBeClimbed();
    }

    public static Block getNearBlock(Block block, BlockFace face) {
        switch (face) {
            case UP: {
                return block.getLevel().getBlock((Vector3)block.add(0.0, 1.0, 1.0));
            }
            case DOWN: {
                return block.getLevel().getBlock((Vector3)block.add(0.0, -1.0, 0.0));
            }
            case EAST: {
                return block.getLevel().getBlock((Vector3)block.add(1.0, 0.0, 0.0));
            }
            case WEST: {
                return block.getLevel().getBlock((Vector3)block.add(-1.0, 0.0, 0.0));
            }
            case NORTH: {
                return block.getLevel().getBlock((Vector3)block.add(0.0, 0.0, -1.0));
            }
            case SOUTH: {
                return block.getLevel().getBlock((Vector3)block.add(0.0, 0.0, 1.0));
            }
        }
        return new BlockAir();
    }
}

