/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.modelmanager;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.modelmanager.IManager;
import cn.lanink.gamecore.modelmanager.IModelManager;
import cn.lanink.gamecore.modelmanager.newmodelpojo.Manager;
import cn.nukkit.entity.data.Skin;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.imageio.ImageIO;

public class ModelManager
implements IModelManager {
    private static final ConcurrentMap<String, Skin> MODEL_LIST = new ConcurrentHashMap<String, Skin>();
    private final Gson GSON = new Gson();

    @Override
    public Skin getModel(String key) {
        return (Skin)MODEL_LIST.get(key);
    }

    @Override
    public Skin getModel(Path dir, String ... children) {
        children = children == null ? new String[]{} : children;
        File parent = Paths.get(dir.toString(), children).toFile();
        return this.getModel(parent, new String[0]);
    }

    @Override
    public Skin getModel(File dir, String ... children) {
        children = children == null ? new String[]{} : children;
        File parent = Paths.get(dir.toString(), children).toFile();
        File[] data = new File[2];
        if (parent.listFiles().length > 3) {
            return null;
        }
        Stream.of(parent.listFiles()).filter(file -> file.getName().endsWith(".json") || file.getName().endsWith(".png") || file.getName().endsWith(".jpg")).forEach(file -> {
            if (file.getName().endsWith(".json")) {
                data[0] = file;
            } else if (file.getName().endsWith(".png") || file.getName().endsWith(".jpg")) {
                data[1] = file;
            }
        });
        if (data[0] == null || data[1] == null) {
            return null;
        }
        return this.getModel(data[0], data[1]);
    }

    @Override
    public Skin getModel(File json, File image) {
        try {
            BufferedImage bufferedImage = ImageIO.read(image);
            Skin skin = new Skin();
            skin.setTrusted(true);
            String jsonStr = new String(Files.readAllBytes(json.toPath()));
            skin.setGeometryData(jsonStr);
            skin.setSkinId(UUID.randomUUID().toString());
            skin.setSkinData(bufferedImage);
            skin.setGeometryName(this.getManager(json).getMainIdentifier());
            return skin;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Skin getAndRegisterModel(String key, File json, File image) {
        Skin skin = this.getModel(json, image);
        if (this.register(key, skin)) {
            return skin;
        }
        return null;
    }

    @Override
    public Skin getAndRegisterModel(String key, File dir) {
        Skin skin = this.getModel(dir, new String[0]);
        if (this.register(key, skin)) {
            return skin;
        }
        return null;
    }

    @Override
    public boolean register(String key, Skin skin) {
        if (MODEL_LIST.containsKey(key)) {
            return false;
        }
        MODEL_LIST.put(key, skin);
        return true;
    }

    @Override
    public boolean register(String key, File dir) {
        Skin skin = this.getModel(dir, new String[0]);
        return this.register(key, skin);
    }

    @Override
    public ConcurrentMap<String, Skin> getModels() {
        return MODEL_LIST;
    }

    @Override
    public IManager getManager(Path path) {
        return this.getManager(path.toFile());
    }

    @Override
    public IManager getManager(File file) {
        try {
            return this.getManagerFromJsonStr(new String(Files.readAllBytes(file.toPath())));
        }
        catch (IOException e) {
            e.printStackTrace();
            GameCore.getInstance().getLogger().warning("IO\u9519\u8bef\u5bfc\u81f4\u6a21\u578b\u7ba1\u7406\u5668\u83b7\u53d6\u5931\u8d25");
            return null;
        }
    }

    @Override
    public IManager getManagerFromJsonStr(String json) {
        if (json.contains("1.12.0")) {
            return (IManager)this.GSON.fromJson(json, Manager.class);
        }
        json = "{\"modelsMap\": " + json + "}";
        return (IManager)this.GSON.fromJson(json, cn.lanink.gamecore.modelmanager.oldmodelpojo.Manager.class);
    }

    @Override
    public String generateJsonStr(IModelManager modelManager) {
        if (modelManager instanceof Manager) {
            return this.GSON.toJson((Object)modelManager);
        }
        String json = this.GSON.toJson((Object)modelManager);
        json = json.substring(13);
        json = json.substring(0, json.length() - 1);
        return json;
    }
}

