/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.hotswap.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ModulesFileLoader {
    private final File moduleFile;
    private String contents;
    private String repo;
    private final Map<String, String> dependencies = new HashMap<String, String>();
    private final Map<String, String> httpUrls = new HashMap<String, String>();

    public ModulesFileLoader(File moduleFile) {
        this.moduleFile = moduleFile;
        try {
            this.loadContents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadContents() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.moduleFile));
        StringBuilder sb = new StringBuilder();
        reader.lines().filter(str -> !str.startsWith("#") && !"".equals(str)).filter(str -> str.matches("repo(.+)") || str.matches("implementation(.+)") || str.matches("http_url(.+)")).forEach(str -> {
            sb.append((String)str).append(",");
            String value = str.substring(str.indexOf("(") + 1, str.indexOf(")"));
            if (str.startsWith("repo")) {
                this.repo = value;
            } else if (str.startsWith("implementation")) {
                String[] s = value.split(":");
                this.dependencies.put(s[1] + "-" + s[2], value);
                this.httpUrls.put(s[1] + "-" + s[2], this.repo + "/" + s[0].replace(".", "/") + "/" + s[1] + "/" + s[2] + "/" + s[1] + "-" + s[2] + ".jar");
            } else if (str.startsWith("http_url")) {
                String[] s = value.split(":");
                this.httpUrls.put(s[0], s[1] + ":" + s[2]);
            }
        });
        this.contents = sb.toString();
        reader.close();
    }

    public File getModuleFile() {
        return this.moduleFile;
    }

    public String getContents() {
        return this.contents;
    }

    public String getRepo() {
        return this.repo;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public Map<String, String> getHttpUrls() {
        return this.httpUrls;
    }

    public String toString() {
        return "ModulesFileLoader(contents=" + this.getContents() + ", repo=" + this.getRepo() + ", dependencies=" + this.getDependencies() + ", httpUrls=" + this.getHttpUrls() + ")";
    }
}

