/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.form.inventory.advanced;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.form.inventory.responsible.ResponseItem;
import cn.nukkit.Player;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Event;
import cn.nukkit.event.inventory.InventoryClickEvent;
import cn.nukkit.event.inventory.InventoryCloseEvent;
import cn.nukkit.event.inventory.InventoryEvent;
import cn.nukkit.event.inventory.InventoryTransactionEvent;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.item.Item;
import com.google.common.collect.BiMap;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class AdvancedInventory
extends ContainerInventory {
    protected static final GameCore GAME_CORE = GameCore.getInstance();
    protected ConcurrentMap<Integer, ResponseItem> containedResponseItem = new ConcurrentHashMap<Integer, ResponseItem>();
    private Consumer<Player> closeInventoryListener;
    protected final BiConsumer<InventoryClickEvent, Player> superClickItemListener = (clickEvent, player) -> {
        int slotPos = clickEvent.getSlot();
        if (this.containedResponseItem.containsKey(slotPos)) {
            ((ResponseItem)this.containedResponseItem.get(slotPos)).callClick((InventoryClickEvent)clickEvent, (Player)player);
        }
    };

    public AdvancedInventory(@NotNull InventoryHolder holder, @NotNull InventoryType type) {
        super(holder, type);
    }

    protected AdvancedInventory(InventoryHolder holder, InventoryType type, Map<Integer, Item> items, Integer overrideSize, String overrideTitle) {
        super(holder, type, items, overrideSize, overrideTitle);
    }

    public AdvancedInventory putItem(int slot, @NotNull ResponseItem item) {
        return this.putItem(slot, item, false);
    }

    public AdvancedInventory putItem(int slot, @NotNull ResponseItem item, boolean force) {
        this.setItem(slot, item.getItem());
        if (force) {
            this.containedResponseItem.put(slot, item);
        } else {
            this.containedResponseItem.putIfAbsent(slot, item);
        }
        return this;
    }

    public AdvancedInventory onClose(@NotNull Consumer<Player> listener) {
        this.closeInventoryListener = listener;
        return this;
    }

    public void callClose(@NotNull Player player) {
        if (this.closeInventoryListener == null) {
            return;
        }
        this.closeInventoryListener.accept(player);
    }

    public static void onEvent(Event event) {
        block5: {
            block3: {
                Inventory inventory;
                block4: {
                    if (!(event instanceof InventoryEvent)) break block3;
                    inventory = ((InventoryEvent)event).getInventory();
                    if (!(inventory instanceof AdvancedInventory)) {
                        return;
                    }
                    if (!(event instanceof InventoryClickEvent)) break block4;
                    ((AdvancedInventory)inventory).superClickItemListener.accept((InventoryClickEvent)event, ((InventoryClickEvent)event).getPlayer());
                    break block5;
                }
                if (!(event instanceof InventoryCloseEvent)) break block5;
                ((AdvancedInventory)inventory).callClose(((InventoryCloseEvent)event).getPlayer());
                break block5;
            }
            if (event instanceof InventoryTransactionEvent) {
                InventoryTransactionEvent transactionEvent = (InventoryTransactionEvent)event;
                for (InventoryAction action : transactionEvent.getTransaction().getActions()) {
                    SlotChangeAction slotChangeAction;
                    if (!(action instanceof SlotChangeAction) || !((slotChangeAction = (SlotChangeAction)action).getInventory() instanceof AdvancedInventory)) continue;
                    event.setCancelled(true);
                    break;
                }
            }
        }
    }

    public boolean open(Player player) {
        int windowId = player.getWindowId((Inventory)this);
        if (windowId == -1) {
            player.addWindow((Inventory)this);
            return true;
        }
        return super.open(player);
    }

    public void close(Player player) {
        super.close(player);
        if (!this.tryRemoveWindow(player)) {
            GAME_CORE.getLogger().warning(player.getName() + " \u672a\u6b63\u5e38\u79fb\u9664\u80cc\u5305\u9875\u9762");
        }
    }

    public boolean tryRemoveWindow(Player player) {
        super.close(player);
        try {
            Field windowField = Player.class.getDeclaredField("windows");
            windowField.setAccessible(true);
            BiMap windows = (BiMap)windowField.get(player);
            if (windows.remove((Object)this) == null) {
                return false;
            }
            windowField.set(player, windows);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException ignore) {
            return false;
        }
    }

    public Entity getOwner() {
        return null;
    }

    public BlockEntity getBlockOwner() {
        return null;
    }
}

