/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils.packet;

import cn.nukkit.network.protocol.DataPacket;

public class NPCDialoguePacket
extends DataPacket {
    public static final byte NETWORK_ID = -87;
    private static final NPCDialogAction[] ACTIONS = NPCDialogAction.values();
    private long runtimeEntityId;
    private NPCDialogAction action = NPCDialogAction.OPEN;
    private String dialogue = "";
    private String sceneName = "";
    private String npcName = "";
    private String actionJson = "";

    public byte pid() {
        return -87;
    }

    public void decode() {
        this.runtimeEntityId = this.getLLong();
        this.action = ACTIONS[this.getVarInt()];
        this.dialogue = this.getString();
        this.sceneName = this.getString();
        this.npcName = this.getString();
        this.actionJson = this.getString();
    }

    public void encode() {
        this.reset();
        this.putLLong(this.runtimeEntityId);
        this.putVarInt(this.action.ordinal());
        this.putString(this.dialogue);
        this.putString(this.sceneName);
        this.putString(this.npcName);
        this.putString(this.actionJson);
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public NPCDialogAction getAction() {
        return this.action;
    }

    public void setAction(NPCDialogAction action) {
        this.action = action;
    }

    public String getDialogue() {
        return this.dialogue;
    }

    public void setDialogue(String dialogue) {
        this.dialogue = dialogue;
    }

    public String getSceneName() {
        return this.sceneName;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    public String getNpcName() {
        return this.npcName;
    }

    public void setNpcName(String npcName) {
        this.npcName = npcName;
    }

    public String getActionJson() {
        return this.actionJson;
    }

    public void setActionJson(String actionJson) {
        this.actionJson = actionJson;
    }

    public static enum NPCDialogAction {
        OPEN,
        CLOSE;

    }
}

