/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.lanink.gamecore.GameCore;
import cn.nukkit.plugin.Plugin;
import java.util.Arrays;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class VersionUtils {
    public static boolean checkMinimumVersion(@NotNull Plugin plugin, @NotNull String leastVersion) {
        return VersionUtils.compareVersion(plugin.getDescription().getVersion(), leastVersion) != -1;
    }

    public static int compareVersion(@NotNull String v1, @NotNull String v2) {
        if (v1.equalsIgnoreCase(v2)) {
            return 0;
        }
        try {
            LinkedList<String> version1Array = new LinkedList<String>(Arrays.asList(v1.split("[._-]")));
            LinkedList<String> version2Array = new LinkedList<String>(Arrays.asList(v2.split("[._-]")));
            LinkedList<String> version1Suffix = new LinkedList<String>();
            LinkedList<String> version2Suffix = new LinkedList<String>();
            for (int v1index = version1Array.size() - 1; v1index != 0; --v1index) {
                try {
                    Long.parseLong(version1Array.getLast());
                    continue;
                }
                catch (Exception e) {
                    version1Suffix.addLast(version1Array.pollLast());
                }
            }
            for (int v2index = version2Array.size() - 1; v2index != 0; --v2index) {
                try {
                    Long.parseLong(version2Array.getLast());
                    continue;
                }
                catch (Exception e) {
                    version2Suffix.addLast(version2Array.pollLast());
                }
            }
            int minLen = Math.min(version1Array.size(), version2Array.size());
            long diff = 0L;
            for (int index = 0; index < minLen && (diff = Long.parseLong(version1Array.get(index)) - Long.parseLong(version2Array.get(index))) == 0L; ++index) {
            }
            if (diff == 0L) {
                int i;
                for (i = index; i < version1Array.size(); ++i) {
                    if (Long.parseLong(version1Array.get(i)) <= 0L) continue;
                    return 1;
                }
                for (i = index; i < version2Array.size(); ++i) {
                    if (Long.parseLong(version2Array.get(i)) <= 0L) continue;
                    return -1;
                }
                return 0;
            }
            return diff > 0L ? 1 : -1;
        }
        catch (Exception e) {
            if (GameCore.debug) {
                GameCore.getInstance().getLogger().error("VersionUtils#compareVersion()", (Throwable)e);
            }
            return -1;
        }
    }
}

