/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.NonNull;

public class Download {
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.71 Safari/537.36";
    private static final int THRESHOLD = 131072;

    public static boolean download(String strUrl, File saveFile, Consumer<File> callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        if (saveFile.exists()) {
            return false;
        }
        executor.submit(() -> {
            try {
                URL url = new URL(strUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Connection", "keep-alive");
                connection.setRequestProperty("Accept", "*/*");
                connection.setRequestProperty("User-Agent", USER_AGENT);
                connection.setReadTimeout(5000);
                long len = connection.getContentLength();
                if ("chunked".equals(connection.getHeaderField("Transfer-Encoding"))) {
                    RandomAccessFile out = new RandomAccessFile(saveFile, "rw");
                    out.seek(0L);
                    byte[] b = new byte[1024];
                    InputStream in = connection.getInputStream();
                    int read = 0;
                    while ((read = in.read(b)) >= 0) {
                        out.write(b, 0, read);
                    }
                    in.close();
                    out.close();
                    if (callback == null) {
                        return;
                    }
                    callback.accept(saveFile);
                    return;
                }
                ForkJoinPool pool = new ForkJoinPool();
                pool.submit(new DownloadTask(strUrl, 0L, len, saveFile));
                pool.shutdown();
                while (!pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                }
                if (callback == null) {
                    return;
                }
                callback.accept(saveFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        executor.shutdown();
        return true;
    }

    static class DownloadTask
    extends RecursiveAction {
        private final String strUrl;
        private final File file;
        private final long start;
        private final long end;

        public DownloadTask(@NonNull String strUrl, long start, long end, File file) {
            if (strUrl == null) {
                throw new NullPointerException("strUrl is marked non-null but is null");
            }
            this.strUrl = strUrl;
            this.start = start;
            this.end = end;
            this.file = file;
        }

        @Override
        protected void compute() {
            if (this.end - this.start < 131072L) {
                HttpURLConnection connection = this.getConnection();
                connection.setRequestProperty("Range", "bytes=" + this.start + "-" + this.end);
                RandomAccessFile out = new RandomAccessFile(this.file, "rw");
                out.seek(this.start);
                InputStream in = connection.getInputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = in.read(b)) >= 0) {
                    out.write(b, 0, len);
                }
                in.close();
                out.close();
            } else {
                long mid = (this.start + this.end) / 2L;
                DownloadTask left = new DownloadTask(this.strUrl, this.start, mid, this.file);
                DownloadTask right = new DownloadTask(this.strUrl, mid, this.end, this.file);
                left.fork();
                right.fork();
            }
        }

        public HttpURLConnection getConnection() throws IOException {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.strUrl).openConnection();
            connection.setReadTimeout(5000);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestProperty("Accept", "*/*");
            connection.setRequestProperty("User-Agent", Download.USER_AGENT);
            return connection;
        }
    }
}

