/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.pathfinder.astar;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.pathfinder.api.PathFinder;
import cn.lanink.gamecore.pathfinder.astar.AstarNode;
import cn.lanink.gamecore.pathfinder.utils.BlockUtil;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.DustParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.scheduler.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class AstarPathFinder
implements PathFinder {
    public static final int DEFAULT_TIME_LIMIT = 100;
    public static final double DEFAULT_POWER = 0.5;
    private final HashMap<Block, AstarNode> open = new HashMap();
    private final HashSet<AstarNode> close = new HashSet();
    private final Position start;
    private final Position target;
    private final long timeLimit;
    private AstarNode result;
    private double power = 0.5;

    public AstarPathFinder(Position start, Position target) {
        this(start, target, 100);
    }

    public AstarPathFinder(Position start, Position target, int timeLimit) {
        this.start = start;
        this.target = target;
        this.timeLimit = timeLimit;
    }

    public AstarPathFinder(Position start, Position target, long timeLimit, double power) {
        this.start = start;
        this.target = target;
        this.timeLimit = timeLimit;
        this.power = power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public Vector3 findNext() {
        return this.find() == null || this.find().size() == 1 ? null : this.find().get(1);
    }

    @Override
    public void find(boolean async) {
        if (async) {
            Server.getInstance().getScheduler().scheduleAsyncTask((Plugin)GameCore.getInstance(), new AsyncTask(){

                public void onRun() {
                    AstarPathFinder.this.find();
                }
            });
        } else {
            this.find();
        }
    }

    @Override
    public List<Vector3> find() {
        long timeStart = System.currentTimeMillis();
        AstarNode startNode = new AstarNode(this.start, 0.0, BlockUtil.MHDistance((Vector3)this.start, (Vector3)this.target), null);
        this.open.put(startNode.levelBlock, startNode);
        while (!this.open.isEmpty() && System.currentTimeMillis() - timeStart <= this.timeLimit) {
            AstarNode minFNode = this.getMinFNode(this.power);
            if (minFNode.equals(this.target)) {
                this.result = minFNode;
                break;
            }
            this.open.remove(minFNode.levelBlock);
            this.close.add(minFNode);
            for (AstarNode nextNode : minFNode.getNextAccessibleNodes(this.target)) {
                if (this.close.contains(nextNode)) continue;
                if (this.open.containsKey(nextNode.levelBlock)) {
                    this.open.get(nextNode.levelBlock).update(nextNode);
                    continue;
                }
                this.open.put(nextNode.levelBlock, nextNode);
            }
        }
        return this.result == null ? null : this.getResult();
    }

    @Override
    public void show() {
        if (this.result != null) {
            this.getResultNode().forEach(astarNode -> Server.getInstance().getScheduler().scheduleRepeatingTask(new Task((AstarNode)astarNode){
                final /* synthetic */ AstarNode val$astarNode;
                {
                    this.val$astarNode = astarNode;
                }

                public void onRun(int i) {
                    this.val$astarNode.position.getLevel().addParticle((Particle)new DustParticle((Vector3)this.val$astarNode.levelBlock.add(0.5, 0.2, 0.5), 255, 0, 0));
                }
            }, 10));
        }
    }

    public List<AstarNode> getResultNode() {
        ArrayList<AstarNode> ret = new ArrayList<AstarNode>();
        AstarNode node = this.result;
        while (node != null) {
            ret.add(0, node);
            node = node.parent;
        }
        return ret;
    }

    @Override
    public List<Vector3> getResult() {
        ArrayList<Vector3> ret = new ArrayList<Vector3>();
        AstarNode node = this.result;
        while (node != null) {
            ret.add(0, (Vector3)node.position);
            node = node.parent;
        }
        return ret;
    }

    private AstarNode getMinFNode(double power) {
        double minF = Double.MAX_VALUE;
        AstarNode ret = null;
        for (AstarNode node : this.open.values()) {
            double f = node.getF(power);
            if (!(f < minF)) continue;
            ret = node;
            minF = f;
        }
        return ret;
    }
}

