/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.form.inventory.advanced;

import cn.lanink.gamecore.form.inventory.advanced.AdvancedChestInventory;
import cn.lanink.gamecore.form.inventory.advanced.AdvancedInventory;
import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.BlockEntityDataPacket;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.AsyncTask;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class AdvancedFakeChestInventory
extends AdvancedChestInventory {
    private static final ConcurrentHashMap<Player, AdvancedInventory> OPEN = new ConcurrentHashMap();
    private final HashMap<String, List<BlockVector3>> blockPositions = new HashMap();

    public AdvancedFakeChestInventory(String title) {
        super(new FakeEntity(), InventoryType.CHEST, new HashMap<Integer, Item>(), InventoryType.CHEST.getDefaultSize(), title);
        ((FakeEntity)this.getHolder()).setInventory((Inventory)this);
    }

    protected UpdateBlockPacket getDefaultPack(int protocolId, int id, BlockVector3 pos) {
        UpdateBlockPacket updateBlock = new UpdateBlockPacket();
        updateBlock.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId((int)protocolId, (int)id, (int)0);
        updateBlock.flags = 11;
        updateBlock.x = pos.x;
        updateBlock.y = pos.y;
        updateBlock.z = pos.z;
        return updateBlock;
    }

    public void onOpen(Player who) {
        this.viewers.add(who);
        if (OPEN.putIfAbsent(who, this) != null) {
            return;
        }
        List<BlockVector3> blocks = this.onOpenBlock(who);
        this.blockPositions.put(who.getName(), blocks);
        this.onFakeOpen(who, blocks);
    }

    protected void onFakeOpen(Player who, List<BlockVector3> blocks) {
        BlockVector3 blockPosition = blocks.isEmpty() ? new BlockVector3(0, 0, 0) : blocks.get(0);
        ContainerOpenPacket containerOpen = new ContainerOpenPacket();
        containerOpen.windowId = who.getWindowId((Inventory)this);
        containerOpen.type = this.getType().getNetworkType();
        containerOpen.x = blockPosition.x;
        containerOpen.y = blockPosition.y;
        containerOpen.z = blockPosition.z;
        who.dataPacket((DataPacket)containerOpen);
        this.sendContents(who);
    }

    protected List<BlockVector3> onOpenBlock(Player who) {
        BlockVector3 blockPosition = new BlockVector3((int)who.x, who.getFloorY() + 3, (int)who.z);
        this.placeFakeChest(who, blockPosition);
        return Collections.singletonList(blockPosition);
    }

    protected void placeFakeChest(Player who, BlockVector3 pos) {
        who.dataPacket((DataPacket)this.getDefaultPack(who.protocol, 54, pos));
        BlockEntityDataPacket blockEntityData = new BlockEntityDataPacket();
        blockEntityData.x = pos.x;
        blockEntityData.y = pos.y;
        blockEntityData.z = pos.z;
        blockEntityData.namedTag = AdvancedFakeChestInventory.getNbt(pos, this.getName());
        who.dataPacket((DataPacket)blockEntityData);
    }

    protected static byte[] getNbt(BlockVector3 pos, String name) {
        CompoundTag tag = new CompoundTag().putString("id", BlockEntity.CHEST).putInt("x", pos.x).putInt("y", pos.y).putInt("z", pos.z).putString("CustomName", name == null ? "Chest" : name);
        try {
            return NBTIO.write((CompoundTag)tag, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create NBT for chest");
        }
    }

    public void onClose(final Player who) {
        super.onClose(who);
        OPEN.remove(who, (Object)this);
        try {
            if (this.blockPositions.containsKey(who.getName())) {
                final List<BlockVector3> blocks = this.blockPositions.get(who.getName());
                int i = 0;
                int size = blocks.size();
                while (i < size) {
                    final int index = i++;
                    Server.getInstance().getScheduler().scheduleAsyncTask((Plugin)GAME_CORE, new AsyncTask(){

                        public void onRun() {
                            Vector3 blockPosition = ((BlockVector3)blocks.get(index)).asVector3();
                            UpdateBlockPacket updateBlock = new UpdateBlockPacket();
                            updateBlock.blockRuntimeId = GlobalBlockPalette.getOrCreateRuntimeId((int)who.protocol, (int)who.getLevel().getBlock(blockPosition).getFullId());
                            updateBlock.flags = 11;
                            updateBlock.x = blockPosition.getFloorX();
                            updateBlock.y = blockPosition.getFloorY();
                            updateBlock.z = blockPosition.getFloorZ();
                            who.dataPacket((DataPacket)updateBlock);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class FakeEntity
    implements InventoryHolder {
        private Inventory inventory;

        private FakeEntity() {
        }

        public void setInventory(Inventory inventory) {
            this.inventory = inventory;
        }

        public Inventory getInventory() {
            return this.inventory;
        }
    }
}

