/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.form.element;

import cn.lanink.gamecore.form.response.FormResponseDialog;
import cn.nukkit.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class ResponseElementDialogButton {
    private String button_name;
    private String text;
    private List<CmdLine> data;
    private transient BiConsumer<Player, FormResponseDialog> clickedListener;
    private int mode;
    private int type;

    public ResponseElementDialogButton onClicked(@NotNull BiConsumer<Player, FormResponseDialog> clickedListener) {
        this.clickedListener = Objects.requireNonNull(clickedListener);
        return this;
    }

    public boolean callClicked(@NotNull Player player, FormResponseDialog response) {
        if (this.clickedListener != null) {
            this.clickedListener.accept(player, response);
            return true;
        }
        return false;
    }

    public ResponseElementDialogButton(String name, String text) {
        this(name, text, Mode.BUTTON_MODE);
    }

    public ResponseElementDialogButton(String name, String text, Mode mode) {
        this(name, text, mode, 1);
    }

    public ResponseElementDialogButton(String name, String text, Mode mode, int type) {
        this.button_name = name;
        this.text = text;
        this.data = this.updateButtonData();
        this.mode = mode.ordinal();
        this.type = type;
    }

    public List<CmdLine> updateButtonData() {
        String[] split;
        ArrayList<CmdLine> list = new ArrayList<CmdLine>();
        for (String str : split = this.text.split("\n")) {
            list.add(new CmdLine(str, 19));
        }
        return list;
    }

    public String getName() {
        return this.button_name;
    }

    public void setName(String name) {
        this.button_name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<CmdLine> getData() {
        this.data = this.updateButtonData();
        return this.data;
    }

    public Mode getMode() {
        switch (this.mode) {
            case 0: {
                return Mode.BUTTON_MODE;
            }
            case 1: {
                return Mode.ON_EXIT;
            }
            case 2: {
                return Mode.ON_ENTER;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.mode);
    }

    public void setMode(Mode mode) {
        this.mode = mode.ordinal();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static enum Mode {
        BUTTON_MODE,
        ON_EXIT,
        ON_ENTER;

    }

    public static class CmdLine {
        public String cmd_line;
        public int cmd_ver;
        public static final int CMD_VER = 19;

        public CmdLine(String cmd_line, int cmd_ver) {
            this.cmd_line = cmd_line;
            this.cmd_ver = cmd_ver;
        }
    }
}

