/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.floatingtext;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.entity.TextFakeTextFakeEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.Position;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.scheduler.PluginTask;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FloatingTextUtils {
    private static final HashMap<Long, TextFakeTextFakeEntity> ENTITY_MAP = new HashMap();

    public static TextFakeTextFakeEntity showTextTemporary(@NotNull Position position, @NotNull String showText, int showTick) {
        TextFakeTextFakeEntity textFakeEntity = new TextFakeTextFakeEntity(FloatingTextUtils.getIdleID());
        textFakeEntity.setPosition(position);
        textFakeEntity.setShowText(showText);
        if (showTick > 0) {
            textFakeEntity.setSurviveTick(showTick);
        }
        ENTITY_MAP.put(textFakeEntity.getId(), textFakeEntity);
        return textFakeEntity;
    }

    public static long getIdleID() {
        for (Map.Entry<Long, TextFakeTextFakeEntity> entry : ENTITY_MAP.entrySet()) {
            if (!entry.getValue().isClosed()) continue;
            return entry.getKey();
        }
        return Entity.entityCount++;
    }

    public static class AsyncTickTask
    extends AsyncTask {
        private int tick = 0;

        public void onRun() {
            while (GameCore.getInstance().isEnabled()) {
                long startTime = System.currentTimeMillis();
                try {
                    this.work(this.tick);
                }
                catch (Exception e) {
                    GameCore.getInstance().getLogger().error("FloatingTextUtils-AsyncTickTask", (Throwable)e);
                }
                long duration = System.currentTimeMillis() - startTime;
                try {
                    Thread.sleep(Math.max(50L - duration, 1L));
                }
                catch (Exception e) {
                    GameCore.getInstance().getLogger().error("FloatingTextUtils-AsyncTickTask", (Throwable)e);
                }
                ++this.tick;
            }
            for (TextFakeTextFakeEntity textFakeEntity : ENTITY_MAP.values()) {
                textFakeEntity.close();
            }
        }

        private void work(int tick) {
            for (TextFakeTextFakeEntity textFakeEntity : ENTITY_MAP.values()) {
                try {
                    if (!textFakeEntity.needAsyncTick()) continue;
                    textFakeEntity.onAsyncTick(tick);
                }
                catch (Exception e) {
                    GameCore.getInstance().getLogger().error("FloatingTextUtils-AsyncTickTask", (Throwable)e);
                }
            }
        }
    }

    public static class TickTask
    extends PluginTask<GameCore> {
        public TickTask(GameCore owner) {
            super((Plugin)owner);
        }

        public void onRun(int i) {
            for (TextFakeTextFakeEntity textFakeEntity : ENTITY_MAP.values()) {
                try {
                    if (!textFakeEntity.needTick()) continue;
                    textFakeEntity.onTick(i);
                }
                catch (Exception e) {
                    GameCore.getInstance().getLogger().error("FloatingTextUtils-TickTask", (Throwable)e);
                }
            }
        }
    }
}

