/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.level.Location;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BinaryStream;
import lib.net.easecation.ghosty.entity.PlaybackNPC;
import lib.net.easecation.ghosty.recording.RecordNode;
import lib.net.easecation.ghosty.recording.Updated;

class UpdatedPositionXYZ
implements Updated {
    private double x;
    private double y;
    private double z;

    static UpdatedPositionXYZ of(double x, double y, double z) {
        return new UpdatedPositionXYZ(x, y, z);
    }

    @Override
    public int getUpdateTypeId() {
        return 0;
    }

    @Override
    public void processTo(PlaybackNPC ghost) {
        Location location = ghost.getLocation();
        location.x = this.x;
        location.y = this.y;
        location.z = this.z;
        ghost.teleport(location);
    }

    @Override
    public RecordNode applyTo(RecordNode node) {
        node.setX(this.x);
        node.setY(this.y);
        node.setZ(this.z);
        return node;
    }

    public UpdatedPositionXYZ(BinaryStream stream) {
        this.read(stream);
    }

    private UpdatedPositionXYZ(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3 asVector3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdatedPositionXYZ)) {
            return false;
        }
        UpdatedPositionXYZ o = (UpdatedPositionXYZ)obj;
        return this.x == o.x && this.y == o.y && this.z == o.z;
    }

    @Override
    public void write(BinaryStream stream) {
        stream.putFloat((float)this.x);
        stream.putFloat((float)this.y);
        stream.putFloat((float)this.z);
    }

    @Override
    public void read(BinaryStream stream) {
        this.x = stream.getFloat();
        this.y = stream.getFloat();
        this.z = stream.getFloat();
    }
}

