/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.TaskHandler;
import java.util.function.Function;
import lib.net.easecation.ghosty.recording.LmlPlayerRecord;
import lib.net.easecation.ghosty.recording.PlayerRecord;
import lib.net.easecation.ghosty.recording.RecordNode;

public class RecordEngine {
    private final Player player;
    private final TaskHandler taskHandler;
    private int tick = 0;
    private boolean recording = true;
    private boolean stopped = false;
    private PlayerRecord record;

    public RecordEngine(Plugin plugin, Player player) {
        this(plugin, player, LmlPlayerRecord::new);
    }

    public RecordEngine(Plugin plugin, Player player, Function<Player, PlayerRecord> recordFactory) {
        this.player = player;
        this.record = recordFactory.apply(player);
        this.taskHandler = Server.getInstance().getScheduler().scheduleRepeatingTask(plugin, this::onTick, 1);
        Server.getInstance().getLogger().warning(player.getName() + " Record started!");
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void onTick() {
        if (this.isRecording()) {
            if (!this.player.isOnline()) {
                this.stopRecord();
            }
            this.record.record(this.tick, RecordNode.of(this.player));
        }
        ++this.tick;
    }

    public PlayerRecord stopRecord() {
        this.setRecording(false);
        this.stopped = true;
        Server.getInstance().getLogger().warning(this.player.getName() + " Record stopped!");
        this.taskHandler.cancel();
        return this.record;
    }
}

