/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.entity.data.Skin;
import cn.nukkit.utils.BinaryStream;
import java.util.Base64;
import lib.net.easecation.ghosty.recording.LmlPlayerRecord;
import lib.net.easecation.ghosty.recording.RecordIterator;
import lib.net.easecation.ghosty.recording.RecordNode;
import lib.net.easecation.ghosty.recording.SkinlessPlayerRecord;

public interface PlayerRecord {
    public static final byte OBJECT_LML = 0;
    public static final byte OBJECT_SKINLESS = 1;

    public void record(long var1, RecordNode var3);

    public RecordIterator iterator();

    public String getPlayerName();

    public Skin getSkin();

    default public String toBase64String() {
        return Base64.getEncoder().encodeToString(this.toBinary());
    }

    public byte[] toBinary();

    public static PlayerRecord fromBase64String(String string) {
        return PlayerRecord.fromBinary(Base64.getDecoder().decode(string));
    }

    public static PlayerRecord fromBinary(byte[] data) {
        BinaryStream stream = new BinaryStream(data);
        byte type = (byte)stream.getByte();
        switch (type) {
            case 0: {
                return new LmlPlayerRecord(stream);
            }
            case 1: {
                return new SkinlessPlayerRecord(stream);
            }
        }
        return null;
    }
}

