/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.nukkit.Server;

public class NukkitTypeUtils {
    private static final NukkitType nukkitType;

    public static NukkitType getNukkitType() {
        return nukkitType;
    }

    static {
        NukkitType nukkitTypeCache;
        switch (Server.getInstance().getCodename().toLowerCase()) {
            case "powernukkitx": {
                try {
                    Class.forName("cn.nukkit.api.PowerNukkitXOnly");
                    nukkitTypeCache = NukkitType.POWER_NUKKIT_X;
                }
                catch (ClassNotFoundException ignored) {
                    nukkitTypeCache = NukkitType.POWER_NUKKIT_X_2;
                }
                break;
            }
            case "powernukkit": {
                nukkitTypeCache = NukkitType.POWER_NUKKIT;
                break;
            }
            case "pm1e": {
                nukkitTypeCache = NukkitType.PM1E;
                break;
            }
            case "mot": {
                nukkitTypeCache = NukkitType.MOT;
                break;
            }
            default: {
                nukkitTypeCache = NukkitType.NUKKITX;
            }
        }
        nukkitType = nukkitTypeCache;
    }

    public static enum NukkitType {
        NUKKITX("NukkitX"),
        POWER_NUKKIT("PowerNukkit"),
        POWER_NUKKIT_X("PowerNukkitX"),
        POWER_NUKKIT_X_2("PowerNukkitX2"),
        PM1E("Nukkit PetteriM1 Edition"),
        MOT("Nukkit MOT");

        private final String showName;

        private NukkitType(String showName) {
            this.showName = showName;
        }

        public String getShowName() {
            return this.showName;
        }
    }
}

