/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.room;

import cn.lanink.gamecore.room.GameRoom;
import cn.nukkit.level.Level;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class GameRoomManager<T extends GameRoom> {
    private final ConcurrentHashMap<String, T> gameRoomMap = new ConcurrentHashMap();

    public boolean hasGameRoom(Level level) {
        return this.hasGameRoom(level.getFolderName());
    }

    public boolean hasGameRoom(String world) {
        return this.gameRoomMap.containsKey(world);
    }

    public void addGameRoom(Level level, T gameRoom) {
        this.addGameRoom(level.getFolderName(), gameRoom);
    }

    public void addGameRoom(String level, T gameRoom) {
        this.gameRoomMap.put(level, gameRoom);
    }

    public void removeGameRoom(Level level) {
        this.removeGameRoom(level.getFolderName());
    }

    public void removeGameRoom(String level) {
        this.gameRoomMap.remove(level);
    }

    public T getGameRoom(Level level) {
        return this.getGameRoom(level.getFolderName());
    }

    public T getGameRoom(String level) {
        return (T)((GameRoom)this.gameRoomMap.get(level));
    }

    public ConcurrentHashMap<String, T> getGameRoomMap() {
        return this.gameRoomMap;
    }

    public boolean loadGameRoom(Level level) {
        return this.loadGameRoom(level.getFolderName());
    }

    public boolean loadGameRoom(String level) {
        return !this.gameRoomMap.containsKey(level);
    }

    public boolean unloadGameRoom(Level level) {
        return this.unloadGameRoom(level.getFolderName());
    }

    public boolean unloadGameRoom(String world) {
        this.gameRoomMap.remove(world);
        return true;
    }

    public T getCanJoinGameRoom() {
        return null;
    }

    public List<T> getCanJoinGameRoomList() {
        return new ArrayList<T>(this.gameRoomMap.values());
    }
}

