/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.entity;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.entity.ITextFakeEntity;
import cn.lanink.gamecore.utils.EntityUtils;
import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.EntityData;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.level.Position;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.MoveEntityAbsolutePacket;
import cn.nukkit.network.protocol.RemoveEntityPacket;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class TextFakeTextFakeEntity
extends Position
implements ITextFakeEntity {
    protected final long id;
    public static final EntityMetadata entityMetadata = new EntityMetadata().putLong(EntityUtils.getEntityField("DATA_FLAGS", 0).intValue(), 0L).putByte(EntityUtils.getEntityField("DATA_COLOR", 3).intValue(), 0).putString(EntityUtils.getEntityField("DATA_NAMETAG", 4).intValue(), "").putLong(EntityUtils.getEntityField("DATA_LEAD_HOLDER_EID", 37).intValue(), -1L).putFloat(EntityUtils.getEntityField("DATA_SCALE", 38).intValue(), 1.0f).putBoolean(EntityUtils.getEntityField("DATA_ALWAYS_SHOW_NAMETAG", 81).intValue(), true);
    private boolean closed = false;
    private long surviveTick = -1L;
    private final Set<Player> hasSpawned = Collections.newSetFromMap(new ConcurrentHashMap());
    protected String defaultShowText;
    protected final Map<Player, String> showTextMap = new ConcurrentHashMap<Player, String>();
    private int maxCanSeeDistance = 16 * Server.getInstance().getViewDistance();

    public TextFakeTextFakeEntity() {
        this.id = Entity.entityCount++;
    }

    public TextFakeTextFakeEntity(long id) {
        this.id = id;
    }

    @Override
    public void setPosition(@NotNull Position position) {
        this.x = position.getX();
        this.y = position.getY();
        this.z = position.getZ();
        this.setLevel(position.getLevel());
        MoveEntityAbsolutePacket pk = new MoveEntityAbsolutePacket();
        pk.eid = this.getId();
        pk.x = this.getX();
        pk.y = this.getY();
        pk.z = this.getZ();
        pk.yaw = 0.0;
        pk.headYaw = 0.0;
        pk.pitch = 0.0;
        for (Player player : this.hasSpawned) {
            player.dataPacket(pk.clone());
        }
    }

    @Override
    public Position getPosition() {
        return this;
    }

    public void setShowText(@NotNull String showText) {
        this.defaultShowText = showText;
    }

    @Override
    public void setShowText(@NotNull Player player, @NotNull String showText) {
        this.showTextMap.put(player, showText);
    }

    @Override
    public void setMaxCanSeeDistance(int maxCanSeeDistance) {
        if (maxCanSeeDistance < 1) {
            maxCanSeeDistance = 1;
        }
        this.maxCanSeeDistance = maxCanSeeDistance;
    }

    @Override
    public boolean needTick() {
        return false;
    }

    @Override
    public void onTick(int i) {
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            GameCore.getInstance().getLogger().error("\u9519\u8bef\u8c03\u7528\uff01", (Throwable)e);
            return;
        }
    }

    @Override
    public boolean needAsyncTick() {
        return true;
    }

    @Override
    public void onAsyncTick(int i) {
        if (this.isClosed() || i % 20 != 0) {
            return;
        }
        if (this.surviveTick > 0L) {
            --this.surviveTick;
            if (this.surviveTick == 0L) {
                this.close();
                return;
            }
        }
        if (this.hasDefaultShowText()) {
            for (Player player : this.getPosition().getLevel().getPlayers().values()) {
                if (this.showTextMap.containsKey(player) || this.distance((Vector3)player) > (double)this.getMaxCanSeeDistance()) continue;
                if (!this.hasSpawned.contains(player) || i % 2400 == 0) {
                    this.spawnTo(player);
                }
                this.sendText(player, this.getDefaultShowText());
            }
        }
        for (Map.Entry<Object, String> entry : this.getShowTextMap().entrySet()) {
            if (((Player)entry.getKey()).getLevel() != this.getLevel() || !(this.distance((Vector3)entry.getKey()) <= (double)this.getMaxCanSeeDistance())) continue;
            if (!this.hasSpawned.contains(entry.getKey()) || i % 2400 == 0) {
                this.spawnTo((Player)entry.getKey());
            }
            this.sendText((Player)entry.getKey(), entry.getValue());
        }
        for (Player player : this.hasSpawned) {
            if ((this.getShowTextMap().containsKey(player) || this.hasDefaultShowText()) && player.isOnline() && player.getLevel() == this.getLevel() && !(this.distance((Vector3)player) > (double)this.getMaxCanSeeDistance())) continue;
            this.despawnFrom(player);
        }
    }

    public boolean hasDefaultShowText() {
        return this.defaultShowText != null && !this.defaultShowText.isEmpty();
    }

    @Override
    public void spawnTo(@NotNull Player player) {
        if (this.hasSpawned.contains(player)) {
            this.despawnFrom(player);
        }
        this.hasSpawned.add(player);
        AddEntityPacket pk = new AddEntityPacket();
        pk.entityRuntimeId = this.getId();
        pk.entityUniqueId = this.getId();
        pk.type = 64;
        pk.yaw = 0.0f;
        pk.headYaw = 0.0f;
        pk.pitch = 0.0f;
        pk.x = (float)this.getX();
        pk.y = (float)this.getY();
        pk.z = (float)this.getZ();
        pk.speedX = 0.0f;
        pk.speedY = 0.0f;
        pk.speedZ = 0.0f;
        pk.metadata = entityMetadata;
        player.dataPacket((DataPacket)pk);
    }

    @Override
    public void despawnFrom(@NotNull Player player) {
        if (this.hasSpawned.contains(player)) {
            RemoveEntityPacket pk = new RemoveEntityPacket();
            pk.eid = this.getId();
            player.dataPacket((DataPacket)pk);
            this.hasSpawned.remove(player);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.getShowTextMap().clear();
        for (Player player : this.hasSpawned) {
            this.despawnFrom(player);
        }
    }

    private void sendText(@NotNull Player player, @NotNull String string) {
        this.sendData(new Player[]{player}, new EntityMetadata().putString(EntityUtils.getEntityField("DATA_NAMETAG", 4).intValue(), string));
    }

    private void sendData(@NotNull Player[] players, @NotNull EntityMetadata data) {
        SetEntityDataPacket pk = new SetEntityDataPacket();
        pk.eid = this.getId();
        pk.metadata = data;
        for (Player player : players) {
            if (!this.hasSpawned.contains(player)) continue;
            player.dataPacket(pk.clone());
        }
    }

    public long getId() {
        return this.id;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSurviveTick(long surviveTick) {
        this.surviveTick = surviveTick;
    }

    public long getSurviveTick() {
        return this.surviveTick;
    }

    public String getDefaultShowText() {
        return this.defaultShowText;
    }

    @Override
    public Map<Player, String> getShowTextMap() {
        return this.showTextMap;
    }

    public int getMaxCanSeeDistance() {
        return this.maxCanSeeDistance;
    }

    static {
        long flags = entityMetadata.getLong(EntityUtils.getEntityField("DATA_FLAGS", 0).intValue());
        entityMetadata.put((EntityData)new LongEntityData(EntityUtils.getEntityField("DATA_FLAGS", 0).intValue(), flags ^= 1L << EntityUtils.getEntityField("DATA_FLAG_IMMOBILE", 16)));
    }
}

